/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.krippendorff.renderer.console;

import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.krippendorff.alphaClu2013.Bootstrapping;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class BootrstapRenderer {
    public static String render(Bootstrapping boostrap) throws MeasureException {
        DecimalFormat formatAlpha = new DecimalFormat("0.000");
        DecimalFormat formatAlpha4 = new DecimalFormat("0.0000");
        DecimalFormat formatPercent = new DecimalFormat("##0.00");
        DecimalFormat formatPercent4 = new DecimalFormat("##0.###");
        boostrap.bootstrap();
        String out = "### Distribution of bootstrapped alphas ###\n";
        out = out + "Confidence Interval (" + (100.0 - 100.0 * boostrap.getpLevel()) + "%) " + formatAlpha4.format(boostrap.calculateAlphaSmallest()) + " to " + formatAlpha4.format(boostrap.calculateAlphaLargest()) + '\n';
        out = out + "Minimum : " + formatAlpha4.format(boostrap.calculateMinimum()) + "\n";
        out = out + "Maximum : " + formatAlpha4.format(boostrap.calculateMaximum()) + "\n";
        out = out + "Probability Q (Alpha = " + boostrap.getAlphaMin() + "): " + formatAlpha4.format(1.0 - boostrap.calculateQProbability()) + " (" + formatPercent4.format(boostrap.calculateQProbability() * 100.0) + " %)\n";
        Map<Double, Double> bootstrapDatas = boostrap.getBootstrapDatas();
        ArrayList<Double> alphas = new ArrayList<Double>(bootstrapDatas.keySet());
        Collections.sort(alphas);
        return out;
    }
}

