/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.krippendorff.alphaClu2013.metrics;

import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.AbstractMetric2013;
import fr.unicaen.measure.model.IAnnotationSet;
import fr.unicaen.measure.model.ICorpus;
import java.util.ArrayList;
import java.util.Map;

public class Metric2013Ordinal
extends AbstractMetric2013 {
    private double[][] values;

    public Metric2013Ordinal(ICorpus corpus) {
        super(new ArrayList<String>(corpus.getUnitSet().getAnnotationSetByCategory().keySet()), 0);
        int dim = this.categories.keySet().size();
        this.values = new double[dim][dim];
        Map map = corpus.getUnitSet().getAnnotationSetByCategory();
        double[] frequences = new double[dim];
        for (String cat : this.categories.keySet()) {
            frequences[this.getIndex((String)cat)] = ((IAnnotationSet)map.get(cat)).getAnnotations().size();
        }
        for (String catI : this.categories.keySet()) {
            for (String catJ : this.categories.keySet()) {
                int i = this.getIndex(catI);
                int j = this.getIndex(catJ);
                double sum = 0.0;
                for (int k = Math.min(i, j); k <= Math.max(i, j); ++k) {
                    sum += frequences[k];
                }
                this.values[i][j] = Math.pow(sum - (frequences[i] + frequences[j]) / 2.0, 2.0);
            }
        }
    }

    @Override
    public double getMetric(String g, String h) {
        int indexG = this.getIndex(g);
        int indexH = this.getIndex(h);
        return this.values[indexG][indexH];
    }
}

