/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.krippendorff.alphaClu2013.metrics;

import com.jacksay.matrix.MatrixNumeric;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013;
import fr.unicaen.measure.model.IUnit;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class AbstractMetric2013
implements Metric2013 {
    protected SortedMap<String, Integer> categories = new TreeMap<String, Integer>();

    public AbstractMetric2013(List<String> categories) {
        this(categories, 0);
    }

    public AbstractMetric2013(List<String> categories, int beginIndex) {
        int index = beginIndex;
        Collections.sort(categories);
        for (String c : categories) {
            this.categories.put(c, index++);
        }
    }

    @Override
    public MatrixNumeric<String> getMatrix() {
        MatrixNumeric matrix = new MatrixNumeric(this.categories.keySet(), false, Double.valueOf(0.0));
        for (String g : this.categories.keySet()) {
            for (String h : this.categories.keySet()) {
                matrix.setValue((Object)g, (Object)h, (Object)this.getMetric(g, h));
            }
        }
        return matrix;
    }

    protected int getIndex(String category) {
        return (Integer)this.categories.get(category);
    }

    protected int getIndex(IUnit unit) {
        return this.getIndex(unit.getCategory());
    }

    public String toString() {
        System.out.println(this.categories);
        String out = "";
        String head = "\t";
        for (Map.Entry<String, Integer> row : this.categories.entrySet()) {
            head = head + "| " + row.getKey() + "  \t";
            out = out + row.getKey() + "  \t";
            for (Map.Entry<String, Integer> col : this.categories.entrySet()) {
                out = out + "| " + DecimalFormat.getInstance().format(this.getMetric(row.getKey(), col.getKey())) + "\t";
            }
            out = out + "\n";
        }
        return head + "\n" + out;
    }
}

