/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.krippendorff.alphaClu2013;

import com.jacksay.matrix.MatrixNumeric;
import fr.unicaen.measure.core.IMeasure;
import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013Nominal;
import fr.unicaen.measure.model.AnnotationSetImpl;
import fr.unicaen.measure.model.IAnnotation;
import fr.unicaen.measure.model.IAnnotationSet;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.IUnit;
import fr.unicaen.measure.model.UnitImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KrippendorffAlphaClU
implements IMeasure {
    private MatrixNumeric<String> observedMatrix;
    private MatrixNumeric<String> expectedMatrix;
    private List<String> categories;
    private List<String> authors;
    private Metric2013 metric;
    private Map<String, IAnnotationSet<IUnit>> continuums;
    protected int continumSize;
    protected int continuumBegin = 0;
    protected int numberOfIntersections = 0;
    public static String NA = "n-a";
    private double cluDo;
    private double cluDe;
    private double total;
    private int nbrUnits;

    public KrippendorffAlphaClU(Metric2013 metric) {
        this.metric = metric;
        this.authors = new ArrayList<String>();
        this.categories = new ArrayList<String>();
    }

    public KrippendorffAlphaClU() {
        this(new Metric2013Nominal());
    }

    public double measure(ICorpus corpus) throws MeasureException {
        this.setCorpus(corpus.clone());
        this.total = 0.0;
        this.cluDe = 0.0;
        this.cluDo = 0.0;
        double observed = 0.0;
        double cluDeNumerator = 0.0;
        double cluDeDenominator = this.getCluDeDenominator(this.continuums);
        for (int i = 0; i < this.categories.size(); ++i) {
            String c = this.categories.get(i);
            for (int j = i; j < this.categories.size(); ++j) {
                String k = this.categories.get(j);
                double metricTotal = this.getMetric(c, k);
                if (metricTotal == 0.0) continue;
                observed += metricTotal * (Double)this.observedMatrix.getValue((Object)c, (Object)k);
                cluDeNumerator += this.getObservedTotalLine(c) * this.getObservedTotalLine(k) * metricTotal;
            }
        }
        this.cluDe = 2.0 * cluDeNumerator / cluDeDenominator;
        this.cluDo = observed * 2.0 / this.getObservedTotal();
        this.total = 1.0 - this.cluDo / this.cluDe;
        return this.total;
    }

    public MatrixNumeric<String> getObservedMatrix() {
        return this.observedMatrix;
    }

    public MatrixNumeric<String> getExpectedMatrix() {
        return this.expectedMatrix;
    }

    public double getMetric(String c, String k) {
        return this.metric.getMetric(c, k);
    }

    public Metric2013 getMetric() {
        return this.metric;
    }

    public double getTotal() {
        return this.total;
    }

    public double getCluDo() {
        return this.cluDo;
    }

    public double getCluDe() {
        return this.cluDe;
    }

    public int getNbrAnnotators() {
        return this.authors.size();
    }

    public int getNbrCategories() {
        return this.categories.size();
    }

    public int getNbrUnits() {
        return this.nbrUnits;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    private void setCorpus(ICorpus corpus) {
        this.authors = new ArrayList(corpus.getUnitSet().getAnnotationSetByAuthor().keySet());
        this.categories = new ArrayList(corpus.getUnitSet().getAnnotationSetByCategory().keySet());
        Collections.sort(this.categories);
        System.out.println("SetSorpus(KK)");
        this.observedMatrix = new MatrixNumeric(corpus.getUnitSet().getAnnotationSetByCategory().keySet(), Double.valueOf(0.0));
        this.expectedMatrix = new MatrixNumeric(corpus.getUnitSet().getAnnotationSetByCategory().keySet(), false, Double.valueOf(0.0));
        ArrayList<IAnnotationSet<IUnit>> annotations = new ArrayList<IAnnotationSet<IUnit>>(corpus.getUnitSet().getAnnotationSetByAuthor().values());
        this.continuums = new HashMap<String, IAnnotationSet<IUnit>>();
        this.nbrUnits = 0;
        for (IAnnotationSet iAnnotationSet : annotations) {
            this.nbrUnits += iAnnotationSet.getAnnotations().size();
        }
        this.buildContinuum(corpus);
        this.numberOfIntersections = 0;
        this.recursiveObserved(annotations);
        this.recursiveExpected(this.continuums);
    }

    public MatrixNumeric<String> getObservedCoincidencesMatrix() {
        return this.observedMatrix;
    }

    public MatrixNumeric<String> getExpectedCoincidencesMatrix() {
        return this.expectedMatrix;
    }

    protected double intersectSize(IUnit unitG, IUnit unitH) {
        return Math.min(unitH.getEndIndex(), unitG.getEndIndex()) - Math.max(unitG.getStartIndex(), unitH.getStartIndex());
    }

    protected double unitSize(IUnit u) {
        return u.getEndIndex() - u.getStartIndex();
    }

    protected void recursiveObserved(List<IAnnotationSet<IUnit>> annotations) {
        for (IAnnotationSet<IUnit> setAuthor : annotations) {
            for (IAnnotationSet<IUnit> otherAuthor : annotations) {
                if (setAuthor == otherAuthor) continue;
                for (IUnit g : setAuthor.getAnnotations()) {
                    for (IUnit h : otherAuthor.getAnnotations()) {
                        double intersect = this.intersectSize(g, h);
                        if (!(intersect > 0.0)) continue;
                        double v = (Double)this.observedMatrix.getValue((Object)g.getCategory(), (Object)h.getCategory());
                        this.observedMatrix.setValue((Object)g.getCategory(), (Object)h.getCategory(), (Object)(v += intersect));
                        ++this.numberOfIntersections;
                    }
                }
            }
        }
    }

    protected double getObservedTotalLine(String category) {
        return this.observedMatrix.getTotalLine((Object)category);
    }

    protected double getObservedTotalColumn(String category) {
        return this.observedMatrix.getTotalColunm((Object)category);
    }

    protected double getObservedTotal() {
        return this.observedMatrix.getTotal();
    }

    protected void recursiveExpected(Map<String, IAnnotationSet<IUnit>> annotations) {
        int nbrAuthor = this.getNbrAnnotators();
        double m = this.getNbrAnnotators();
        double lpp = this.getObservedTotal();
        double epsilonDemoninator = this.getEpsilonDenominator(annotations);
        for (String col : this.categories) {
            double totalCol = this.observedMatrix.getTotalLine((Object)col);
            for (String row : this.categories) {
                double cell;
                if (col.equals(row)) {
                    cell = this.getObservedNumeratorCEqualK(annotations, col) / epsilonDemoninator;
                } else {
                    double numerator = totalCol * this.observedMatrix.getTotalLine((Object)row);
                    cell = numerator / epsilonDemoninator;
                }
                this.expectedMatrix.setValue((Object)col, (Object)row, (Object)cell);
            }
        }
    }

    protected double getObservedNumeratorCEqualK(Map<String, IAnnotationSet<IUnit>> annotations, String category) {
        double result = 0.0;
        for (IAnnotationSet<IUnit> setI : annotations.values()) {
            for (IUnit g : setI.getAnnotations()) {
                if (!g.getCategory().equals(category)) continue;
                double lengthG = this.unitSize(g);
                for (IAnnotationSet<IUnit> setJ : annotations.values()) {
                    if (setI == setJ) continue;
                    for (IUnit h : setJ.getAnnotations()) {
                        double intersect;
                        if (!h.getCategory().equals(NA) || (intersect = this.intersectSize(g, h)) <= 0.0) continue;
                        lengthG -= intersect;
                    }
                }
                result += Math.pow(lengthG, 2.0);
            }
        }
        double lc = this.observedMatrix.getTotalLine((Object)category);
        double m = this.getNbrAnnotators();
        return Math.pow(lc, 2.0) - result / (m - 1.0);
    }

    protected double getCluDeDenominator(Map<String, IAnnotationSet<IUnit>> annotations) {
        double result = 0.0;
        for (IAnnotationSet<IUnit> setI : annotations.values()) {
            for (IUnit g : setI.getAnnotations()) {
                if (g.getCategory().equals(NA)) continue;
                double lengthG = this.unitSize(g);
                double substract = 0.0;
                for (IAnnotationSet<IUnit> setJ : annotations.values()) {
                    if (setI == setJ) continue;
                    for (IUnit h : setJ.getAnnotations()) {
                        double intersect;
                        if (h.getCategory().equals(NA) || (intersect = this.intersectSize(g, h)) <= 0.0) continue;
                        result += Math.pow(intersect, 2.0);
                    }
                }
            }
        }
        double out = Math.pow(this.getObservedTotal(), 2.0) - result;
        return out;
    }

    protected double getEpsilonDenominator(Map<String, IAnnotationSet<IUnit>> annotations) {
        double result = 0.0;
        for (IAnnotationSet<IUnit> setI : annotations.values()) {
            for (IUnit g : setI.getAnnotations()) {
                if (g.getCategory().equals(NA)) continue;
                double lengthG = this.unitSize(g);
                double substract = 0.0;
                for (IAnnotationSet<IUnit> setJ : annotations.values()) {
                    if (setI == setJ) continue;
                    for (IUnit h : setJ.getAnnotations()) {
                        double intersect;
                        if (!h.getCategory().equals(NA) || (intersect = this.intersectSize(g, h)) <= 0.0) continue;
                        substract += intersect;
                    }
                }
                result += Math.pow(lengthG -= substract, 2.0);
            }
        }
        double l = this.observedMatrix.getTotal();
        double m = this.getNbrAnnotators();
        return l - result / (l * (m - 1.0));
    }

    protected void buildContinuum(ICorpus corpus) {
        Map byAuthor = corpus.getUnitSet().getAnnotationSetByAuthor();
        this.continumSize = corpus.getTextSize();
        int continuumEnd = this.continuumBegin + this.continumSize;
        for (String author : byAuthor.keySet()) {
            AnnotationSetImpl continuumAuthor = new AnnotationSetImpl();
            int caret = this.continuumBegin;
            for (IUnit unit : ((IAnnotationSet)byAuthor.get(author)).getAnnotations()) {
                if (unit.getStartIndex() > caret) {
                    continuumAuthor.addAnnotation((IAnnotation)new UnitImpl(author, NA, caret, unit.getStartIndex()));
                }
                continuumAuthor.addAnnotation((IAnnotation)unit);
                caret = unit.getEndIndex();
            }
            if (caret < continuumEnd) {
                continuumAuthor.addAnnotation((IAnnotation)new UnitImpl(author, NA, caret, continuumEnd));
            }
            this.continuums.put(author, (IAnnotationSet<IUnit>)continuumAuthor);
        }
    }

    public boolean checkCorpus(ICorpus corpus) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

