/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.krippendorff.alphaClu2013;

import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.krippendorff.alpha2013.Krippendorff2013Bis;
import fr.unicaen.measure.model.IAnnotationSet;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.IUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BootstrappingU {
    public static String NA = "NA.";
    private int nIntersections;
    private ArrayList<Double> values;
    private double total;
    public static final int DEFAULT_XITERATIONS = 40000;
    public static final double DEFAULT_PLEVEL = 0.05;
    public static final double DEFAULT_ALPHAMIN = 0.8;
    private int xIterations;
    private double pLevel;
    private double alphaMin;
    private double minimumConfidenceInterval;
    private double maximumConfidenceInterval;
    private double minAlpha;
    private double maxAlpha;
    private double qPobability;
    private int pas = 500;
    private Krippendorff2013Bis alpha;
    private ICorpus corpus;
    private double[] frArray;
    private int[] bootstrapArray;
    private Map<Double, Double> bootstrapDatas;

    public double getMinimumConfidenceInterval() {
        return this.minimumConfidenceInterval;
    }

    public double getMaximumConfidenceInterval() {
        return this.maximumConfidenceInterval;
    }

    public double getqPobability() {
        return this.qPobability;
    }

    public void verbose(Object o) {
        System.out.println(o);
    }

    public int getxIterations() {
        return this.xIterations;
    }

    public double getpLevel() {
        return this.pLevel;
    }

    public double getAlphaMin() {
        return this.alphaMin;
    }

    public int getNintersections() {
        return this.nIntersections;
    }

    public Map<Double, Double> getBootstrapDatas() {
        return this.bootstrapDatas;
    }

    public BootstrappingU(Krippendorff2013Bis alpha, ICorpus corpus) {
        this(alpha, corpus, 40000, 0.05, 0.8);
    }

    public BootstrappingU(Krippendorff2013Bis alpha, ICorpus corpus, int xIterations, double pLevel, double alphaMin) {
        this.xIterations = xIterations;
        this.pLevel = pLevel;
        this.alphaMin = alphaMin;
        this.alpha = alpha;
        this.corpus = corpus;
    }

    public void setxIterations(int xIterations) {
        this.xIterations = xIterations;
    }

    public void setpLevel(double pLevel) {
        this.pLevel = pLevel;
    }

    public void bootstrap() throws MeasureException {
        this.fillValues();
        double s = 0.0;
        for (int i = 1; i < this.values.size(); ++i) {
            s += this.values.get(i).doubleValue();
        }
        System.out.println("HHHHHHHHHHH   1-total=" + (1.0 - (s /= this.total)));
        this.thirdBootstrap();
        this.maxAlpha = this.calculateMaximum();
        this.minAlpha = this.calculateMinimum();
        this.minimumConfidenceInterval = this.calculateAlphaSmallest();
        this.maximumConfidenceInterval = this.calculateAlphaLargest();
        this.qPobability = this.calculateQProbability();
        this.verbose("Min:" + this.minAlpha);
        this.verbose("Max:" + this.maxAlpha);
        this.verbose("Proba Q = " + this.qPobability);
        this.verbose("Confidence interval(" + 100.0 * (1.0 - this.pLevel) + "%): " + this.minimumConfidenceInterval + " < " + this.maximumConfidenceInterval);
        this.pas = 500;
    }

    public int getPas() {
        return this.pas;
    }

    protected void thirdBootstrap() {
        this.bootstrapArray = new int[20000];
        double moy = 0.0;
        System.out.println("nInter=" + this.nIntersections + " total=" + this.total + " size=" + this.values.size());
        for (int i = 0; i < this.getxIterations(); ++i) {
            double a = 0.0;
            for (int j = 0; j < this.nIntersections; ++j) {
                int n = (int)(Math.random() * (double)this.values.size());
                a += this.values.get(n).doubleValue();
            }
            a = 1.0 - a / this.alpha.getExpected();
            moy += a;
            int arrayIndex = (int)Math.round((a + 1.0) * 10000.0);
            if (arrayIndex >= this.bootstrapArray.length) {
                arrayIndex = this.bootstrapArray.length - 1;
            }
            if (arrayIndex < 0) {
                arrayIndex = 0;
            }
            this.bootstrapArray[arrayIndex] = this.bootstrapArray[arrayIndex] + 1;
        }
        System.out.println("moy=" + moy / (double)this.getxIterations());
        double pas = 0.025;
        int nbCases = (int)(1.0 / pas) * 2;
        double[] distribution = new double[nbCases];
        for (int i = 0; i < nbCases; ++i) {
            double sum = 0.0;
            int j = 0;
            while ((double)j < pas * 10000.0) {
                sum += (double)this.bootstrapArray[(int)((double)j + (double)(i * 10000) * pas)];
                ++j;
            }
            distribution[i] = sum / 20000.0;
        }
    }

    private static int roundFois1000(double d) {
        return (int)Math.round(d * 10000.0);
    }

    private double getFr(double data) {
        if (BootstrappingU.roundFois1000(data) >= this.frArray.length) {
            System.out.println("Probleme avec data=" + data + " round=" + BootstrappingU.roundFois1000(data));
        }
        return this.frArray[BootstrappingU.roundFois1000(data)];
    }

    public double calculateAlphaSmallest() {
        int alphaI;
        double limit = this.getpLevel() / 2.0;
        double sum = 0.0;
        for (alphaI = 1; sum < limit && alphaI < this.bootstrapArray.length; ++alphaI) {
            if (this.bootstrapArray[alphaI] <= 0) continue;
            sum += (double)this.bootstrapArray[alphaI] / (double)this.getxIterations();
        }
        return ((double)alphaI - 10001.0) / 10000.0;
    }

    public double calculateAlphaLargest() {
        int alphaI;
        double limit = this.getpLevel() / 2.0;
        double sum = 0.0;
        for (alphaI = this.bootstrapArray.length - 1; sum < limit && alphaI >= 0; --alphaI) {
            if (this.bootstrapArray[alphaI] <= 0) continue;
            sum += (double)this.bootstrapArray[alphaI] / (double)this.getxIterations();
        }
        return ((double)alphaI - 9999.0) / 10000.0;
    }

    public double calculateMinimum() throws MeasureException {
        for (int i = 0; i < this.bootstrapArray.length; ++i) {
            if (this.bootstrapArray[i] <= 0) continue;
            return ((double)i - 9999.0) / 10000.0;
        }
        throw new MeasureException("Can't calculate minimum");
    }

    public double calculateMaximum() throws MeasureException {
        for (int i = this.bootstrapArray.length - 1; i > 0; --i) {
            if (this.bootstrapArray[i] <= 0) continue;
            double cal = (double)i - 1.0;
            return ((double)i - 9999.0) / 10000.0;
        }
        throw new MeasureException("Can't calculate maximum");
    }

    public double calculateQProbability() throws MeasureException {
        int percent = 0;
        int alphaFix = (int)(this.alphaMin * 10000.0 + 10000.0);
        for (int i = this.bootstrapArray.length - 1; i > alphaFix; --i) {
            percent += this.bootstrapArray[i];
        }
        double percentT = 1.0 - (double)percent / (double)this.getxIterations();
        return percentT;
    }

    protected void fillValues() {
        this.nIntersections = 0;
        this.total = 0.0;
        this.values = new ArrayList();
        this.recursiveFillValues(new ArrayList<IAnnotationSet<IUnit>>(this.alpha.getContinuum().values()), 0);
    }

    protected void recursiveFillValues(List<IAnnotationSet<IUnit>> annotations, int set) {
        System.out.println("recursive");
        for (IUnit g : annotations.get(set).getAnnotations()) {
            for (int i = set + 1; i < annotations.size(); ++i) {
                for (IUnit h : annotations.get(i).getAnnotations()) {
                    if (!(this.intersectSize(g, h) > 0.0)) continue;
                    double value = 0.0;
                    int length = (int)Math.round(this.unionSize(g, h));
                    String gc = g.getCategory();
                    String hc = h.getCategory();
                    boolean hasContributed = false;
                    if (!gc.equals(NA) && !hc.equals(NA)) {
                        hasContributed = true;
                        value = this.unionSize(g, h) - this.intersectSize(g, h) * (1.0 - this.alpha.getMetric().getMetric(gc, hc));
                    }
                    if (!gc.equals(NA) && hc.equals(NA) && this.isFirstContainedBySecond(g, h)) {
                        hasContributed = true;
                        value = g.getEndIndex() - g.getStartIndex();
                    }
                    if (!hc.equals(NA) && gc.equals(NA) && this.isFirstContainedBySecond(h, g)) {
                        hasContributed = true;
                        value = h.getEndIndex() - h.getStartIndex();
                    }
                    if (!hasContributed) continue;
                    ++this.nIntersections;
                    this.total += (double)length;
                    this.values.add(value);
                }
            }
        }
        if (set < annotations.size() - 2) {
            this.recursiveFillValues(annotations, set + 1);
        }
    }

    protected boolean isFirstContainedBySecond(IUnit g, IUnit h) {
        return g.getStartIndex() >= h.getStartIndex() && g.getEndIndex() <= h.getEndIndex();
    }

    protected double intersectSize(IUnit unitG, IUnit unitH) {
        return Math.min(unitH.getEndIndex(), unitG.getEndIndex()) - Math.max(unitG.getStartIndex(), unitH.getStartIndex());
    }

    protected double unionSize(IUnit unitG, IUnit unitH) {
        return Math.max(unitH.getEndIndex(), unitG.getEndIndex()) - Math.min(unitG.getStartIndex(), unitH.getStartIndex());
    }

    protected double minSize(IUnit g, IUnit h) {
        return Math.min(this.unitSize(h), this.unitSize(g));
    }

    protected double maxSize(IUnit g, IUnit h) {
        return Math.max(this.unitSize(h), this.unitSize(g));
    }

    protected double unitSize(IUnit u) {
        return u.getEndIndex() - u.getStartIndex();
    }
}

