/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.krippendorff.alphaClu2013;

import com.jacksay.matrix.MatrixNumeric;
import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.krippendorff.alphaClu2013.AlphaluBase;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013;
import fr.unicaen.measure.model.ICorpus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BootstrappingClu2013 {
    public static final int DEFAULT_XITERATIONS = 10000;
    public static final double DEFAULT_PLEVEL = 0.05;
    public static final double DEFAULT_ALPHAMIN = 0.8;
    private int xIterations;
    private double pLevel;
    private double alphaMin;
    private AlphaluBase alpha;
    private ICorpus corpus;
    private double[] frArray;
    private int[] bootstrapArray;
    private Map<Double, Integer> bootstrapDatas;

    public Metric2013 getMetric() {
        return this.alpha.getMetric();
    }

    public MatrixNumeric<String> getObservedMatrix() {
        return this.alpha.getObservedCoincidencesMatrix();
    }

    public int getxIterations() {
        return this.xIterations;
    }

    public double getpLevel() {
        return this.pLevel;
    }

    public double getAlphaMin() {
        return this.alphaMin;
    }

    public int getmIntersections() {
        return this.alpha.numberOfIntersections;
    }

    public Map<Double, Integer> getBootstrapDatas() {
        return this.bootstrapDatas;
    }

    public BootstrappingClu2013(AlphaluBase alpha, ICorpus corpus) {
        this(alpha, corpus, 10000, 0.05, 0.8);
    }

    public BootstrappingClu2013(AlphaluBase alpha, ICorpus corpus, int xIterations, double pLevel, double alphaMin) {
        this.xIterations = xIterations;
        this.pLevel = pLevel;
        this.alphaMin = alphaMin;
        this.alpha = alpha;
        this.corpus = corpus;
    }

    protected void calculateMeasure() throws MeasureException {
    }

    public void bootstrap() throws MeasureException {
        this.calculateMeasure();
        this.buildFrArray();
        this.thirdBootstrap();
        double smallest = this.calculateAlphaSmallest();
        double largest = this.calculateAlphaLargest();
        System.out.println("Alpha smallest = " + smallest);
        System.out.println("Alpha largest = " + largest);
    }

    protected void thirdBootstrap() {
        int i;
        this.bootstrapArray = new int[20000];
        for (i = 0; i < this.getxIterations(); ++i) {
            double sum = 0.0;
            for (int j = 0; j < this.getmIntersections(); ++j) {
                int pickupNumber = (int)(Math.random() * (double)this.frArray.length);
                sum += this.getFr(pickupNumber);
            }
            double a = 1.0 - sum;
            if (a < -1.0) {
                a = -1.0;
            }
            int arrayIndex = (int)(a * 9999.0) + 10000;
            this.bootstrapArray[arrayIndex] = this.bootstrapArray[arrayIndex] + 1;
        }
        this.bootstrapDatas = new HashMap<Double, Integer>();
        for (i = 0; i < this.bootstrapArray.length; ++i) {
            if (this.bootstrapArray[i] <= 0) continue;
            double dataIndex = ((double)i - 10000.0) / 10000.0;
            this.bootstrapDatas.put(dataIndex, this.bootstrapArray[i]);
        }
    }

    private double getFr(int data) {
        return this.frArray[data] / ((double)this.getmIntersections() * this.alpha.getCluDe());
    }

    private void buildFrArray() {
        this.frArray = new double[(int)this.getObservedMatrix().getTotal()];
        int index = 0;
        ArrayList categories = new ArrayList(this.corpus.getUnitSet().getAnnotationSetByCategory().keySet());
        Collections.sort(categories);
        for (String c : categories) {
            for (String k : categories) {
                double cell = (Double)this.getObservedMatrix().getValue((Object)c, (Object)k);
                double metricsValue = this.getMetric().getMetric(c, k);
                int intersectCategories = (int)cell;
                for (int i = 0; i < intersectCategories; ++i) {
                    this.frArray[i + index] = metricsValue;
                }
                index += intersectCategories;
            }
        }
        System.out.println(Arrays.toString(this.frArray));
    }

    private double calculateAlphaSmallLargeEst(double limit) {
        int alphaI = 0;
        double sum = 0.0;
        while (sum < limit) {
            if (this.bootstrapArray[alphaI] > 0) {
                sum += (double)this.bootstrapArray[alphaI] / 10000.0;
            }
            ++alphaI;
        }
        return ((double)alphaI - 10000.0) / 10000.0;
    }

    private double calculateAlphaSmallest() {
        return this.calculateAlphaSmallLargeEst(this.getpLevel() / 2.0);
    }

    private double calculateAlphaLargest() {
        return this.calculateAlphaSmallLargeEst(1.0 - this.getpLevel() / 2.0);
    }
}

