/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.krippendorff.alphaClu2013;

import com.jacksay.matrix.MatrixNumeric;
import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.krippendorff.alphaClu2013.AlphaluBase;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.IUnit;
import java.util.Map;

public class Bootstrapping11Avril2015 {
    private AlphaluBase alpha;
    private long nIntersections;
    private double[] values;
    private int[] valuesRank;
    private double total;
    public static final int DEFAULT_XITERATIONS = 10000;
    public static final double DEFAULT_PLEVEL = 0.05;
    public static final double DEFAULT_ALPHAMIN = 0.8;
    private int xIterations;
    private double pLevel;
    private double alphaMin;
    private double minimumConfidenceInterval;
    private double maximumConfidenceInterval;
    private double minAlpha;
    private double maxAlpha;
    private double qPobability;
    private int pas = 500;
    private ICorpus corpus;
    private int[] bootstrapArray;
    private Map<Double, Double> bootstrapDatas;

    public double getMinimumConfidenceInterval() {
        return this.minimumConfidenceInterval;
    }

    public double getMaximumConfidenceInterval() {
        return this.maximumConfidenceInterval;
    }

    public double getqPobability() {
        return this.qPobability;
    }

    public void verbose(Object o) {
        System.out.println(o);
    }

    public int getxIterations() {
        return this.xIterations;
    }

    public double getpLevel() {
        return this.pLevel;
    }

    public double getAlphaMin() {
        return this.alphaMin;
    }

    public long getNintersections() {
        return this.nIntersections;
    }

    public Map<Double, Double> getBootstrapDatas() {
        return this.bootstrapDatas;
    }

    public Bootstrapping11Avril2015(AlphaluBase alpha, ICorpus corpus) {
        this(alpha, corpus, 10000, 0.05, 0.8);
    }

    public Bootstrapping11Avril2015(AlphaluBase alpha, ICorpus corpus, int xIterations, double pLevel, double alphaMin) {
        this.xIterations = xIterations;
        this.pLevel = pLevel;
        this.alphaMin = alphaMin;
        this.alpha = alpha;
        this.corpus = corpus;
    }

    public void setxIterations(int xIterations) {
        this.xIterations = xIterations;
    }

    public void setpLevel(double pLevel) {
        this.pLevel = pLevel;
    }

    public void bootstrap() throws MeasureException {
        this.fillValues();
        this.nIntersections = this.alpha.getNo();
        double s = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            s += this.values[i];
        }
        s /= this.total;
        this.thirdStep();
        this.maxAlpha = this.calculateMaximum();
        this.minAlpha = this.calculateMinimum();
        this.minimumConfidenceInterval = this.calculateAlphaSmallest();
        this.maximumConfidenceInterval = this.calculateAlphaLargest();
        this.qPobability = this.calculateQProbability();
        this.pas = 500;
    }

    public int getPas() {
        return this.pas;
    }

    protected void thirdStep() {
        this.bootstrapArray = new int[20001];
        double moy = 0.0;
        int m = this.alpha.getM();
        System.out.println("Dans Bootstrapping, nInter=" + this.nIntersections + " m=" + m);
        for (int i = 0; i < this.getxIterations(); ++i) {
            double a = 0.0;
            int lastN = -1;
            int n = -1;
            int lastRank = -1;
            for (int j = 0; j < m; ++j) {
                n = (int)(Math.random() * (double)this.values.length);
                while (j == 1 && lastRank == this.valuesRank[n] && this.values[n] == 0.0) {
                    n = (int)(Math.random() * (double)this.values.length);
                    lastRank = this.valuesRank[n];
                }
                if (n < 0) {
                    n = 0;
                }
                a += this.values[n];
                lastN = n;
                lastRank = this.valuesRank[n];
            }
            a = 1.0 - a;
            moy += a;
            int arrayIndex = (int)Math.round((a + 1.0) * 10000.0);
            if (arrayIndex >= this.bootstrapArray.length) {
                arrayIndex = this.bootstrapArray.length - 1;
            }
            if (arrayIndex < 0) {
                arrayIndex = 0;
            }
            this.bootstrapArray[arrayIndex] = this.bootstrapArray[arrayIndex] + 1;
        }
        double pas = 0.025;
        int nbCases = (int)(1.0 / pas) * 2;
        double[] distribution = new double[nbCases];
        for (int i = 0; i < nbCases; ++i) {
            double sum = 0.0;
            int j = 0;
            while ((double)j < pas * 10000.0) {
                sum += (double)this.bootstrapArray[(int)((double)j + (double)(i * 10000) * pas)];
                ++j;
            }
            distribution[i] = sum / 20000.0;
        }
    }

    public double calculateAlphaSmallest() {
        int alphaI;
        double limit = this.getpLevel() / 2.0;
        double sum = 0.0;
        for (alphaI = 0; sum < limit && alphaI < this.bootstrapArray.length; ++alphaI) {
            if (this.bootstrapArray[alphaI] <= 0) continue;
            sum += (double)this.bootstrapArray[alphaI] / (double)this.getxIterations();
        }
        return ((double)alphaI - 10000.0) / 10000.0;
    }

    public double calculateAlphaLargest() {
        int alphaI;
        double limit = this.getpLevel() / 2.0;
        double sum = 0.0;
        for (alphaI = this.bootstrapArray.length - 1; sum < limit && alphaI >= 0; --alphaI) {
            if (this.bootstrapArray[alphaI] <= 0) continue;
            sum += (double)this.bootstrapArray[alphaI] / (double)this.getxIterations();
        }
        return ((double)alphaI - 10000.0) / 10000.0;
    }

    public double calculateMinimum() throws MeasureException {
        for (int i = 0; i < this.bootstrapArray.length; ++i) {
            if (this.bootstrapArray[i] <= 0) continue;
            return ((double)i - 10000.0) / 10000.0;
        }
        throw new MeasureException("Can't calculate minimum");
    }

    public double calculateMaximum() throws MeasureException {
        for (int i = this.bootstrapArray.length - 1; i > 0; --i) {
            if (this.bootstrapArray[i] <= 0) continue;
            double cal = (double)i - 1.0;
            return ((double)i - 10000.0) / 10000.0;
        }
        throw new MeasureException("Can't calculate maximum");
    }

    public double calculateQProbability() throws MeasureException {
        int percent = 0;
        int alphaFix = (int)(this.alphaMin * 10000.0 + 10000.0);
        for (int i = this.bootstrapArray.length - 1; i > alphaFix; --i) {
            percent += this.bootstrapArray[i];
        }
        double percentT = 1.0 - (double)percent / (double)this.getxIterations();
        return percentT;
    }

    protected boolean isFirstContainedBySecond(IUnit g, IUnit h) {
        return g.getStartIndex() >= h.getStartIndex() && g.getEndIndex() <= h.getEndIndex();
    }

    protected double intersectSize(IUnit unitG, IUnit unitH) {
        return Math.min(unitH.getEndIndex(), unitG.getEndIndex()) - Math.max(unitG.getStartIndex(), unitH.getStartIndex());
    }

    protected double unionSize(IUnit unitG, IUnit unitH) {
        return Math.max(unitH.getEndIndex(), unitG.getEndIndex()) - Math.min(unitG.getStartIndex(), unitH.getStartIndex());
    }

    protected double minSize(IUnit g, IUnit h) {
        return Math.min(this.unitSize(h), this.unitSize(g));
    }

    protected double maxSize(IUnit g, IUnit h) {
        return Math.max(this.unitSize(h), this.unitSize(g));
    }

    protected double unitSize(IUnit u) {
        return u.getEndIndex() - u.getStartIndex();
    }

    private void fillValues() {
        int totalIntersections = (int)this.getObservedMatrix().getTotal();
        this.values = new double[totalIntersections];
        this.valuesRank = new int[this.values.length];
        int caret = 0;
        int rank = 0;
        int m = this.alpha.getM();
        for (String c : this.getObservedMatrix().getColumns()) {
            for (String k : this.getObservedMatrix().getLines()) {
                int obs = ((Double)this.getObservedMatrix().getValue((Object)c, (Object)k)).intValue();
                for (int i = 0; i < obs; ++i) {
                    this.values[caret] = this.alpha.getMetric(c, k) / (double)m / this.alpha.getCluDe();
                    this.valuesRank[caret] = rank;
                    ++caret;
                }
                ++rank;
            }
        }
        double sumTest = 0.0;
        for (int i = 1; i < this.values.length; ++i) {
            sumTest += this.values[i];
        }
    }

    public MatrixNumeric<String> getObservedMatrix() {
        return this.alpha.getObservedCoincidencesMatrix();
    }
}

