/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.krippendorff.alphaClu2013;

import com.jacksay.matrix.MatrixNumeric;
import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.krippendorff.alphaClu2013.AlphaluBase;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013;
import fr.unicaen.measure.model.ICorpus;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Bootstrapping {
    public static final int DEFAULT_XITERATIONS = 100;
    public static final double DEFAULT_PLEVEL = 0.05;
    public static final double DEFAULT_ALPHAMIN = 0.8;
    private int xIterations;
    private double pLevel;
    private double alphaMin;
    private double minimumConfidenceInterval;
    private double maximumConfidenceInterval;
    private double minAlpha;
    private double maxAlpha;
    private double qPobability;
    private int pas = 500;
    private AlphaluBase alpha;
    private ICorpus corpus;
    private double[] frArray;
    private int[] bootstrapArray;
    private Map<Double, Double> bootstrapDatas;

    public double getMinimumConfidenceInterval() {
        return this.minimumConfidenceInterval;
    }

    public double getMaximumConfidenceInterval() {
        return this.maximumConfidenceInterval;
    }

    public double getqPobability() {
        return this.qPobability;
    }

    public Metric2013 getMetric() {
        return this.alpha.getMetric();
    }

    public void verbose(Object o) {
        System.out.println(o);
    }

    public MatrixNumeric<String> getObservedMatrix() {
        return this.alpha.getObservedCoincidencesMatrix();
    }

    public int getxIterations() {
        return this.xIterations;
    }

    public double getpLevel() {
        return this.pLevel;
    }

    public double getAlphaMin() {
        return this.alphaMin;
    }

    public int getmIntersections() {
        return (int)this.alpha.getObservedCoincidencesMatrix().getTotal();
    }

    public Map<Double, Double> getBootstrapDatas() {
        return this.bootstrapDatas;
    }

    public Bootstrapping(AlphaluBase alpha, ICorpus corpus) {
        this(alpha, corpus, 100, 0.05, 0.8);
    }

    public Bootstrapping(AlphaluBase alpha, ICorpus corpus, int xIterations, double pLevel, double alphaMin) {
        this.xIterations = xIterations;
        this.pLevel = pLevel;
        this.alphaMin = alphaMin;
        this.alpha = alpha;
        this.corpus = corpus;
    }

    public void setxIterations(int xIterations) {
        this.xIterations = xIterations;
    }

    public void setpLevel(double pLevel) {
        this.pLevel = pLevel;
    }

    protected void calculateMeasure() throws MeasureException {
    }

    public void bootstrap() throws MeasureException {
        this.calculateMeasure();
        this.buildFrArray();
        double s = 0.0;
        for (int i = 1; i < this.frArray.length; ++i) {
            s += this.frArray[i];
        }
        System.out.println("MMMMMMMMMMMM    1-SumArray=" + (1.0 - s));
        this.thirdBootstrap();
        this.maxAlpha = this.calculateMaximum();
        this.minAlpha = this.calculateMinimum();
        this.minimumConfidenceInterval = this.calculateAlphaSmallest();
        this.maximumConfidenceInterval = this.calculateAlphaLargest();
        this.qPobability = this.calculateQProbability();
        this.verbose("Min:" + this.minAlpha);
        this.verbose("Max:" + this.maxAlpha);
        this.verbose("Proba Q = " + this.qPobability);
        this.verbose("Confidence interval(" + 100.0 * (1.0 - this.pLevel) + "%): " + this.minimumConfidenceInterval + " < " + this.maximumConfidenceInterval);
        this.pas = 500;
    }

    public int getPas() {
        return this.pas;
    }

    protected void thirdBootstrap() {
        this.bootstrapArray = new int[20001];
        for (int i = 0; i < this.getxIterations(); ++i) {
            double a = 0.0;
            for (int j = 0; j < this.getmIntersections(); ++j) {
                int n = 1 + (int)(Math.random() * (double)this.getmIntersections() * 10000.0);
                a += this.frArray[n];
            }
            int arrayIndex = (int)Math.round(((a = 1.0 - a) + 1.0) * 10000.0);
            if (arrayIndex >= this.bootstrapArray.length) {
                arrayIndex = this.bootstrapArray.length - 1;
            }
            if (arrayIndex < 0) {
                arrayIndex = 0;
            }
            this.bootstrapArray[arrayIndex] = this.bootstrapArray[arrayIndex] + 1;
        }
        double pas = 0.025;
        int nbCases = (int)(1.0 / pas) * 2;
        double[] distribution = new double[nbCases];
        for (int i = 0; i < nbCases; ++i) {
            double sum = 0.0;
            int j = 0;
            while ((double)j < pas * 10000.0) {
                sum += (double)this.bootstrapArray[(int)((double)j + (double)(i * 10000) * pas)];
                ++j;
            }
            distribution[i] = sum / 20000.0;
        }
    }

    private static int roundFois1000(double d) {
        return (int)Math.round(d * 10000.0);
    }

    private double getFr(double data) {
        if (Bootstrapping.roundFois1000(data) >= this.frArray.length) {
            System.out.println("Probleme avec data=" + data + " round=" + Bootstrapping.roundFois1000(data) + "total=" + this.getObservedMatrix().getTotal() + " frLength=" + this.frArray.length);
        }
        return this.frArray[Bootstrapping.roundFois1000(data)];
    }

    private void buildFrArray() {
        this.frArray = new double[Bootstrapping.roundFois1000(this.getObservedMatrix().getTotal()) + 2];
        this.frArray[0] = 0.0;
        boolean index = true;
        double totalIntersections = this.getObservedMatrix().getTotal();
        ArrayList categories = new ArrayList(this.corpus.getUnitSet().getAnnotationSetByCategory().keySet());
        Collections.sort(categories);
        int caret = 1;
        for (String c : this.getObservedMatrix().getColumns()) {
            for (String k : this.getObservedMatrix().getLines()) {
                int obsSteph = ((Double)this.getObservedMatrix().getValue((Object)c, (Object)k)).intValue();
                int obs = Bootstrapping.roundFois1000((Double)this.getObservedMatrix().getValue((Object)c, (Object)k));
                System.out.println("YYYYYYYY vrai obs=" + this.getObservedMatrix().getValue((Object)c, (Object)k) + "  Round=" + obs + "   int=" + obsSteph);
                for (int i = 0; i < obs; ++i) {
                    this.frArray[caret] = this.getMetric().getMetric(c, k) / (totalIntersections * this.alpha.getCluDe());
                    ++caret;
                }
                System.out.println("fr=" + this.frArray[caret - 1]);
            }
        }
        double sumTest = 0.0;
        for (int i = 1; i < this.frArray.length; ++i) {
            sumTest += this.frArray[i];
        }
        this.verbose("1-sumTest =" + (1.0 - (sumTest /= 10000.0)));
    }

    private void show() {
        this.bootstrapDatas = new HashMap<Double, Double>();
        int nombre = 500;
        int n = 0;
        int occurrences = 0;
        for (int i = nombre / 2; i < 20000; ++i) {
            occurrences += this.bootstrapArray[20000 - i - 1];
            if (++n < nombre) continue;
            double val = (double)occurrences / 20000.0 * 100.0;
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(2);
            NumberFormat nf2 = NumberFormat.getInstance();
            nf2.setMaximumFractionDigits(3);
            double alphaV = 1.0 - ((double)i - (double)(nombre / 2)) / 10000.0;
            this.bootstrapDatas.put(alphaV, val);
            System.out.println("" + this.complete(nf.format(1.0 - ((double)i - (double)(nombre / 2)) / 10000.0)) + "\t" + this.complete("(" + nf2.format(val) + "%)") + "\t" + "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX".substring(0, (int)Math.round(val)));
            n = 0;
            occurrences = 0;
        }
        nombre = 250;
        n = 0;
        occurrences = 0;
    }

    private String complete(String s) {
        String t = "           ";
        s = s + t.substring(0, t.length() - s.length());
        return s;
    }

    public double calculateAlphaSmallest() {
        int alphaI;
        double limit = this.getpLevel() / 2.0;
        double sum = 0.0;
        for (alphaI = 1; sum < limit && alphaI < this.bootstrapArray.length; ++alphaI) {
            if (this.bootstrapArray[alphaI] <= 0) continue;
            sum += (double)this.bootstrapArray[alphaI] / (double)this.getxIterations();
        }
        return ((double)alphaI - 10000.0) / 10000.0;
    }

    public double calculateAlphaLargest() {
        int alphaI;
        double limit = this.getpLevel() / 2.0;
        double sum = 0.0;
        for (alphaI = this.bootstrapArray.length - 1; sum < limit && alphaI >= 0; --alphaI) {
            if (this.bootstrapArray[alphaI] <= 0) continue;
            sum += (double)this.bootstrapArray[alphaI] / (double)this.getxIterations();
        }
        return ((double)alphaI - 10000.0) / 10000.0;
    }

    public double calculateMinimum() throws MeasureException {
        for (int i = 0; i < this.bootstrapArray.length; ++i) {
            if (this.bootstrapArray[i] <= 0) continue;
            return ((double)i - 10000.0) / 10000.0;
        }
        throw new MeasureException("Can't calculate minimum");
    }

    public double calculateMaximum() throws MeasureException {
        for (int i = this.bootstrapArray.length - 1; i > 0; --i) {
            if (this.bootstrapArray[i] <= 0) continue;
            double cal = (double)i - 1.0;
            return ((double)i - 10000.0) / 10000.0;
        }
        throw new MeasureException("Can't calculate maximum");
    }

    public double calculateQProbability() throws MeasureException {
        int percent = 0;
        int alphaFix = (int)(this.alphaMin * 10000.0 + 10000.0);
        for (int i = this.bootstrapArray.length - 1; i > alphaFix; --i) {
            percent += this.bootstrapArray[i];
        }
        double percentT = 1.0 - (double)percent / (double)this.getxIterations();
        return percentT;
    }
}

