/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.krippendorff.alphaClu2013;

import com.jacksay.matrix.MatrixNumeric;
import fr.unicaen.measure.core.IMeasure;
import fr.unicaen.measure.krippendorff.alphaClu2013.Bootstrappable;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013Nominal;
import fr.unicaen.measure.model.AnnotationSetImpl;
import fr.unicaen.measure.model.IAnnotation;
import fr.unicaen.measure.model.IAnnotationSet;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.IUnit;
import fr.unicaen.measure.model.UnitImpl;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AlphaluBase
implements IMeasure,
Bootstrappable {
    protected int[] countByCategory;
    protected ArrayList<Double> eFunctionValues;
    protected MatrixNumeric<String> observedMatrix;
    protected MatrixNumeric<String> countsOfObservedMatrix;
    protected MatrixNumeric<String> expectedMatrix;
    protected List<String> categories;
    protected List<String> authors;
    protected Metric2013 metric;
    protected Map<String, IAnnotationSet<IUnit>> continuums;
    protected int continumSize;
    protected int continuumBegin = 0;
    protected int numberOfIntersections = 0;
    public static String NA = " NA";
    public static String VALUED = " V";
    protected double cluDo;
    protected double cluDe;
    protected double total;
    protected int nbrUnits;
    protected double time;

    public AlphaluBase(Metric2013 metric) {
        this.metric = metric;
        this.authors = new ArrayList<String>();
        this.categories = new ArrayList<String>();
        this.eFunctionValues = new ArrayList();
    }

    public AlphaluBase() {
        this(new Metric2013Nominal());
    }

    protected void resetForBootstrapping() {
        this.numberOfIntersections = 0;
        this.eFunctionValues.clear();
    }

    public MatrixNumeric<String> getObservedMatrix() {
        return this.observedMatrix;
    }

    public MatrixNumeric<String> getExpectedMatrix() {
        return this.expectedMatrix;
    }

    public double getMetric(String c, String k) {
        return this.metric.getMetric(c, k);
    }

    @Override
    public Metric2013 getMetric() {
        return this.metric;
    }

    public void setMetric(Metric2013 metric) {
        this.metric = metric;
    }

    public double getTotal() {
        return this.total;
    }

    public double getCluDo() {
        return this.cluDo;
    }

    public double getCluDe() {
        return this.cluDe;
    }

    public int getNbrAnnotators() {
        return this.authors.size();
    }

    public int getNbrCategories() {
        return this.categories.size();
    }

    public int getNbrUnits() {
        return this.nbrUnits;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public MatrixNumeric<String> getObservedCoincidencesMatrix() {
        return this.observedMatrix;
    }

    public MatrixNumeric<String> getExpectedCoincidencesMatrix() {
        return this.expectedMatrix;
    }

    protected double intersectSize(IUnit unitG, IUnit unitH) {
        return Math.min(unitH.getEndIndex(), unitG.getEndIndex()) - Math.max(unitG.getStartIndex(), unitH.getStartIndex());
    }

    protected double unitSize(IUnit u) {
        return u.getEndIndex() - u.getStartIndex();
    }

    public String normalizeString(String s, int size) {
        return this.normalizeString(s, size, ' ');
    }

    public String normalizeString(String s, int size, char fillChar) {
        if (s.length() > size) {
            return s.substring(0, size);
        }
        String out = "";
        for (int i = s.length(); i < size; ++i) {
            out = out + fillChar;
        }
        return out + s;
    }

    public String dumpMatric(MatrixNumeric<String> matrix) {
        return this.dumpMatric(matrix, "##0.00###");
    }

    public abstract AlphaluBase newOne(Metric2013 var1);

    public String dumpMatric(MatrixNumeric<String> matrix, String format) {
        String out = "";
        int colSize = format.length();
        DecimalFormat numberFormat = new DecimalFormat(format);
        String head = this.normalizeString("", colSize) + " ";
        String lineSep = "";
        String bottom = this.normalizeString("", colSize) + " ";
        for (String col : matrix.getColumns()) {
            head = head + "| " + this.normalizeString(col, colSize) + " ";
            String line = this.normalizeString(col, colSize) + " ";
            lineSep = this.normalizeString("", colSize, '-') + "-";
            for (String row : matrix.getLines()) {
                line = line + "| " + this.normalizeString(numberFormat.format(matrix.getValue((Object)col, (Object)row)), colSize) + " ";
                lineSep = lineSep + "+--" + this.normalizeString("", colSize, '-');
            }
            bottom = bottom + "| " + this.normalizeString(numberFormat.format(matrix.getTotalColunm((Object)col)), colSize) + " ";
            line = line + " = " + numberFormat.format(matrix.getTotalLine((Object)col));
            out = out + line + "\n" + lineSep + "\n";
        }
        return lineSep + "\n" + head + "\n" + lineSep + "\n" + out + bottom + " = " + numberFormat.format(matrix.getTotal()) + "\n";
    }

    public String dumpMetric(Metric2013 m) {
        String format = "###0.##";
        DecimalFormat numberFormat = new DecimalFormat(format);
        String out = "";
        int colSize = format.length();
        String head = this.normalizeString("", colSize) + " ";
        String lineSep = "";
        for (String col : this.categories) {
            head = head + "| " + this.normalizeString(col, colSize) + " ";
            String line = this.normalizeString(col, colSize) + " ";
            lineSep = this.normalizeString("", colSize, '-') + "-";
            for (String row : this.categories) {
                line = line + "| " + this.normalizeString(numberFormat.format(this.metric.getMetric(col, row)), colSize) + " ";
                lineSep = lineSep + "+--" + this.normalizeString("", colSize, '-');
            }
            out = out + line + "\n" + lineSep + "\n";
        }
        return lineSep + "\n" + head + '\n' + lineSep + "\n" + out;
    }

    public String dumpObserved() {
        return this.dumpMatrix("##0.0####", " OBSERVED MATRIX", this.getObservedMatrix());
    }

    public String dumpExpected() {
        return this.dumpMatrix("##0.0####", " EXPECTED MATRIX", this.getExpectedMatrix());
    }

    public String dumpMatrix(String format, String title, MatrixNumeric<String> matrix) {
        String line = this.normalizeString(title, (1 + matrix.getColumns().size()) * (format.length() + 2), '#') + "\n";
        String out = this.dumpMatric(matrix, format);
        return line + out;
    }

    protected Map<String, IAnnotationSet<IUnit>> buildContinuum(ICorpus corpus) {
        int continumSize;
        HashMap<String, IAnnotationSet<IUnit>> continuums = new HashMap<String, IAnnotationSet<IUnit>>();
        Map byAuthor = corpus.getUnitSet().getAnnotationSetByAuthor();
        int continuumEnd = continumSize = corpus.getTextSize();
        for (String author : byAuthor.keySet()) {
            AnnotationSetImpl continuumAuthor = new AnnotationSetImpl();
            int caret = 0;
            for (IUnit unit : ((IAnnotationSet)byAuthor.get(author)).getAnnotations()) {
                this.normalizeUnit(unit);
                if (unit.getStartIndex() > caret) {
                    continuumAuthor.addAnnotation((IAnnotation)new UnitImpl(author, NA, caret, unit.getStartIndex()));
                }
                continuumAuthor.addAnnotation((IAnnotation)unit);
                caret = unit.getEndIndex();
            }
            if (caret < continuumEnd) {
                continuumAuthor.addAnnotation((IAnnotation)new UnitImpl(author, NA, caret, continuumEnd));
            }
            continuums.put(author, (IAnnotationSet<IUnit>)continuumAuthor);
        }
        return continuums;
    }

    public abstract String getName();

    public String repport() {
        String out = this.getName() + " \t = " + this.total + '\n';
        out = out + "Do \t = " + this.getCluDo() + "\n";
        out = out + "De \t = " + this.getCluDe() + "\n";
        out = out + "In \t = " + this.time / 1000.0 + " sec\n";
        out = out + this.normalizeString(" " + this.getMetric().getClass().getSimpleName() + " ", 10 * (this.categories.size() + 1), '#');
        out = out + "\n" + this.dumpMetric(this.getMetric()) + "\n";
        out = out + this.dumpObserved() + '\n';
        out = out + this.dumpExpected();
        out = out + "";
        return out;
    }

    public String toString() {
        return this.repport();
    }

    protected void normalizeUnit(IUnit unit) {
    }

    @Override
    public long getNo() {
        return this.numberOfIntersections;
    }

    @Override
    public ArrayList<Double> getEfunctionValues() {
        return this.eFunctionValues;
    }

    @Override
    public double getExpected() {
        return this.cluDe;
    }

    @Override
    public double getDivider() {
        return Math.round(this.observedMatrix.getTotal());
    }

    public void incrementCell(String s1, String s2) {
        double val = (Double)this.countsOfObservedMatrix.getValue((Object)s1, (Object)s2);
        this.countsOfObservedMatrix.setValue((Object)s1, (Object)s2, (Object)(val += 1.0));
    }

    public int getM() {
        return Math.min(100000, (int)(this.observedMatrix.getTotal() / 2.0 * (double)(this.authors.size() - 1)));
    }

    public int getTotalLength() {
        return this.continumSize * this.authors.size();
    }
}

