/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.krippendorff.alphaClu2013;

import com.jacksay.matrix.MatrixNumeric;
import fr.unicaen.measure.core.IMeasure;
import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.krippendorff.alphaClu2013.AlphaluBase;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013;
import fr.unicaen.measure.model.CorpusImpl;
import fr.unicaen.measure.model.IAnnotationSet;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.IUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlphakluNew
extends AlphaluBase
implements IMeasure {
    ArrayList<IAnnotationSet<IUnit>> annotations;
    private Map<IUnit, SigStar> mapSigs;
    private int totalSigLength;
    private String categoryK = null;

    public AlphakluNew(String categoryK) {
        this.categoryK = categoryK;
    }

    public AlphakluNew() {
        this((String)null);
    }

    public AlphakluNew(Metric2013 metric, String categoryK) {
        super(metric);
        this.categoryK = categoryK;
    }

    public AlphakluNew(Metric2013 metric) {
        this(metric, null);
    }

    public double measure(ICorpus corpus) throws MeasureException {
        this.setCorpus(corpus.clone());
        return this.measureForCatK(this.categoryK);
    }

    public double measureForCatK(String catK) throws MeasureException {
        this.total = 0.0;
        this.cluDe = 0.0;
        this.cluDo = 0.0;
        double observed = 0.0;
        double expected = 0.0;
        for (int j = 0; j < this.categories.size(); ++j) {
            String catJ = (String)this.categories.get(j);
            if (catK.equals(catJ)) continue;
            double metricTotal = this.getMetric(catK, catJ);
            observed += metricTotal * (Double)this.observedMatrix.getValue((Object)catK, (Object)catJ);
            expected += metricTotal * (Double)this.expectedMatrix.getValue((Object)catK, (Object)catJ);
        }
        this.cluDe = expected / this.getExpectedTotalLine(catK);
        this.cluDo = observed / this.getObservedTotalLine(catK);
        this.total = 1.0 - this.cluDo / this.cluDe;
        return this.total;
    }

    public double getCovering(String catK) {
        return this.getObservedTotalLine(catK) / (double)this.getTotalLengthForCat(catK) * 100.0;
    }

    public double[] allMeasures(ICorpus corpus) throws MeasureException {
        this.time = new Date().getTime();
        this.setCorpus(corpus.clone());
        double[] results = new double[this.categories.size()];
        for (int k = 0; k < this.categories.size(); ++k) {
            String catK = (String)this.categories.get(k);
            results[k] = this.measureForCatK(catK);
        }
        this.time = (double)new Date().getTime() - this.time;
        return results;
    }

    private void setCorpus(ICorpus corpus) {
        this.continumSize = corpus.getTextSize();
        this.continuums = this.buildContinuum(corpus);
        CorpusImpl c = new CorpusImpl(corpus.getTextSize(), corpus.getCorpusType());
        for (IAnnotationSet iAnnotationSet : this.continuums.values()) {
            c.getUnitSet().addAnnotationsFrom(iAnnotationSet);
        }
        this.authors = new ArrayList(corpus.getUnitSet().getAnnotationSetByAuthor().keySet());
        this.categories = new ArrayList(corpus.getUnitSet().getAnnotationSetByCategory().keySet());
        Collections.sort(this.categories);
        this.observedMatrix = new MatrixNumeric((Collection)this.categories, false, Double.valueOf(0.0));
        this.expectedMatrix = new MatrixNumeric((Collection)this.categories, false, Double.valueOf(0.0));
        this.annotations = new ArrayList(c.getUnitSet().getAnnotationSetByAuthor().values());
        this.nbrUnits = 0;
        for (IAnnotationSet iAnnotationSet : this.annotations) {
            this.nbrUnits += iAnnotationSet.getAnnotations().size();
        }
        this.numberOfIntersections = 0;
        this.computeAllSigStar(this.annotations);
        this.recursiveObserved(this.annotations);
        this.fillExpected(this.continuums);
        this.testSigs(this.annotations);
    }

    protected void recursiveObserved(List<IAnnotationSet<IUnit>> annotations) {
        for (IAnnotationSet<IUnit> setAuthor : annotations) {
            for (IAnnotationSet<IUnit> otherAuthor : annotations) {
                if (setAuthor == otherAuthor) continue;
                for (IUnit g : setAuthor.getAnnotations()) {
                    if (g.getCategory().equals(NA)) continue;
                    for (IUnit h : otherAuthor.getAnnotations()) {
                        double intersect;
                        if (h.getCategory().equals(NA) || !((intersect = this.intersectSize(g, h)) > 0.0)) continue;
                        double v = (Double)this.observedMatrix.getValue((Object)g.getCategory(), (Object)h.getCategory());
                        this.observedMatrix.setValue((Object)g.getCategory(), (Object)h.getCategory(), (Object)(v += intersect / (double)(this.getNbrAnnotators() - 1)));
                        ++this.numberOfIntersections;
                    }
                }
            }
        }
    }

    protected void testSigs(List<IAnnotationSet<IUnit>> annotations) {
        this.computeAllSigStar(annotations);
    }

    public int getTotalSigLength() {
        return this.totalSigLength;
    }

    protected ArrayList<ArrayList<SigStar>> createAllSigStar(List<IAnnotationSet<IUnit>> annotations) {
        this.mapSigs = new HashMap<IUnit, SigStar>();
        this.totalSigLength = 0;
        ArrayList<ArrayList<SigStar>> sigsByAuthors = new ArrayList<ArrayList<SigStar>>();
        for (IAnnotationSet<IUnit> setAuthor : annotations) {
            ArrayList<SigStar> sigsOfAuthor = new ArrayList<SigStar>();
            sigsByAuthors.add(sigsOfAuthor);
            for (IUnit g : setAuthor.getAnnotations()) {
                if (g.getCategory().equals(NA)) continue;
                SigStar ss = new SigStar(g.getStartIndex(), g.getEndIndex());
                sigsOfAuthor.add(ss);
                this.mapSigs.put(g, ss);
            }
        }
        return sigsByAuthors;
    }

    protected ArrayList<ArrayList<SigStar>> computeAllSigStar(List<IAnnotationSet<IUnit>> annotations) {
        ArrayList<ArrayList<SigStar>> sigsByAuthors = this.createAllSigStar(annotations);
        for (ArrayList<SigStar> sigsOfTheAuthor : sigsByAuthors) {
            for (SigStar sigAuthor : sigsOfTheAuthor) {
                for (ArrayList<SigStar> sigsOfAnother : sigsByAuthors) {
                    if (sigsOfAnother == sigsOfTheAuthor) continue;
                    for (SigStar sigOther : sigsOfAnother) {
                        sigAuthor.addOccupiedIntersection(sigOther);
                    }
                }
                sigAuthor.computeOccupiedLength();
                this.totalSigLength += sigAuthor.getOccupiedLength();
            }
        }
        return sigsByAuthors;
    }

    public int getSigLength(IUnit u) {
        return this.mapSigs.get(u).getOccupiedLength();
    }

    protected double getObservedTotalLine(String category) {
        return this.observedMatrix.getTotalLine((Object)category);
    }

    protected double getExpectedTotalLine(String category) {
        return this.expectedMatrix.getTotalLine((Object)category);
    }

    protected double getObservedTotalColumn(String category) {
        return this.observedMatrix.getTotalColunm((Object)category);
    }

    protected double getObservedTotal() {
        return this.observedMatrix.getTotal();
    }

    protected void fillExpected(Map<String, IAnnotationSet<IUnit>> annotations) {
        double m = this.getNbrAnnotators();
        double epsilonDenominator = this.getEpsilonDenominator(annotations);
        for (String col : this.categories) {
            double totalCol = this.observedMatrix.getTotalLine((Object)col);
            for (String row : this.categories) {
                double cell = col.equals(row) ? this.getEspilonNumeratorCequalsK(annotations, col) : this.getEspilonNumeratorCdifferentOfK(annotations, col, row);
                cell /= epsilonDenominator;
                this.expectedMatrix.setValue((Object)col, (Object)row, (Object)(cell *= this.getObservedTotal()));
            }
        }
    }

    protected double getObservedNumeratorCEqualK(Map<String, IAnnotationSet<IUnit>> annotations, String category) {
        double result = 0.0;
        for (IAnnotationSet<IUnit> setI : annotations.values()) {
            for (IUnit g : setI.getAnnotations()) {
                if (!g.getCategory().equals(category)) continue;
                for (IAnnotationSet<IUnit> setJ : annotations.values()) {
                    if (setI == setJ) continue;
                    for (IUnit h : setJ.getAnnotations()) {
                        double intersect;
                        if (h.getCategory().equals(NA) || (intersect = this.intersectSize(g, h)) <= 0.0) continue;
                        result += Math.pow(intersect, 2.0);
                    }
                }
            }
        }
        double lc = this.observedMatrix.getTotalColunm((Object)category);
        double m = this.getNbrAnnotators();
        double t = Math.pow(lc, 2.0) - result / (m - 1.0);
        return t;
    }

    protected double getCluDeDenominator(Map<String, IAnnotationSet<IUnit>> annotations) {
        double result = 0.0;
        for (IAnnotationSet<IUnit> setI : annotations.values()) {
            for (IUnit g : setI.getAnnotations()) {
                if (g.getCategory().equals(NA)) continue;
                for (IAnnotationSet<IUnit> setJ : annotations.values()) {
                    if (setI == setJ) continue;
                    for (IUnit h : setJ.getAnnotations()) {
                        double intersect;
                        if (h.getCategory().equals(NA) || (intersect = this.intersectSize(g, h)) <= 0.0) continue;
                        result += Math.pow(intersect, 2.0);
                    }
                }
            }
        }
        double obsT = Math.pow(this.getObservedTotal(), 2.0);
        double out = obsT - result / (double)(this.getNbrAnnotators() - 1);
        return out;
    }

    protected double getValueForEpsilon(Map<String, IAnnotationSet<IUnit>> annotations, String cat, boolean squared) {
        double result = 0.0;
        for (IAnnotationSet<IUnit> setI : annotations.values()) {
            for (IUnit g : setI.getAnnotations()) {
                if (g.getCategory().equals(NA) || cat != null && !g.getCategory().equals(cat)) continue;
                double value = this.getSigLength(g);
                if (squared) {
                    value = Math.pow(value, 2.0);
                }
                result += value;
            }
        }
        return result;
    }

    protected double getEspilonNumeratorCequalsK(Map<String, IAnnotationSet<IUnit>> annotations, String catCequalsK) {
        double sum1 = this.getValueForEpsilon(annotations, catCequalsK, false);
        sum1 = Math.pow(sum1, 2.0);
        double sum2 = this.getValueForEpsilon(annotations, catCequalsK, true);
        return sum1 - sum2;
    }

    protected double getEspilonNumeratorCdifferentOfK(Map<String, IAnnotationSet<IUnit>> annotations, String catC, String catK) {
        double sum1 = this.getValueForEpsilon(annotations, catC, false);
        double sum2 = this.getValueForEpsilon(annotations, catK, false);
        return sum1 * sum2;
    }

    protected double getEpsilonDenominator(Map<String, IAnnotationSet<IUnit>> annotations) {
        double result = 0.0;
        double sum1 = this.getValueForEpsilon(annotations, null, false);
        sum1 = Math.pow(sum1, 2.0);
        double sum2 = this.getValueForEpsilon(annotations, null, true);
        return sum1 - sum2;
    }

    public boolean checkCorpus(ICorpus corpus) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AlphaluBase newOne(Metric2013 metric) {
        return new AlphakluNew(metric);
    }

    @Override
    public String getName() {
        return "new-k|u \u03b1";
    }

    public int getTotalLengthForCat(String cat) {
        int sum = 0;
        for (IAnnotationSet<IUnit> set : this.annotations) {
            for (IUnit unit : set.getAnnotations()) {
                if (!unit.getCategory().equals(cat)) continue;
                sum += unit.getEndIndex() - unit.getStartIndex();
            }
        }
        return sum;
    }

    public class SigStar {
        private int beginIndex;
        private int endIndex;
        private int occupiedLength;
        private boolean[] isThisPosOccupied;

        public SigStar(int beginIndex, int endIndex) {
            this.beginIndex = beginIndex;
            this.endIndex = endIndex - 1;
            this.isThisPosOccupied = new boolean[endIndex - beginIndex + 1];
            for (int i = 0; i < this.isThisPosOccupied.length; ++i) {
                this.isThisPosOccupied[i] = false;
            }
        }

        public void addOccupiedIntersection(SigStar ss) {
            int start = Math.max(0, ss.beginIndex - this.beginIndex);
            int end = Math.min(this.endIndex - this.beginIndex, ss.endIndex - this.beginIndex);
            for (int i = start; i <= end; ++i) {
                this.isThisPosOccupied[i] = true;
            }
        }

        public void computeOccupiedLength() {
            this.occupiedLength = 0;
            for (boolean b : this.isThisPosOccupied) {
                if (!b) continue;
                ++this.occupiedLength;
            }
        }

        public int getOccupiedLength() {
            return this.occupiedLength;
        }
    }
}

