/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.krippendorff.alphaClu2013;

import com.jacksay.matrix.MatrixNumeric;
import fr.unicaen.measure.core.IMeasure;
import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.krippendorff.alphaClu2013.AlphaluBase;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013;
import fr.unicaen.measure.model.CorpusImpl;
import fr.unicaen.measure.model.IAnnotationSet;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.IUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Alphaclu
extends AlphaluBase
implements IMeasure {
    public Alphaclu() {
    }

    public Alphaclu(Metric2013 metric) {
        super(metric);
    }

    public double measure(ICorpus corpus) throws MeasureException {
        this.time = new Date().getTime();
        this.setCorpus(corpus.clone());
        this.total = 0.0;
        this.cluDe = 0.0;
        this.cluDo = 0.0;
        double observed = 0.0;
        double cluDeNumerator = 0.0;
        double cluDeDenominator = this.getCluDeDenominator(this.continuums);
        for (int i = 0; i < this.categories.size(); ++i) {
            String c = (String)this.categories.get(i);
            for (int j = i; j < this.categories.size(); ++j) {
                String k = (String)this.categories.get(j);
                double metricTotal = this.getMetric(c, k);
                observed += metricTotal * (Double)this.observedMatrix.getValue((Object)c, (Object)k);
                cluDeNumerator += 2.0 * this.getObservedTotalLine(c) * this.getObservedTotalLine(k) * metricTotal;
            }
        }
        this.cluDe = cluDeNumerator / cluDeDenominator;
        this.cluDo = 2.0 * observed / this.getObservedTotal();
        this.total = 1.0 - this.cluDo / this.cluDe;
        this.time = (double)new Date().getTime() - this.time;
        return this.total;
    }

    private void setCorpus(ICorpus corpus) {
        this.continumSize = corpus.getTextSize();
        this.continuums = this.buildContinuum(corpus);
        CorpusImpl c = new CorpusImpl(corpus.getTextSize(), corpus.getCorpusType());
        for (IAnnotationSet ann : this.continuums.values()) {
            c.getUnitSet().addAnnotationsFrom(ann);
        }
        this.authors = new ArrayList(corpus.getUnitSet().getAnnotationSetByAuthor().keySet());
        this.categories = new ArrayList(corpus.getUnitSet().getAnnotationSetByCategory().keySet());
        Collections.sort(this.categories);
        this.observedMatrix = new MatrixNumeric((Collection)this.categories, false, Double.valueOf(0.0));
        this.countsOfObservedMatrix = new MatrixNumeric((Collection)this.categories, false, Double.valueOf(0.0));
        this.expectedMatrix = new MatrixNumeric((Collection)this.categories, false, Double.valueOf(0.0));
        ArrayList<IAnnotationSet<IUnit>> annotations = new ArrayList<IAnnotationSet<IUnit>>(c.getUnitSet().getAnnotationSetByAuthor().values());
        this.nbrUnits = 0;
        for (IAnnotationSet iAnnotationSet : annotations) {
            this.nbrUnits += iAnnotationSet.getAnnotations().size();
        }
        this.numberOfIntersections = 0;
        this.recursiveObserved(annotations);
        this.recursiveExpected(this.continuums);
    }

    protected void recursiveObserved(List<IAnnotationSet<IUnit>> annotations) {
        for (IAnnotationSet<IUnit> setAuthor : annotations) {
            for (IAnnotationSet<IUnit> otherAuthor : annotations) {
                if (setAuthor == otherAuthor) continue;
                for (IUnit g : setAuthor.getAnnotations()) {
                    if (g.getCategory().equals(NA)) continue;
                    for (IUnit h : otherAuthor.getAnnotations()) {
                        double intersect;
                        if (h.getCategory().equals(NA) || !((intersect = this.intersectSize(g, h)) > 0.0)) continue;
                        double v = (Double)this.observedMatrix.getValue((Object)g.getCategory(), (Object)h.getCategory());
                        this.observedMatrix.setValue((Object)g.getCategory(), (Object)h.getCategory(), (Object)(v += intersect / (double)(this.getNbrAnnotators() - 1)));
                        ++this.numberOfIntersections;
                    }
                }
            }
        }
    }

    protected double getObservedTotalLine(String category) {
        return this.observedMatrix.getTotalLine((Object)category);
    }

    protected double getObservedTotalColumn(String category) {
        return this.observedMatrix.getTotalColunm((Object)category);
    }

    protected double getObservedTotal() {
        return this.observedMatrix.getTotal();
    }

    protected void recursiveExpected(Map<String, IAnnotationSet<IUnit>> annotations) {
        double m = this.getNbrAnnotators();
        double epsilonDemoninator = this.getEpsilonDenominator(annotations);
        for (String col : this.categories) {
            double totalCol = this.observedMatrix.getTotalLine((Object)col);
            for (String row : this.categories) {
                double cell;
                if (col.equals(row)) {
                    cell = this.getObservedNumeratorCEqualK(annotations, col) / epsilonDemoninator;
                } else {
                    double numerator = totalCol * this.observedMatrix.getTotalLine((Object)row);
                    cell = numerator / epsilonDemoninator;
                }
                this.expectedMatrix.setValue((Object)col, (Object)row, (Object)cell);
            }
        }
    }

    protected double getObservedNumeratorCEqualK(Map<String, IAnnotationSet<IUnit>> annotations, String category) {
        double result = 0.0;
        for (IAnnotationSet<IUnit> setI : annotations.values()) {
            for (IUnit g : setI.getAnnotations()) {
                if (!g.getCategory().equals(category)) continue;
                for (IAnnotationSet<IUnit> setJ : annotations.values()) {
                    if (setI == setJ) continue;
                    for (IUnit h : setJ.getAnnotations()) {
                        double intersect;
                        if (h.getCategory().equals(NA) || (intersect = this.intersectSize(g, h)) <= 0.0) continue;
                        result += Math.pow(intersect, 2.0);
                    }
                }
            }
        }
        double lc = this.observedMatrix.getTotalColunm((Object)category);
        double m = this.getNbrAnnotators();
        double t = Math.pow(lc, 2.0) - result / (m - 1.0);
        return t;
    }

    protected double getCluDeDenominator(Map<String, IAnnotationSet<IUnit>> annotations) {
        double result = 0.0;
        for (IAnnotationSet<IUnit> setI : annotations.values()) {
            for (IUnit g : setI.getAnnotations()) {
                if (g.getCategory().equals(NA)) continue;
                for (IAnnotationSet<IUnit> setJ : annotations.values()) {
                    if (setI == setJ) continue;
                    for (IUnit h : setJ.getAnnotations()) {
                        double intersect;
                        if (h.getCategory().equals(NA) || (intersect = this.intersectSize(g, h)) <= 0.0) continue;
                        result += Math.pow(intersect, 2.0);
                    }
                }
            }
        }
        double obsT = Math.pow(this.getObservedTotal(), 2.0);
        double out = obsT - result / (double)(this.getNbrAnnotators() - 1);
        return out;
    }

    protected double getEpsilonDenominator(Map<String, IAnnotationSet<IUnit>> annotations) {
        double result = 0.0;
        for (IAnnotationSet<IUnit> setI : annotations.values()) {
            for (IUnit g : setI.getAnnotations()) {
                if (g.getCategory().equals(NA)) continue;
                for (IAnnotationSet<IUnit> setJ : annotations.values()) {
                    if (setI == setJ) continue;
                    for (IUnit h : setJ.getAnnotations()) {
                        double intersect;
                        if (h.getCategory().equals(NA) || (intersect = this.intersectSize(g, h)) <= 0.0) continue;
                        result += Math.pow(intersect, 2.0);
                    }
                }
            }
        }
        double l = this.observedMatrix.getTotal();
        double m = this.getNbrAnnotators();
        double t = l - result / (l * (m - 1.0));
        return t;
    }

    public boolean checkCorpus(ICorpus corpus) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AlphaluBase newOne(Metric2013 metric) {
        return new Alphaclu(metric);
    }

    @Override
    public String getName() {
        return "c|u \u03b1";
    }
}

