/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.krippendorff.alpha2013;

import fr.unicaen.measure.core.IMeasure;
import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013Nominal;
import fr.unicaen.measure.model.AnnotationSetImpl;
import fr.unicaen.measure.model.IAnnotation;
import fr.unicaen.measure.model.IAnnotationSet;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.IUnit;
import fr.unicaen.measure.model.UnitImpl;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Krippendorff2013Bis
implements IMeasure {
    private Metric2013 metric;
    private static final boolean varianteYann = false;
    private static final boolean varianteC = false;
    private static final boolean varianteD = true;
    public static String NA = "NA.";
    protected Map<String, IAnnotationSet<IUnit>> continuum = null;
    private List<String> authors = null;
    private int continuumBegin = 0;
    private int continumSize = -1;
    double total;
    double observed;
    double expected;
    double time;
    private boolean allCategoriesAreEqual;
    private ICorpus corpus;

    public Krippendorff2013Bis() {
        this(new Metric2013Nominal());
    }

    public Krippendorff2013Bis(Metric2013 metric) {
        this.metric = metric;
        this.continuum = new HashMap<String, IAnnotationSet<IUnit>>();
        this.authors = new ArrayList<String>();
    }

    public Metric2013 getMetric() {
        return this.metric;
    }

    private void findIfAllCategoriesAreEqual() {
        this.allCategoriesAreEqual = true;
        AnnotationSetImpl units = new AnnotationSetImpl();
        for (IAnnotationSet<IUnit> set : this.continuum.values()) {
            units.addAnnotationsFrom(set);
        }
        String category = "";
        int count = 0;
        for (IUnit u : units.getAnnotations()) {
            if (u.getCategory().equals("NA.")) continue;
            if (count++ == 0) {
                category = u.getCategory();
                continue;
            }
            String c = u.getCategory();
            if (c.equals(category)) continue;
            this.allCategoriesAreEqual = false;
            System.out.println("categories not all equal : " + c + " !=" + category);
            return;
        }
    }

    public double measure(ICorpus corpus) throws MeasureException {
        this.corpus = corpus;
        this.time = new Date().getTime();
        this.continuum = new HashMap<String, IAnnotationSet<IUnit>>();
        this.authors = new ArrayList<String>();
        this.continuumBegin = 0;
        this.continumSize = -1;
        this.buildContinuum(corpus.clone());
        this.findIfAllCategoriesAreEqual();
        this.observed = this.getObserved();
        this.expected = this.getExpected();
        this.total = 1.0 - this.observed / this.expected;
        this.time = (double)new Date().getTime() - this.time;
        return this.total;
    }

    public String toString() {
        String out = "\u03b1 \t = " + this.total + '\n';
        out = out + "Do \t = " + this.observed + "\n";
        out = out + "De \t = " + this.expected + "\n";
        out = out + "In \t = " + this.time / 1000.0 + " sec";
        return out;
    }

    public double getExpected() {
        return this.getExpectedNumerator() / 2.0;
    }

    protected double expectedForUnits(IUnit g, IUnit h) {
        double t = 0.0;
        if (g != h) {
            String ic = g.getCategory();
            String jc = h.getCategory();
            int li = g.getEndIndex() - g.getStartIndex();
            int lj = h.getEndIndex() - h.getStartIndex();
            if (ic.equals(jc) && !ic.equals(NA)) {
                t = li * (li - 1) + lj * (lj - 1);
            }
            if (!(ic.equals(jc) || ic.equals(NA) || jc.equals(NA))) {
                t = li * (li - 1) + lj * (lj - 1) + li * lj;
            }
            if (li <= lj && !ic.equals(NA) && jc.equals(NA)) {
                t = li;
            }
            if (lj <= li && !jc.equals(NA) && ic.equals(NA)) {
                t = lj;
            }
        }
        return t;
    }

    protected double expectedForUnitsVersionC(IUnit g, IUnit h) {
        double t = 0.0;
        if (g != h) {
            String ic = g.getCategory();
            String jc = h.getCategory();
            int li = g.getEndIndex() - g.getStartIndex();
            int lj = h.getEndIndex() - h.getStartIndex();
            if (!ic.equals(NA) && !jc.equals(NA)) {
                t = ((double)li * (double)li + (double)(lj * lj)) / (double)(li + lj);
            }
            if (this.isFirstContainedBySecond(g, h) && !ic.equals(NA) && jc.equals(NA)) {
                t = (double)li / 2.0;
            }
            if (this.isFirstContainedBySecond(h, g) && !jc.equals(NA) && ic.equals(NA)) {
                t = (double)lj / 2.0;
            }
        }
        return t;
    }

    protected double expectedForUnitsVersionDForNumerator(IUnit g, IUnit h, double expectedMetricDifference) {
        double t = 0.0;
        if (g != h) {
            String ic = g.getCategory();
            String jc = h.getCategory();
            int li = g.getEndIndex() - g.getStartIndex();
            int lj = h.getEndIndex() - h.getStartIndex();
            if (!ic.equals(NA) && !jc.equals(NA) && this.intersectSize(g, h) > 0.0) {
                t = (double)(li * li + lj * lj) / (double)(li + lj) + this.intersectSize(g, h) * expectedMetricDifference;
            }
            if (this.isFirstContainedBySecond(g, h) && !ic.equals(NA) && jc.equals(NA)) {
                t = (double)li / 2.0;
            }
            if (this.isFirstContainedBySecond(h, g) && !jc.equals(NA) && ic.equals(NA)) {
                t = (double)lj / 2.0;
            }
        }
        return t;
    }

    protected double expectedForUnitsVersionDForDenominator(IUnit g, IUnit h) {
        double t = 0.0;
        if (g != h) {
            String ic = g.getCategory();
            String jc = h.getCategory();
            int li = g.getEndIndex() - g.getStartIndex();
            int lj = h.getEndIndex() - h.getStartIndex();
            if (!ic.equals(NA) && !jc.equals(NA)) {
                t = li + lj;
            }
            if (this.isFirstContainedBySecond(g, h) && !ic.equals(NA) && jc.equals(NA)) {
                t = (double)li / 2.0;
            }
            if (this.isFirstContainedBySecond(h, g) && !jc.equals(NA) && ic.equals(NA)) {
                t = (double)lj / 2.0;
            }
        }
        return t;
    }

    protected double getExpectedNumerator() {
        double expectedMetricDifferenceNumerator = this.computeExpectedMetricDifference(this.corpus, true);
        double expectedMetricDifferenceDenominator = this.computeExpectedMetricDifference(this.corpus, false);
        double expectedMetricDifference = expectedMetricDifferenceNumerator / expectedMetricDifferenceDenominator;
        double numerator = 0.0;
        AnnotationSetImpl units = new AnnotationSetImpl();
        for (IAnnotationSet<IUnit> set : this.continuum.values()) {
            units.addAnnotationsFrom(set);
        }
        for (IUnit g : units.getAnnotations()) {
            for (IUnit h : units.getAnnotations()) {
                if (!(this.intersectSize(g, h) > 0.0)) continue;
                numerator += this.expectedForUnitsVersionDForNumerator(g, h, expectedMetricDifference);
            }
        }
        return numerator;
    }

    protected double getExpectedDenominator() {
        double denominator = 0.0;
        AnnotationSetImpl units = new AnnotationSetImpl();
        for (IAnnotationSet<IUnit> set : this.continuum.values()) {
            units.addAnnotationsFrom(set);
        }
        for (IUnit g : units.getAnnotations()) {
            for (IUnit h : units.getAnnotations()) {
                if (!(this.intersectSize(g, h) > 0.0)) continue;
                denominator += this.expectedForUnitsVersionDForDenominator(g, h);
            }
        }
        return denominator;
    }

    public double getObserved() {
        return this.getObservedDenominator();
    }

    protected double getObservedNumerator() {
        return 2 * this.countNumberRecursiveObserved(new ArrayList<IAnnotationSet<IUnit>>(this.continuum.values()), 0, 0);
    }

    protected double getObservedDenominator() {
        return this.recursiveObserved(new ArrayList<IAnnotationSet<IUnit>>(this.continuum.values()), 0, 0.0);
    }

    protected int countNumberRecursiveObserved(List<IAnnotationSet<IUnit>> annotations, int set, int count) {
        for (IUnit g : annotations.get(set).getAnnotations()) {
            for (int i = set + 1; i < annotations.size(); ++i) {
                for (IUnit h : annotations.get(i).getAnnotations()) {
                    if (!(this.intersectSize(g, h) > 0.0)) continue;
                    String gc = g.getCategory();
                    String hc = h.getCategory();
                    if (!gc.equals(NA) && !hc.equals(NA)) {
                        ++count;
                    }
                    if (!gc.equals(NA) && hc.equals(NA) && this.isFirstContainedBySecond(g, h)) {
                        ++count;
                    }
                    if (hc.equals(NA) || !gc.equals(NA) || !this.isFirstContainedBySecond(h, g)) continue;
                    ++count;
                }
            }
        }
        if (set < annotations.size() - 2) {
            count = this.countNumberRecursiveObserved(annotations, set + 1, count);
        }
        return count;
    }

    protected double recursiveObserved(List<IAnnotationSet<IUnit>> annotations, int set, double value) {
        for (IUnit g : annotations.get(set).getAnnotations()) {
            for (int i = set + 1; i < annotations.size(); ++i) {
                for (IUnit h : annotations.get(i).getAnnotations()) {
                    if (!(this.intersectSize(g, h) > 0.0)) continue;
                    String gc = g.getCategory();
                    String hc = h.getCategory();
                    if (!gc.equals(NA) && !hc.equals(NA)) {
                        value += this.unionSize(g, h) - this.intersectSize(g, h) * (1.0 - this.metric.getMetric(gc, hc));
                    }
                    if (!gc.equals(NA) && hc.equals(NA) && this.isFirstContainedBySecond(g, h)) {
                        value += (double)(g.getEndIndex() - g.getStartIndex());
                    }
                    if (hc.equals(NA) || !gc.equals(NA) || !this.isFirstContainedBySecond(h, g)) continue;
                    value += (double)(h.getEndIndex() - h.getStartIndex());
                }
            }
        }
        if (set < annotations.size() - 2) {
            value = this.recursiveObserved(annotations, set + 1, value);
        }
        return value;
    }

    protected double deltaIghj(IUnit g, IUnit h) {
        if (!g.getCategory().equals(h.getCategory())) {
            return Math.pow(this.intersectSize(h, g), 2.0);
        }
        return 0.0;
    }

    protected boolean isFirstContainedBySecond(IUnit g, IUnit h) {
        return g.getStartIndex() >= h.getStartIndex() && g.getEndIndex() <= h.getEndIndex();
    }

    protected double intersectSize(IUnit unitG, IUnit unitH) {
        return Math.min(unitH.getEndIndex(), unitG.getEndIndex()) - Math.max(unitG.getStartIndex(), unitH.getStartIndex());
    }

    protected double unionSize(IUnit unitG, IUnit unitH) {
        return Math.max(unitH.getEndIndex(), unitG.getEndIndex()) - Math.min(unitG.getStartIndex(), unitH.getStartIndex());
    }

    protected double minSize(IUnit g, IUnit h) {
        return Math.min(this.unitSize(h), this.unitSize(g));
    }

    protected double maxSize(IUnit g, IUnit h) {
        return Math.max(this.unitSize(h), this.unitSize(g));
    }

    protected double unitSize(IUnit u) {
        return u.getEndIndex() - u.getStartIndex();
    }

    public int getContinuumSize() {
        return this.continumSize;
    }

    public int getContinuumStart() {
        return this.continuumBegin;
    }

    public int getContinuumEnd() {
        return this.continuumBegin + this.continumSize;
    }

    public IAnnotationSet<IUnit> getContinuum(String author) {
        return this.continuum.get(author);
    }

    public Map<String, IAnnotationSet<IUnit>> getContinuum() {
        return this.continuum;
    }

    protected void buildContinuum(ICorpus corpus) throws MeasureException {
        this.continuum = new HashMap<String, IAnnotationSet<IUnit>>();
        Map byAuthor = corpus.getUnitSet().getAnnotationSetByAuthor();
        this.continumSize = corpus.getTextSize();
        if (byAuthor.isEmpty()) {
            throw new MeasureException("Corpus doesn't contain annotations...");
        }
        for (String author : byAuthor.keySet()) {
            this.authors.add(author);
            AnnotationSetImpl continuumAuthor = new AnnotationSetImpl();
            int caret = this.continuumBegin;
            for (IUnit unit : ((IAnnotationSet)byAuthor.get(author)).getAnnotations()) {
                if (unit.getStartIndex() > caret) {
                    continuumAuthor.addAnnotation((IAnnotation)new UnitImpl(author, NA, caret, unit.getStartIndex()));
                }
                continuumAuthor.addAnnotation((IAnnotation)new UnitImpl(unit.getAuthor(), unit.getCategory(), unit.getStartIndex(), unit.getEndIndex()));
                caret = unit.getEndIndex();
            }
            if (caret < this.getContinuumEnd()) {
                continuumAuthor.addAnnotation((IAnnotation)new UnitImpl(author, NA, caret, this.getContinuumEnd()));
            }
            this.continuum.put(author, (IAnnotationSet<IUnit>)continuumAuthor);
        }
    }

    private int numObservers() {
        return this.authors.size();
    }

    public String measureRepport(ICorpus c) {
        String out = " // --------------- Krippendorff 2013 \n";
        DecimalFormat df = new DecimalFormat("0.000000");
        try {
            double total = this.measure(c);
            out = out + " \u03b1 = 1 - (" + df.format(this.getObserved()) + "/" + df.format(this.getExpected()) + ")\t  = " + df.format(total) + "\n";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            out = out + "/!\\ ERROR : " + ex.getMessage();
        }
        return out;
    }

    public boolean checkCorpus(ICorpus corpus) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected double computeExpectedMetricDifference(ICorpus corpus, boolean withMetric) {
        double value = 0.0;
        IAnnotationSet set = corpus.getUnitSet();
        List list = set.getAnnotations();
        for (int i = 0; i < list.size(); ++i) {
            IUnit g = (IUnit)list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                IUnit h = (IUnit)list.get(j);
                String gc = g.getCategory();
                String hc = h.getCategory();
                if (gc.equals("NA.") || hc.equals("NA.")) continue;
                value += (double)((g.getEndIndex() - g.getStartIndex()) * (h.getEndIndex() - h.getStartIndex())) * (withMetric ? this.metric.getMetric(gc, hc) : 1.0);
            }
        }
        return value;
    }
}

