/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.krippendorff.alpha2013;

import fr.unicaen.measure.core.IMeasure;
import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.model.AnnotationSetImpl;
import fr.unicaen.measure.model.IAnnotation;
import fr.unicaen.measure.model.IAnnotationSet;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.IUnit;
import fr.unicaen.measure.model.UnitImpl;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Krippendorff2013
implements IMeasure {
    public static String NA = "NA.";
    protected Map<String, IAnnotationSet<IUnit>> continuum = new HashMap<String, IAnnotationSet<IUnit>>();
    private List<String> authors = new ArrayList<String>();
    private int continuumBegin = 0;
    private int continumSize = -1;
    double total;
    double observed;
    double expected;
    double time;

    public double measure(ICorpus corpus) throws MeasureException {
        this.time = new Date().getTime();
        this.continuum = new HashMap<String, IAnnotationSet<IUnit>>();
        this.authors = new ArrayList<String>();
        this.continuumBegin = 0;
        this.continumSize = -1;
        this.buildContinuum(corpus.clone());
        this.observed = this.getObserved();
        this.expected = this.getExpected();
        this.total = 1.0 - this.observed / this.expected;
        this.time = (double)new Date().getTime() - this.time;
        return this.total;
    }

    public String toString() {
        String out = "\u03b1 \t = " + this.total + '\n';
        out = out + "Do \t = " + this.observed + "\n";
        out = out + "De \t = " + this.expected + "\n";
        out = out + "In \t = " + this.time / 1000.0 + " sec";
        return out;
    }

    public double getExpected() {
        return this.getExpectedNumerator() / this.getExpectedDenominator();
    }

    protected double expectedForUnits(IUnit g, IUnit h) {
        double t = 0.0;
        if (!g.getCategory().equals(h.getCategory())) {
            double a = this.minSize(g, h);
            double b = this.maxSize(g, h);
            t = Math.pow(a, 2.0) * b - (Math.pow(a, 3.0) - a) / 3.0;
        }
        return t;
    }

    protected double getExpectedNumerator() {
        double numerator = 0.0;
        AnnotationSetImpl units = new AnnotationSetImpl();
        for (IAnnotationSet<IUnit> set : this.continuum.values()) {
            units.addAnnotationsFrom(set);
        }
        for (IUnit g : units.getAnnotations()) {
            for (IUnit h : units.getAnnotations()) {
                numerator += this.expectedForUnits(g, h);
            }
        }
        return numerator;
    }

    protected double getExpectedDenominator() {
        double total = Math.pow(this.getContinuumSize(), 2.0) * Math.pow(this.numObservers(), 2.0);
        double sous = 0.0;
        for (IAnnotationSet<IUnit> set : this.continuum.values()) {
            for (IUnit u : set.getAnnotations()) {
                double unitSize = Math.pow(this.unitSize(u), 2.0);
                sous += unitSize;
            }
        }
        return total -= sous;
    }

    public double getObserved() {
        double denominator = this.getObservedDenominator() * 2.0;
        double numerator = this.getObservedNumerator();
        double observed = denominator / numerator;
        return denominator / numerator;
    }

    protected double getObservedNumerator() {
        return this.getContinuumSize() * this.numObservers() * (this.numObservers() - 1);
    }

    protected double getObservedDenominator() {
        return this.recursiveObserved(new ArrayList<IAnnotationSet<IUnit>>(this.continuum.values()), 0, 0.0);
    }

    protected double recursiveObserved(List<IAnnotationSet<IUnit>> annotations, int set, double value) {
        for (IUnit g : annotations.get(set).getAnnotations()) {
            for (int i = set + 1; i < annotations.size(); ++i) {
                for (IUnit h : annotations.get(i).getAnnotations()) {
                    double intersect = this.intersectSize(g, h);
                    if (g.getCategory().equals(h.getCategory()) || !(intersect > 0.0)) continue;
                    double delta = this.deltaIghj(g, h);
                    value += delta;
                }
            }
        }
        if (set < annotations.size() - 2) {
            value = this.recursiveObserved(annotations, set + 1, value);
        }
        return value;
    }

    protected double deltaIghj(IUnit g, IUnit h) {
        if (!g.getCategory().equals(h.getCategory())) {
            return Math.pow(this.intersectSize(h, g), 2.0);
        }
        return 0.0;
    }

    protected double intersectSize(IUnit unitG, IUnit unitH) {
        return Math.min(unitH.getEndIndex(), unitG.getEndIndex()) - Math.max(unitG.getStartIndex(), unitH.getStartIndex());
    }

    protected double minSize(IUnit g, IUnit h) {
        return Math.min(this.unitSize(h), this.unitSize(g));
    }

    protected double maxSize(IUnit g, IUnit h) {
        return Math.max(this.unitSize(h), this.unitSize(g));
    }

    protected double unitSize(IUnit u) {
        return u.getEndIndex() - u.getStartIndex();
    }

    public int getContinuumSize() {
        return this.continumSize;
    }

    public int getContinuumStart() {
        return this.continuumBegin;
    }

    public int getContinuumEnd() {
        return this.continuumBegin + this.continumSize;
    }

    public IAnnotationSet<IUnit> getContinuum(String author) {
        return this.continuum.get(author);
    }

    public Map<String, IAnnotationSet<IUnit>> getContinuum() {
        return this.continuum;
    }

    protected void buildContinuum(ICorpus corpus) throws MeasureException {
        this.continuum = new HashMap<String, IAnnotationSet<IUnit>>();
        Map byAuthor = corpus.getUnitSet().getAnnotationSetByAuthor();
        this.continumSize = corpus.getTextSize();
        if (byAuthor.isEmpty()) {
            throw new MeasureException("Corpus doesn't contain annotations...");
        }
        for (String author : byAuthor.keySet()) {
            this.authors.add(author);
            AnnotationSetImpl continuumAuthor = new AnnotationSetImpl();
            int caret = this.continuumBegin;
            for (IUnit unit : ((IAnnotationSet)byAuthor.get(author)).getAnnotations()) {
                if (unit.getStartIndex() > caret) {
                    continuumAuthor.addAnnotation((IAnnotation)new UnitImpl(author, NA, caret, unit.getStartIndex()));
                }
                continuumAuthor.addAnnotation((IAnnotation)new UnitImpl(unit.getAuthor(), unit.getCategory(), unit.getStartIndex(), unit.getEndIndex()));
                caret = unit.getEndIndex();
            }
            if (caret < this.getContinuumEnd()) {
                continuumAuthor.addAnnotation((IAnnotation)new UnitImpl(author, NA, caret, this.getContinuumEnd()));
            }
            this.continuum.put(author, (IAnnotationSet<IUnit>)continuumAuthor);
        }
    }

    private int numObservers() {
        return this.authors.size();
    }

    public String measureRepport(ICorpus c) {
        String out = " // --------------- Krippendorff 2013 \n";
        DecimalFormat df = new DecimalFormat("0.000000");
        try {
            double total = this.measure(c);
            out = out + " \u03b1 = 1 - (" + df.format(this.getObserved()) + "/" + df.format(this.getExpected()) + ")\t  = " + df.format(total) + "\n";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            out = out + "/!\\ ERROR : " + ex.getMessage();
        }
        return out;
    }

    public boolean checkCorpus(ICorpus corpus) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

