/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.krippendorff.alpha2004;

import fr.unicaen.measure.core.IMeasure;
import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.model.AnnotationSetImpl;
import fr.unicaen.measure.model.IAnnotation;
import fr.unicaen.measure.model.IAnnotationSet;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.IUnit;
import fr.unicaen.measure.model.UnitImpl;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Alpha2004
implements IMeasure {
    private boolean VERBOSE = true;
    private List<String> authors = new ArrayList<String>();
    private List<String> categories = new ArrayList<String>();
    private ICorpus corpus;
    private int beginContinuum = -1;
    private int endContinum = -1;
    private Map<String, Double> observedDetails;
    private Map<String, Double> expectedDetails;
    private double totalObserved = 0.0;
    private double totalExpected = 0.0;
    private Map<String, Map<String, IAnnotationSet<IUnit>>> continuums = new HashMap<String, Map<String, IAnnotationSet<IUnit>>>();
    private static final int CONTINUUM_UNDEFINED = -1;
    public static String NA = "N-A";
    private static final int GAP = 0;
    private static final int IDENTIFIED_UNIT = 1;

    private void log(Object o) {
        if (this.VERBOSE) {
            System.out.println(o);
        }
    }

    public double getTotalObserved() {
        return this.totalObserved;
    }

    public double getTotalExpected() {
        return this.totalExpected;
    }

    public Alpha2004() {
        this(0, 300);
    }

    public Alpha2004(int continuumBegin, int continuumLength) {
        this.beginContinuum = continuumBegin;
        this.endContinum = this.beginContinuum + continuumLength;
    }

    public double getObservedDisagreement(IAnnotationSet<IUnit> cig, IAnnotationSet<IUnit> cjh, int cBegin, int cLength) throws KrippendorffException {
        double result = 0.0;
        IAnnotationSet<IUnit> cigContiniuum = this.buidContinuum(cig, cBegin, cBegin + cLength);
        IAnnotationSet<IUnit> cjhContiniuum = this.buidContinuum(cjh, cBegin, cBegin + cLength);
        for (IUnit unitG : cigContiniuum.getAnnotations()) {
            for (IUnit unitH : cjhContiniuum.getAnnotations()) {
                result += this.deltaCigjh(unitG, unitH);
            }
        }
        double doc = 2.0 * result / (2.0 * Math.pow(cLength, 2.0));
        this.log("--- OBSERVED DISAGREEMENT ---\n Cig:  " + cigContiniuum + "\n Cjh: " + cjhContiniuum);
        this.log("Doc = " + doc);
        this.log("-----------------------------");
        return doc;
    }

    public double getObservedDisagreement_v2(String category) throws KrippendorffException {
        Map<String, IAnnotationSet<IUnit>> annotations = this.getContinuum(category);
        double result = 0.0;
        double m = annotations.size();
        for (IAnnotationSet<IUnit> setA : annotations.values()) {
            for (IUnit unitA : setA.getAnnotations()) {
                for (IAnnotationSet<IUnit> setB : annotations.values()) {
                    if (setA == setB) continue;
                    for (IUnit unitB : setB.getAnnotations()) {
                        double delta = this.deltaCigjh(unitA, unitB);
                        result += delta;
                    }
                }
            }
        }
        double divisor = m * (m - 1.0) * Math.pow(this.endContinum - this.beginContinuum, 2.0);
        double observed = result / (m * (m - 1.0) * Math.pow(this.endContinum - this.beginContinuum, 2.0));
        this.log("\n--- OBSERVED DISAGREEMENT ---");
        this.log("Delta sum : " + result);
        this.log("Continuum from " + this.beginContinuum + "; size = " + (this.endContinum - this.beginContinuum));
        this.log("Divisor (m(m-1)L^2) : " + divisor);
        this.log("Observers : " + m);
        this.log("Doc = " + observed);
        this.log("-----------------------------");
        return observed;
    }

    public double getObservedDisagreement(String category) throws KrippendorffException {
        Map<String, IAnnotationSet<IUnit>> annotations = this.getContinuum(category);
        double result = this.calculateAlphaC(new ArrayList<IAnnotationSet<IUnit>>(annotations.values()));
        double m = annotations.size();
        double observed = result / (m * (m - 1.0) * Math.pow(this.endContinum - this.beginContinuum, m));
        return observed * 2.0;
    }

    protected double calculateAlphaC(List<IAnnotationSet<IUnit>> annotations, double value, int setA, int indexA, int setB, int indexB) throws KrippendorffException {
        value += this.deltaCigjh((IUnit)annotations.get(setA).getAnnotations().get(indexA), (IUnit)annotations.get(setB).getAnnotations().get(indexB));
        if (indexB + 1 < annotations.get(setB).getAnnotations().size()) {
            value = this.calculateAlphaC(annotations, value, setA, indexA, setB, indexB + 1);
        } else if (setB + 1 < annotations.size()) {
            value = this.calculateAlphaC(annotations, value, setA, indexA, setB + 1, 0);
        } else if (indexA + 1 < annotations.get(setA).getAnnotations().size()) {
            value = this.calculateAlphaC(annotations, value, setA, indexA + 1, setA + 1, 0);
        } else if (setA + 2 < annotations.size()) {
            value = this.calculateAlphaC(annotations, value, setA + 1, 0, setA + 2, 0);
        }
        return value;
    }

    protected double calculateAlphaC(List<IAnnotationSet<IUnit>> annotations) throws KrippendorffException {
        return this.calculateAlphaC(annotations, 0.0, 0, 0, 1, 0);
    }

    public double getExpectedDisagreement(String category) {
        double result = -1.0;
        Map<String, IAnnotationSet<IUnit>> annotations = this.getContinuum(category);
        AnnotationSetImpl all = new AnnotationSetImpl();
        for (IAnnotationSet<IUnit> set : annotations.values()) {
            all.addAnnotationsFrom(set);
        }
        int nc = 0;
        for (IUnit u : all.getAnnotations()) {
            if (u.getCategory().equals(NA)) continue;
            ++nc;
        }
        int m = 2;
        double divisor = 0.0;
        for (IUnit unitG : all.getAnnotations()) {
            if (unitG.getCategory().equals(NA)) continue;
            divisor += (double)this.vCig(unitG) * this.l(unitG) * (this.l(unitG) - 1.0);
            double y = nc - 1;
            double resultG = y / 3.0 * (2.0 * Math.pow(this.l(unitG), 3.0) - 3.0 * Math.pow(this.l(unitG), 2.0) + this.l(unitG));
            double resultIff = 0.0;
            for (IUnit unitH : all.getAnnotations()) {
                if (unitG.equals(unitH) || !(this.l(unitH) >= this.l(unitG)) || !unitH.getCategory().equals(NA)) continue;
                resultIff += (double)(1 - this.vCig(unitH)) * (this.l(unitH) - this.l(unitG) + 1.0);
            }
            double resultIffF = Math.pow(this.l(unitG), 2.0) * resultIff;
            result += (resultG += resultIffF);
        }
        double dec = 2.0 / (double)this.getCLenght() * result;
        double dividedBy = (double)(2 * this.getCLenght() * (2 * this.getCLenght() - 1)) - divisor;
        return dec /= dividedBy;
    }

    protected int getCLenght() {
        return this.endContinum - this.beginContinuum;
    }

    public double getExpectedDisagreement(IAnnotationSet<IUnit> cig, IAnnotationSet<IUnit> cjh, int cBegin, int cLength) throws KrippendorffException {
        int nc = cig.getAnnotations().size() + cjh.getAnnotations().size();
        int m = 2;
        AnnotationSetImpl all = new AnnotationSetImpl();
        IAnnotationSet<IUnit> cigContiniuum = this.buidContinuum(cig, cBegin, cBegin + cLength);
        all.addAnnotationsFrom(cigContiniuum);
        IAnnotationSet<IUnit> cjhContiniuum = this.buidContinuum(cjh, cBegin, cBegin + cLength);
        all.addAnnotationsFrom(cjhContiniuum);
        System.out.println(all);
        double result = 0.0;
        double divisor = 0.0;
        String divisorLog = "";
        for (IUnit unitG : all.getAnnotations()) {
            if (unitG.getCategory().equals(NA)) continue;
            divisor += (double)this.vCig(unitG) * this.l(unitG) * (this.l(unitG) - 1.0);
            double y = nc - 1;
            double resultG = y / 3.0 * (2.0 * Math.pow(this.l(unitG), 3.0) - 3.0 * Math.pow(this.l(unitG), 2.0) + this.l(unitG));
            double resultIff = 0.0;
            for (IUnit unitH : all.getAnnotations()) {
                if (unitG.equals(unitH) || !(this.l(unitH) >= this.l(unitG)) || !unitH.getCategory().equals(NA)) continue;
                resultIff += (double)(1 - this.vCig(unitH)) * (this.l(unitH) - this.l(unitG) + 1.0);
            }
            double resultIffF = Math.pow(this.l(unitG), 2.0) * resultIff;
            result += (resultG += resultIffF);
        }
        double dec = 2.0 / (double)cLength * result;
        double dividedBy = (double)(2 * cLength * (2 * cLength - 1)) - divisor;
        return dec /= dividedBy;
    }

    public double getDoc(IAnnotationSet<IUnit> annotation, int continuumSize) throws KrippendorffException {
        Map byCategory = annotation.getAnnotationSetByCategory();
        HashMap sorted = new HashMap();
        for (String category : byCategory.keySet()) {
            System.out.println("category : " + category);
            Map byAuthor = ((IAnnotationSet)byCategory.get(category)).getAnnotationSetByAuthor();
            System.out.println("Nb author: " + byAuthor.size());
            IAnnotationSet[] sets = new IAnnotationSet[byAuthor.size()];
            int i = 0;
            int identifiedUnits = 0;
            for (String author : byAuthor.keySet()) {
                System.out.println(" +--- > author : " + author);
                identifiedUnits += ((IAnnotationSet)byAuthor.get(author)).getAnnotations().size();
                sets[i] = (IAnnotationSet)byAuthor.get(author);
            }
            double compareSet = this.getDoCategory(sets, 0, 0.0);
            System.out.println(" +--- Nombre d'unit\u00e9 annot\u00e9e : " + identifiedUnits);
        }
        double disagreement = 0.0;
        return disagreement;
    }

    protected double getDoCategory(IAnnotationSet<IUnit>[] sets, int index, double value) {
        for (int i = index; i < sets.length; ++i) {
            System.out.println(index + " ---> " + i);
            value += this.getDoCategory(sets, index + 1, value);
        }
        return value;
    }

    public double getAlphaReliabilityCategory(String category) throws KrippendorffException {
        return 1.0 - this.getObservedDisagreement(category) / this.getExpectedDisagreement(category);
    }

    public double getAlphaReliability() throws KrippendorffException {
        this.totalObserved = 0.0;
        this.totalExpected = 0.0;
        this.observedDetails = new HashMap<String, Double>();
        this.expectedDetails = new HashMap<String, Double>();
        for (String category : this.categories) {
            double cObserved = this.getObservedDisagreement(category);
            double cExpected = this.getExpectedDisagreement(category);
            this.observedDetails.put(category, cObserved);
            this.expectedDetails.put(category, cExpected);
            this.totalExpected += cExpected;
            this.totalObserved += cObserved;
        }
        return 1.0 - this.totalObserved / this.totalExpected;
    }

    public String measureRepport(ICorpus c) {
        String out = "++++++++++++++++++++++++++++++++++++++++++++++ Krippendorff measure +++\n";
        try {
            double total = this.measure(c);
            DecimalFormat df = new DecimalFormat("0.000000");
            out = " // --------------- Krippendorff 2004 \n";
            out = out + " \u03b1 = 1 - (" + df.format(this.totalObserved) + "/" + df.format(this.totalExpected) + ")\t  = " + df.format(total) + "\n";
        }
        catch (Exception ex) {
            out = out + "/!\\ ERROR : " + ex.getMessage();
        }
        return out;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    protected void setCorpus(ICorpus corpus) {
        this.corpus = corpus;
        this.authors = new ArrayList<String>();
        this.categories = new ArrayList<String>();
        this.continuums = new HashMap<String, Map<String, IAnnotationSet<IUnit>>>();
        Map annotationsCategories = corpus.getUnitSet().getAnnotationSetByCategory();
        for (String author : corpus.getUnitSet().getAnnotationSetByAuthor().keySet()) {
            this.authors.add(author);
        }
        for (String category : annotationsCategories.keySet()) {
            this.categories.add(category);
            HashMap<String, IAnnotationSet<IUnit>> continuumsCategory = new HashMap<String, IAnnotationSet<IUnit>>();
            Map annotationsAuthorForCategory = ((IAnnotationSet)annotationsCategories.get(category)).getAnnotationSetByAuthor();
            for (String author : this.authors) {
                IAnnotationSet<IUnit> continuumAuthor = this.buidContinuum((IAnnotationSet<IUnit>)((IAnnotationSet)annotationsAuthorForCategory.get(author)), author, category, this.beginContinuum, this.endContinum);
                continuumsCategory.put(author, continuumAuthor);
            }
            this.continuums.put(category, continuumsCategory);
        }
    }

    protected IAnnotationSet<IUnit> getContinuum(String category, String author) {
        return this.getContinuum(category).get(author);
    }

    protected Map<String, IAnnotationSet<IUnit>> getContinuum(String category) {
        return this.continuums.get(category);
    }

    public double measure(ICorpus corpus) throws MeasureException {
        this.setCorpus(corpus);
        try {
            return this.getAlphaReliability();
        }
        catch (KrippendorffException ex) {
            throw new MeasureException(ex.getMessage());
        }
    }

    public double getAlpha(double observedDisagreement, double expectedDisagreement) {
        return 1.0 - observedDisagreement / expectedDisagreement;
    }

    protected double deltaCigjh(IUnit unitG, IUnit unitH) throws KrippendorffException {
        if (unitG.getAuthor().equals(unitH.getAuthor())) {
            throw new KrippendorffException("unit G and H have same author.");
        }
        if (!(unitG.getCategory().equals(unitH.getCategory()) || unitG.getCategory().equals(NA) || unitH.getCategory().equals(NA))) {
            throw new KrippendorffException("DELTA cigjh require unit GAP or Same category");
        }
        if (!unitG.getCategory().equals(NA) && !unitH.getCategory().equals(NA) && -this.l(unitG) < this.b(unitG) - this.b(unitH) && this.b(unitG) - this.b(unitH) < this.l(unitH)) {
            double delta = Math.pow(this.b(unitG) - this.b(unitH), 2.0) + Math.pow(this.b(unitG) + this.l(unitG) - this.b(unitH) - this.l(unitH), 2.0);
            return delta;
        }
        if (!unitG.getCategory().equals(NA) && unitH.getCategory().equals(NA) && this.l(unitH) - this.l(unitG) >= this.b(unitG) - this.b(unitH) && this.b(unitG) - this.b(unitH) >= 0.0) {
            double delta = Math.pow(this.l(unitG), 2.0);
            return delta;
        }
        if (unitG.getCategory().equals(NA) && !unitH.getCategory().equals(NA) && this.l(unitH) - this.l(unitG) <= this.b(unitG) - this.b(unitH) && this.b(unitG) - this.b(unitH) <= 0.0) {
            double delta = Math.pow(this.l(unitH), 2.0);
            return delta;
        }
        return 0.0;
    }

    protected IAnnotationSet<IUnit> buidContinuum(IAnnotationSet<IUnit> as, String author, String category, int begin, int maxSize) {
        AnnotationSetImpl set = new AnnotationSetImpl();
        int indexContinuum = begin;
        if (as != null && as.getAnnotations() != null) {
            for (IUnit u : as.getAnnotations()) {
                if (u.getStartIndex() > indexContinuum) {
                    set.addAnnotation((IAnnotation)new UnitImpl(author, NA, indexContinuum, u.getStartIndex()));
                }
                set.addAnnotation((IAnnotation)u);
                indexContinuum = u.getEndIndex();
            }
        }
        if (indexContinuum < maxSize) {
            set.addAnnotation((IAnnotation)new UnitImpl(author, NA, indexContinuum, maxSize));
        }
        return set;
    }

    protected IAnnotationSet<IUnit> buidContinuum(IAnnotationSet<IUnit> get, int beginContinuum, int endContinum) {
        String author = ((IUnit)get.getAnnotations().get(0)).getAuthor();
        String category = ((IUnit)get.getAnnotations().get(0)).getCategory();
        return this.buidContinuum(get, author, category, beginContinuum, endContinum);
    }

    protected boolean areSameNoGap(IUnit unitG, IUnit unitH) {
        return this.vCig(unitG) == this.vCig(unitH) && this.vCig(unitH) == 1;
    }

    protected double getNonOverlappingSize(IUnit unitG, IUnit unitH) {
        return 0.0;
    }

    protected int vCig(IUnit cig) {
        return cig.getCategory().equals(NA) ? 0 : 1;
    }

    protected double l(IUnit unit) {
        return unit.getEndIndex() - unit.getStartIndex();
    }

    protected double b(IUnit unit) {
        return unit.getStartIndex();
    }

    public boolean checkCorpus(ICorpus corpus) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    class KrippendorffException
    extends Exception {
        private KrippendorffException(String message) {
            super(message);
        }
    }
}

