/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.krippendorff;

import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.krippendorff.alphaClu2013.Alphaclu;
import fr.unicaen.measure.krippendorff.alphaClu2013.Bootstrapping;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.utils.KrippendorffFormatUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class TestBootStrap {
    public static void main(String[] args) throws MeasureException {
        String file1 = TestBootStrap.class.getResource("/single-valued-book-02.csv").getPath();
        ICorpus c = KrippendorffFormatUtils.loadFromFile((String)file1);
        System.out.println(c);
        ArrayList categories = new ArrayList(c.getUnitSet().getAnnotationSetByCategory().keySet());
        Alphaclu measure = new Alphaclu();
        double total = measure.measure(c);
        System.out.println(measure.repport());
        Bootstrapping bootstrap = new Bootstrapping(measure, c);
        bootstrap.bootstrap();
        XYSeries alpha = new XYSeries((Comparable)((Object)"Alpha"));
        Map<Double, Double> bootstrapDatas = bootstrap.getBootstrapDatas();
        for (Double alphaDt : bootstrapDatas.keySet()) {
            alpha.add((Number)alphaDt, (Number)bootstrapDatas.get(alphaDt));
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(alpha);
        JFreeChart chart = ChartFactory.createXYBarChart((String)"Bootstrapping", (String)"Alpha", (boolean)false, (String)"Number", (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        chart.setAntiAlias(true);
        XYPlot plot = chart.getXYPlot();
        chart.setBackgroundPaint((Paint)Color.white);
        plot.setOutlinePaint((Paint)Color.black);
        XYBarRenderer renderer = (XYBarRenderer)plot.getRenderer();
        renderer.setMargin(0.985);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(800, 600));
        JFrame f = new JFrame("Bootstrap");
        f.setSize(800, 600);
        f.add((Component)chartPanel);
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
    }
}

