/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.krippendorff;

import com.jacksay.sgarnish.containers.JckApplicationFrame;
import com.jacksay.sgarnish.i18n.JckResourceBundle;
import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.gui.actions.ActionImportCorpus;
import fr.unicaen.measure.gui.model.ICorpusImportListener;
import fr.unicaen.measure.gui.views.STCorpusViewController;
import fr.unicaen.measure.gui.views.STCorpusViewPreview;
import fr.unicaen.measure.krippendorff.AlphaUI;
import fr.unicaen.measure.krippendorff.alpha2013.Krippendorff2013Bis;
import fr.unicaen.measure.krippendorff.alphaClu2013.AlphacluNew;
import fr.unicaen.measure.krippendorff.alphaClu2013.AlphafluNew2;
import fr.unicaen.measure.krippendorff.alphaClu2013.AlphakluNew;
import fr.unicaen.measure.krippendorff.alphaClu2013.AlphaluBase;
import fr.unicaen.measure.krippendorff.alphaClu2013.AlphaluNew2;
import fr.unicaen.measure.krippendorff.alphaClu2013.Bootstrapping;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013Interval;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013Interval01;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013Nominal;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013Ratio;
import fr.unicaen.measure.model.CorpusImpl;
import fr.unicaen.measure.model.IAnnotation;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.UnitImpl;
import fr.unicaen.measure.sufflingplugin.CorpusObservableImpl;
import fr.unicaen.measure.sufflingplugin.ICorpusListenner;
import fr.unicaen.measure.sufflingplugin.ICorpusObservable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class AlphaUI_old
extends JckApplicationFrame
implements ICorpusImportListener,
ICorpusListenner {
    private Thread currentThread = null;
    public static String[] confidenceStrings = new String[]{"99%", "98%", "95%", "90%"};
    public static double[] pValues = new double[]{0.01, 0.02, 0.05, 0.1};
    public static String[] alphaMinStrings = new String[]{"0.9", "0.8", "0.7", "0.6"};
    public static double[] alphaMinValues = new double[]{0.9, 0.8, 0.7, 0.6};
    public static final String METRIC_NOMINAL = "nominal";
    public static final String METRIC_INTERVAL = "interval";
    public static final String METRIC_INTERVAL_01 = "interval (0,1)";
    public static final String METRIC_RATIO = "ratio";
    public static final String ALPHA_CLU = "Alpha c|u";
    public static final String ALPHA_KLU = "Alpha k|u";
    public static final String ALPHA_FLU = "Alpha f|u";
    public static final String ALPHA_LU = "Alpha 0|u";
    public static final String ALL = "all";
    private ActionImportCorpus actionImport;
    CorpusObservableImpl corpus;
    STCorpusViewPreview corpusPreview;
    STCorpusViewController corpusPreviewController;
    JSplitPane mainV;
    JTextField alphaUField;
    JTextField alphaCluField;
    JTextField alphaFluField;
    JTextField alphaLuField;
    JTextArea alphaKluArea;
    Krippendorff2013Bis alphaU;
    AlphacluNew alphaClu;
    AlphafluNew2 alphaFlu;
    AlphaluNew2 alphalu;
    AlphakluNew alphaKlu;
    HashMap<String, String> metrics;
    DecimalFormat format = new DecimalFormat("0.000");
    private JLabel labelAlphaU;
    private JLabel labelAlphaClu;
    private JLabel labelAlphaFlu;
    private JLabel labelAlphaLu;
    private JLabel labelAlphaKlu;
    private JLabel labelBootstrapClu;
    private JLabel labelBootstrapLu;
    private JLabel labelBootstrapFlu;
    private JComboBox confidenceList;
    private JComboBox alphaMinList;

    public Metric2013 generateMetric(String metricName) {
        System.out.println("Metric name : " + metricName);
        if (metricName.equals(METRIC_INTERVAL)) {
            return new Metric2013Interval(new ArrayList<String>(this.corpus.getCorpus().getUnitSet().getAnnotationSetByCategory().keySet()));
        }
        if (metricName.equals(METRIC_INTERVAL_01)) {
            return new Metric2013Interval01(new ArrayList<String>(this.corpus.getCorpus().getUnitSet().getAnnotationSetByCategory().keySet()));
        }
        if (metricName.equals(METRIC_RATIO)) {
            return new Metric2013Ratio(new ArrayList<String>(this.corpus.getCorpus().getUnitSet().getAnnotationSetByCategory().keySet()));
        }
        return new Metric2013Nominal();
    }

    public AlphaUI_old() {
        this.msgClosing = false;
    }

    protected void initializeComponment() {
        super.initializeComponment();
        this.alphaU = new Krippendorff2013Bis();
        this.alphaClu = new AlphacluNew();
        this.alphaFlu = new AlphafluNew2();
        this.alphalu = new AlphaluNew2();
        this.alphaKlu = new AlphakluNew();
        this.metrics = new HashMap();
        this.metrics.put(ALPHA_CLU, METRIC_NOMINAL);
        this.metrics.put(ALPHA_FLU, METRIC_NOMINAL);
        this.metrics.put(ALPHA_LU, METRIC_NOMINAL);
        this.metrics.put(ALPHA_KLU, METRIC_NOMINAL);
        this.metrics.put(ALL, METRIC_NOMINAL);
        this.alphaUField = new JTextField(8);
        this.alphaCluField = new JTextField(8);
        this.alphaFluField = new JTextField(8);
        this.alphaLuField = new JTextField(8);
        this.alphaKluArea = new JTextArea();
        this.mainFrame.setLayout(new BoxLayout(this.mainFrame, 1));
        JTabbedPane measuresDetails = new JTabbedPane();
        Box settings = Box.createHorizontalBox();
        settings.setBorder(BorderFactory.createTitledBorder("Settings"));
        JLabel label = new JLabel("Metric =");
        settings.add(label);
        settings.add(this.getMetricSelector(ALL));
        this.getMetricSelector(ALL).setPreferredSize(new Dimension(150, 30));
        settings.add(Box.createHorizontalStrut(150));
        label = new JLabel("confidence =");
        settings.add(label);
        this.confidenceList = new JComboBox<String>(confidenceStrings);
        settings.add(this.confidenceList);
        this.confidenceList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlphaUI_old.this.computeBootstrapsThreaded();
            }
        });
        settings.add(Box.createHorizontalStrut(150));
        label = new JLabel("<html><span style='font-size:20'>\u03b1</span><sub>min</sub> =</html> ");
        settings.add(label);
        this.alphaMinList = new JComboBox<String>(alphaMinStrings);
        settings.add(this.alphaMinList);
        this.alphaMinList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlphaUI_old.this.computeBootstrapsThreaded();
            }
        });
        JPanel measures = new JPanel();
        measures.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        this.labelAlphaU = new JLabel("<html><sub>U</sub><span style='font-size:20'>\u03b1</span></html>");
        measures.add((Component)this.labelAlphaU, c);
        c.gridx = 1;
        c.fill = 2;
        measures.add((Component)this.alphaUField, c);
        this.alphaUField.setPreferredSize(new Dimension(140, 30));
        c.gridx = 0;
        c.gridy = 1;
        this.labelAlphaLu = new JLabel("<html><sub>u</sub><span style='font-size:20'>\u03b1</span></html>");
        measures.add((Component)this.labelAlphaLu, c);
        c.gridx = 1;
        c.fill = 2;
        measures.add((Component)this.alphaLuField, c);
        this.alphaLuField.setPreferredSize(new Dimension(140, 30));
        this.labelBootstrapLu = new JLabel("");
        this.labelBootstrapLu.setPreferredSize(new Dimension(400, 30));
        c.gridx = 2;
        measures.add((Component)this.labelBootstrapLu, c);
        c.gridx = 0;
        c.gridy = 2;
        this.labelAlphaFlu = new JLabel("<html><sub>\u0424|u</sub><span style='font-size:20'>\u03b1</span></html>");
        measures.add((Component)this.labelAlphaFlu, c);
        c.gridx = 1;
        c.fill = 2;
        measures.add((Component)this.alphaFluField, c);
        this.alphaFluField.setPreferredSize(new Dimension(140, 30));
        this.labelBootstrapFlu = new JLabel("");
        c.gridx = 2;
        this.labelBootstrapFlu.setPreferredSize(new Dimension(400, 30));
        measures.add((Component)this.labelBootstrapFlu, c);
        c.gridx = 0;
        c.gridy = 3;
        this.labelAlphaClu = new JLabel("<html><sub>cu</sub><span style='font-size:20'>\u03b1</span></html>");
        measures.add((Component)this.labelAlphaClu, c);
        c.gridx = 1;
        c.fill = 2;
        measures.add((Component)this.alphaCluField, c);
        this.alphaCluField.setPreferredSize(new Dimension(150, 30));
        this.labelBootstrapClu = new JLabel("");
        this.labelBootstrapClu.setPreferredSize(new Dimension(400, 30));
        c.gridx = 2;
        measures.add((Component)this.labelBootstrapClu, c);
        c.gridx = 0;
        c.gridy = 4;
        this.labelAlphaKlu = new JLabel("<html><sub>k.u</sub><span style='font-size:20'>\u03b1</span></html>");
        measures.add((Component)this.labelAlphaKlu, c);
        c.gridx = 1;
        JScrollPane js = new JScrollPane(this.alphaKluArea);
        measures.add((Component)js, c);
        js.setPreferredSize(new Dimension(140, 85));
        this.corpus = new CorpusObservableImpl(70);
        this.corpusPreview = new STCorpusViewPreview((ICorpusObservable)this.corpus, false);
        this.corpusPreviewController = new STCorpusViewController(this.corpusPreview, (ICorpusObservable)this.corpus);
        JPanel viewCorpus = new JPanel();
        viewCorpus.setBorder(BorderFactory.createTitledBorder("Annotations"));
        viewCorpus.setLayout(new BorderLayout());
        viewCorpus.add((Component)this.corpusPreview, "Center");
        viewCorpus.add((Component)this.corpusPreviewController, "First");
        measures.setBorder(BorderFactory.createTitledBorder("Results"));
        measures.setMaximumSize(new Dimension(800, 600));
        this.mainFrame.add(settings);
        this.mainFrame.add(measures);
        this.mainFrame.add(viewCorpus);
    }

    private JComboBox getMetricSelector(String alphaName) {
        String[] items = new String[]{METRIC_NOMINAL, METRIC_INTERVAL, METRIC_INTERVAL_01, METRIC_RATIO};
        final JComboBox<String> c = new JComboBox<String>(items);
        final String alpha = alphaName;
        c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Change for " + alpha + " to metric " + c.getSelectedItem());
                AlphaUI_old.this.metrics.put(alpha, c.getSelectedItem().toString());
                AlphaUI_old.this.measureAll();
            }
        });
        return c;
    }

    public void initializeConfiguration() {
        JckResourceBundle.addResourceFile((String)"kk");
    }

    public static void main(String[] args) {
        AlphaUI app = new AlphaUI();
        app.onCorpusImported((ICorpus)AlphaUI_old.getBookExample1SecondPrinting());
    }

    protected void populateFile(JMenu menuFile) {
        this.actionImport = new ActionImportCorpus();
        this.actionImport.addCorpusImportListenner((ICorpusImportListener)this);
        menuFile.add(new JMenuItem((Action)this.actionImport));
    }

    public void onCorpusImported(ICorpus c) {
        System.out.println("Imported corpus");
        this.corpus.loadCorpus(c);
        this.corpus.addCorpusListener((ICorpusListenner)this);
        System.out.println("size=" + c.getTextSize());
        this.measureAll();
        this.corpusPreview.updateUI();
    }

    public void measureAll() {
        if (this.corpus == null) {
            return;
        }
        ICorpus c = this.corpus.getCorpus();
        if (c.getUnitSet().getAnnotations().size() <= 0) {
            return;
        }
        try {
            this.alphaU = new Krippendorff2013Bis(this.generateMetric(this.metrics.get(ALL)));
            this.labelAlphaU.setText("<html><sub>U</sub><span style='font-size:20'>\u03b1</span><sub>" + this.metrics.get(ALL) + "</sub></html>");
            this.alphaUField.setText(this.format.format(this.alphaU.measure(c)));
        }
        catch (MeasureException ex) {
            this.alphaUField.setText("Error");
        }
        try {
            this.alphaClu = new AlphacluNew(this.generateMetric(this.metrics.get(ALL)));
            this.labelAlphaClu.setText("<html><sub>cu</sub><span style='font-size:20'>\u03b1</span><sub>" + this.metrics.get(ALL) + "</sub></html>");
            this.alphaCluField.setText(this.format.format(this.alphaClu.measure(c)));
        }
        catch (MeasureException ex) {
            this.alphaCluField.setText("Error");
        }
        try {
            this.alphaKlu = new AlphakluNew(this.generateMetric(this.metrics.get(ALL)));
            this.labelAlphaKlu.setText("<html><sub>k.u</sub><span style='font-size:20'>\u03b1</span><sub>" + this.metrics.get(ALL) + "</sub></html>");
            String s = "";
            double[] results = this.alphaKlu.allMeasures(c);
            for (int i = 0; i < this.alphaKlu.getCategories().size(); ++i) {
                if (i != 0) {
                    s = s + "\n";
                }
                s = s + this.alphaKlu.getCategories().get(i) + "|u-\u03b1=" + (Double.isNaN(results[i]) ? "undefined" : this.format.format(results[i]));
            }
            this.alphaKluArea.setText(s);
        }
        catch (MeasureException ex) {
            this.alphaKluArea.setText("Error");
        }
        try {
            this.alphaFlu = new AlphafluNew2();
            this.labelAlphaFlu.setText("<html><sub>\u0424|u</sub><span style='font-size:20'>\u03b1</span><sub>nominal</sub></html>");
            this.alphaFluField.setText(this.format.format(this.alphaFlu.measure(c)));
        }
        catch (MeasureException ex) {
            this.alphaFluField.setText("Error");
        }
        try {
            this.alphalu = new AlphaluNew2();
            this.labelAlphaLu.setText("<html><sub>u</sub><span style='font-size:20'>\u03b1</span><sub>nominal</sub></html>");
            this.alphaLuField.setText(this.format.format(this.alphalu.measure(c)));
        }
        catch (MeasureException ex) {
            this.alphaLuField.setText("Error");
        }
        this.computeBootstrapsThreaded();
    }

    private void computeBootstrapsThreaded() {
        this.currentThread = new Thread(){

            @Override
            public void run() {
                AlphaUI_old.this.computeBootstraps();
            }
        };
        this.currentThread.start();
    }

    private void clearBootstraps() {
        this.labelBootstrapClu.setText("");
        this.labelBootstrapFlu.setText("");
        this.labelBootstrapLu.setText("");
    }

    private void computeBootstraps() {
        this.clearBootstraps();
        try {
            if (this.corpus.getCorpus().getUnitSet().getAnnotations().size() == 0) {
                return;
            }
            this.bootstrap(this.alphalu, this.labelBootstrapLu);
            Thread.sleep(20L);
            this.bootstrap(this.alphaFlu, this.labelBootstrapFlu);
            Thread.sleep(20L);
            this.bootstrap(this.alphaClu, this.labelBootstrapClu);
            Thread.sleep(20L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(AlphaUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void bootstrap(AlphaluBase alpha, JLabel label) {
        String content = "";
        label.setText("  Computing... please wait.");
        double p = pValues[this.confidenceList.getSelectedIndex()];
        double alphaMin = alphaMinValues[this.alphaMinList.getSelectedIndex()];
        try {
            Bootstrapping b = new Bootstrapping(alpha, this.corpus.getCorpus(), 100, p, alphaMin);
            b.bootstrap();
            content = content + "  " + this.format.format(b.getMinimumConfidenceInterval()) + " < \u03b1 < " + this.format.format(b.getMaximumConfidenceInterval()) + " (at " + this.confidenceList.getSelectedItem() + ")";
            content = content + "       q=" + this.format.format(b.getqPobability()) + " (\u03b1 not reaching " + this.alphaMinList.getSelectedItem() + ")";
        }
        catch (MeasureException ex) {
            content = "error while computing the bootstrap";
        }
        label.setText(content);
    }

    public static CorpusImpl getBookExample1SecondPrinting() {
        CorpusImpl c = new CorpusImpl(76, 1);
        UnitImpl u = new UnitImpl("coder 1", "1", 2, 17);
        c.getUnitSet().addAnnotation((IAnnotation)u);
        u = new UnitImpl("coder 1", "1", 22, 37);
        c.getUnitSet().addAnnotation((IAnnotation)u);
        u = new UnitImpl("coder 1", "2", 58, 68);
        c.getUnitSet().addAnnotation((IAnnotation)u);
        u = new UnitImpl("coder 1", "4", 70, 75);
        c.getUnitSet().addAnnotation((IAnnotation)u);
        u = new UnitImpl("coder 2", "1", 2, 17);
        c.getUnitSet().addAnnotation((IAnnotation)u);
        u = new UnitImpl("coder 2", "3", 32, 45);
        c.getUnitSet().addAnnotation((IAnnotation)u);
        u = new UnitImpl("coder 2", "5", 45, 48);
        c.getUnitSet().addAnnotation((IAnnotation)u);
        u = new UnitImpl("coder 2", "1", 58, 63);
        c.getUnitSet().addAnnotation((IAnnotation)u);
        u = new UnitImpl("coder 2", "4", 70, 75);
        c.getUnitSet().addAnnotation((IAnnotation)u);
        return c;
    }

    public void onCorpusChanged(ICorpus corpus) {
        this.measureAll();
    }
}

