/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.krippendorff;

import com.jacksay.matrix.MatrixNumeric;
import com.jacksay.sgarnish.containers.JckApplicationFrame;
import com.jacksay.sgarnish.i18n.JckResourceBundle;
import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.gui.actions.ActionImportCorpus;
import fr.unicaen.measure.gui.model.ICorpusImportListener;
import fr.unicaen.measure.gui.views.STCorpusViewController;
import fr.unicaen.measure.gui.views.STCorpusViewPreview;
import fr.unicaen.measure.krippendorff.AcceptLicence;
import fr.unicaen.measure.krippendorff.MyDecimalFormat;
import fr.unicaen.measure.krippendorff.MyMatrixFormat;
import fr.unicaen.measure.krippendorff.alpha2013.Krippendorff2013Bis;
import fr.unicaen.measure.krippendorff.alpha2013.KrippendorffUAlpha2015;
import fr.unicaen.measure.krippendorff.alphaClu2013.Alphaclu3;
import fr.unicaen.measure.krippendorff.alphaClu2013.AlphafluNew2;
import fr.unicaen.measure.krippendorff.alphaClu2013.AlphakluNew;
import fr.unicaen.measure.krippendorff.alphaClu2013.AlphaluBase;
import fr.unicaen.measure.krippendorff.alphaClu2013.AlphaluNew2;
import fr.unicaen.measure.krippendorff.alphaClu2013.Bootstrapping11Avril2015;
import fr.unicaen.measure.krippendorff.alphaClu2013.BootstrappingU;
import fr.unicaen.measure.krippendorff.alphaClu2013.BootstrappingU2015;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013Interval;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013NoMetric;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013Nominal2;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013Ordinal;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013Ratio;
import fr.unicaen.measure.model.CorpusImpl;
import fr.unicaen.measure.model.IAnnotation;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.UnitImpl;
import fr.unicaen.measure.sufflingplugin.CorpusObservableImpl;
import fr.unicaen.measure.sufflingplugin.ICorpusListenner;
import fr.unicaen.measure.sufflingplugin.ICorpusObservable;
import fr.unicaen.measure.utils.CorpusUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class AlphaUI
extends JckApplicationFrame
implements ICorpusImportListener,
ICorpusListenner,
ActionListener {
    public static Preferences preferences = Preferences.userNodeForPackage(AlphaUI.class);
    private boolean showCovering = preferences.getBoolean("showCovering", true);
    public MyMatrixFormat matrixFormat = new MyMatrixFormat();
    private boolean binary = false;
    private double alphaCluValue;
    private double alphaLuValue;
    private double alphaFluValue;
    private double alphaUValue;
    private static final int U = 0;
    private static final int LU = 1;
    private static final int FLU = 2;
    private static final int CLU = 3;
    private static final int KLU = 4;
    private Thread currentThread = null;
    private static final String SHOW_MATRICES = "<html><center><span style='color:blue; text-decoration: underline;'>show<br></span></center></html>";
    private static final int COL_MATRICES = 5;
    public static String[] confidenceStrings = new String[]{"99%", "98%", "95%", "90%"};
    public static double[] pValues = new double[]{0.01, 0.02, 0.05, 0.1};
    public static String[] alphaMinStrings = new String[]{"0.9", "0.8", "0.7", "0.667", "0.6"};
    public static double[] alphaMinValues = new double[]{0.9, 0.8, 0.7, 0.667, 0.6};
    public static final String METRIC_NOMINAL = "nominal";
    public static final String METRIC_ORDINAL = "ordinal";
    public static final String METRIC_INTERVAL = "interval";
    public static final String METRIC_INTERVAL_01 = "interval (0,1)";
    public static final String METRIC_RATIO = "ratio";
    public static final String METRIC_NOMETRIC = "no metric";
    public static final String ALPHA_CLU = "Alpha c|u";
    public static final String ALPHA_KLU = "Alpha k|u";
    public static final String ALPHA_FLU = "Alpha f|u";
    public static final String ALPHA_LU = "Alpha 0|u";
    public static final String ALL = "all";
    public static final String COMPUTING = "Computing, please wait";
    private ActionImportCorpus actionImport;
    CorpusObservableImpl corpus;
    STCorpusViewPreview corpusPreview;
    STCorpusViewController corpusPreviewController;
    JSplitPane mainV;
    JTextField alphaU2015Field;
    JTextField alphaUField;
    JTextField alphaCluField;
    JTextField alphaFluField;
    JTextField alphaLuField;
    JTextArea alphaKluArea;
    KrippendorffUAlpha2015 alphaU2015;
    Alphaclu3 alphaClu;
    AlphafluNew2 alphaFlu;
    AlphaluNew2 alphalu;
    AlphakluNew alphaKlu;
    HashMap<String, String> metrics;
    MyDecimalFormat format = new MyDecimalFormat();
    private JLabel labelAlphaU2015;
    private JLabel labelAlphaU;
    private JLabel labelAlphaClu;
    private JLabel labelAlphaFlu;
    private JLabel labelAlphaLu;
    private JLabel labelAlphaKlu;
    private JLabel labelBootstrapClu;
    private JLabel labelBootstrapLu;
    private JLabel labelBootstrapFlu;
    private JComboBox confidenceList;
    private JComboBox alphaMinList;
    private JTable measures;
    private JCheckBoxMenuItem alphaUCheck;
    private JCheckBoxMenuItem alphauCheck;
    private JCheckBoxMenuItem alphaCluCheck;
    private JCheckBoxMenuItem alphaFluCheck;
    private JCheckBoxMenuItem alphaKluCheck;

    public Metric2013 generateMetric(String metricName) {
        if (metricName.equals(METRIC_INTERVAL)) {
            return new Metric2013Interval(new ArrayList<String>(this.corpus.getCorpus().getUnitSet().getAnnotationSetByCategory().keySet()));
        }
        if (metricName.equals(METRIC_ORDINAL)) {
            System.out.println(new Metric2013Ordinal(this.corpus.getCorpus()));
            return new Metric2013Ordinal(this.corpus.getCorpus());
        }
        if (metricName.equals(METRIC_RATIO)) {
            return new Metric2013Ratio(new ArrayList<String>(this.corpus.getCorpus().getUnitSet().getAnnotationSetByCategory().keySet()));
        }
        if (metricName.equals(METRIC_NOMETRIC)) {
            return new Metric2013NoMetric(this.corpus.getCorpus());
        }
        return new Metric2013Nominal2(this.corpus.getCorpus());
    }

    public AlphaUI() {
        this.msgClosing = false;
        JMenu menuChoice = new JMenu("Select measures");
        this.alphaUCheck = new JCheckBoxMenuItem("<html><sub>U_2015</sub><span style='font-size:20'>\u03b1</span><sub>");
        this.alphauCheck = new JCheckBoxMenuItem("<html><sub>u</sub><span style='font-size:20'>\u03b1</span><sub>");
        this.alphaCluCheck = new JCheckBoxMenuItem("<html><sub>cu</sub><span style='font-size:20'>\u03b1</span><sub>");
        this.alphaFluCheck = new JCheckBoxMenuItem("<html><sub>\u0424|u</sub><span style='font-size:20'>\u03b1</span><sub>");
        this.alphaKluCheck = new JCheckBoxMenuItem("<html><sub>k(u)</sub><span style='font-size:20'>\u03b1</span><sub>");
        this.alphaUCheck.setSelected(preferences.getBoolean(this.alphaUCheck.getText(), true));
        this.alphauCheck.setSelected(preferences.getBoolean(this.alphauCheck.getText(), true));
        this.alphaCluCheck.setSelected(preferences.getBoolean(this.alphaCluCheck.getText(), true));
        this.alphaFluCheck.setSelected(preferences.getBoolean(this.alphaFluCheck.getText(), true));
        this.alphaKluCheck.setSelected(preferences.getBoolean(this.alphaKluCheck.getText(), true));
        menuChoice.add(this.alphaUCheck);
        menuChoice.add(this.alphauCheck);
        menuChoice.add(this.alphaFluCheck);
        menuChoice.add(this.alphaCluCheck);
        menuChoice.add(this.alphaKluCheck);
        this.alphaUCheck.addActionListener(this);
        this.alphauCheck.addActionListener(this);
        this.alphaCluCheck.addActionListener(this);
        this.alphaFluCheck.addActionListener(this);
        this.alphaKluCheck.addActionListener(this);
        this.mainMenu.add(menuChoice);
    }

    protected void initializeComponment() {
        super.initializeComponment();
        this.alphaU2015 = new KrippendorffUAlpha2015();
        this.alphaClu = new Alphaclu3();
        this.alphaFlu = new AlphafluNew2();
        this.alphalu = new AlphaluNew2();
        this.alphaKlu = new AlphakluNew();
        this.metrics = new HashMap();
        this.metrics.put(ALPHA_CLU, METRIC_NOMINAL);
        this.metrics.put(ALPHA_FLU, METRIC_NOMINAL);
        this.metrics.put(ALPHA_LU, METRIC_NOMINAL);
        this.metrics.put(ALPHA_KLU, METRIC_NOMINAL);
        this.metrics.put(ALL, METRIC_NOMINAL);
        this.alphaU2015Field = new JTextField(8);
        this.alphaUField = new JTextField(8);
        this.alphaCluField = new JTextField(8);
        this.alphaFluField = new JTextField(8);
        this.alphaLuField = new JTextField(8);
        this.alphaKluArea = new JTextArea();
        this.mainFrame.setLayout(new BoxLayout(this.mainFrame, 1));
        JTabbedPane measuresDetails = new JTabbedPane();
        Box settings = Box.createHorizontalBox();
        settings.setBorder(BorderFactory.createTitledBorder("Settings"));
        JLabel label = new JLabel("Metric =");
        settings.add(label);
        settings.add(this.getMetricSelector(ALL));
        this.getMetricSelector(ALL).setPreferredSize(new Dimension(150, 30));
        settings.add(Box.createHorizontalStrut(140));
        label = new JLabel("confidence =");
        settings.add(label);
        this.confidenceList = new JComboBox<String>(confidenceStrings);
        this.confidenceList.setSelectedIndex(2);
        settings.add(this.confidenceList);
        this.confidenceList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlphaUI.this.updateColumnName();
                AlphaUI.this.computeBootstrapsThreaded();
            }
        });
        settings.add(Box.createHorizontalStrut(140));
        label = new JLabel("<html><span style='font-size:20'>\u03b1</span><sub>min</sub> =</html> ");
        settings.add(label);
        this.alphaMinList = new JComboBox<String>(alphaMinStrings);
        settings.add(this.alphaMinList);
        this.alphaMinList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlphaUI.this.updateColumnName();
                AlphaUI.this.computeBootstrapsThreaded();
            }
        });
        Object[] columnNames = new String[]{"features measured", "alpha", "value", "", "", "matrices"};
        Object[][] content = new String[][]{{"All identified units", "", "", "", "", ""}, {"All segments", "", "", "", "", ""}, {"Irrelevant segments | units", "", "", "", "", ""}, {"Intersections of valued units", "", "", "", "", ""}, {"<html>Individual values in<br>intersections of valued units</html>", "", "", "", "", ""}};
        this.measures = new JTable(content, columnNames);
        this.updateColumnName();
        this.measures.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = AlphaUI.this.measures.getSelectedRow();
                int col = AlphaUI.this.measures.getSelectedColumn();
                System.out.println("row=" + row + " col=" + col);
                if (col != 5) {
                    return;
                }
                if (row == 3 && AlphaUI.this.alphaCluCheck.isSelected()) {
                    AlphaUI.this.showMatrices(AlphaUI.this.alphaClu, "cu-\u03b1");
                }
                if (row == 1 && AlphaUI.this.alphauCheck.isSelected()) {
                    AlphaUI.this.showMatrices(AlphaUI.this.alphalu, "u-\u03b1");
                }
                if (row == 2 && AlphaUI.this.alphaFluCheck.isSelected()) {
                    AlphaUI.this.showMatrices(AlphaUI.this.alphaFlu, "|u-\u03b1");
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.corpus = new CorpusObservableImpl(70);
        this.corpusPreview = new STCorpusViewPreview((ICorpusObservable)this.corpus, false);
        this.corpusPreviewController = new STCorpusViewController(this.corpusPreview, (ICorpusObservable)this.corpus);
        JPanel viewCorpus = new JPanel();
        viewCorpus.setBorder(BorderFactory.createTitledBorder("Annotations"));
        viewCorpus.setLayout(new BorderLayout());
        viewCorpus.add((Component)this.corpusPreview, "Center");
        viewCorpus.add((Component)this.corpusPreviewController, "First");
        this.mainFrame.add(settings);
        JScrollPane jsp = new JScrollPane(this.measures);
        this.mainFrame.add(jsp);
        jsp.setPreferredSize(new Dimension(810, 260));
        jsp.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 2), "Results"));
        this.measures.setRowHeight(30);
        this.measures.setRowHeight(4, 150);
        this.measures.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.measures.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.measures.getColumnModel().getColumn(2).setPreferredWidth(185);
        this.measures.getColumnModel().getColumn(3).setPreferredWidth(130);
        this.measures.getColumnModel().getColumn(4).setPreferredWidth(110);
        this.measures.getColumnModel().getColumn(5).setPreferredWidth(30);
        this.measures.getTableHeader().setPreferredSize(new Dimension(10, 35));
        this.measures.setSelectionBackground(Color.WHITE);
        this.measures.setSelectionForeground(Color.BLACK);
        this.measures.setShowHorizontalLines(false);
        this.measures.setShowVerticalLines(false);
        this.measures.setGridColor(Color.GRAY);
        this.mainFrame.add(viewCorpus);
    }

    private JComboBox getMetricSelector(String alphaName) {
        String[] items = new String[]{METRIC_NOMINAL, METRIC_INTERVAL, METRIC_ORDINAL, METRIC_RATIO, METRIC_NOMETRIC};
        final JComboBox<String> c = new JComboBox<String>(items);
        final String alpha = alphaName;
        c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlphaUI.this.metrics.put(alpha, c.getSelectedItem().toString());
                AlphaUI.this.measureAll();
            }
        });
        return c;
    }

    public void initializeConfiguration() {
        JckResourceBundle.addResourceFile((String)"kk");
    }

    public static void main(String[] args) {
        AcceptLicence.checkForLicenseAccepted();
        AlphaUI app = new AlphaUI();
        app.onCorpusImported((ICorpus)AlphaUI.getBookExample1SecondPrinting());
        app.measureAll();
    }

    protected void populateFile(JMenu menuFile) {
        this.actionImport = new ActionImportCorpus();
        this.actionImport.addCorpusImportListenner((ICorpusImportListener)this);
        menuFile.add(new JMenuItem((Action)this.actionImport));
    }

    public void onCorpusImported(ICorpus c) {
        System.out.println("Imported corpus");
        if (CorpusUtil.hasOverlap((ICorpus)c)) {
            System.out.println("OVERLAP DETECTED");
            JOptionPane optionPane = new JOptionPane("Loaded example contains overlap, it can't be computed !", 0);
            JDialog dialog = optionPane.createDialog("Error !");
            dialog.setAlwaysOnTop(true);
            dialog.setVisible(true);
        } else {
            this.corpus.loadCorpus(c);
            this.corpus.addCorpusListener((ICorpusListenner)this);
            this.binary = c.getUnitSet().getAnnotationSetByCategory().keySet().size() <= 1;
            this.corpusPreview.updateUI();
        }
    }

    public void measureAll() {
        if (this.corpus == null) {
            return;
        }
        ICorpus c = this.corpus.getCorpus();
        if (c.getUnitSet().getAnnotations().size() <= 0) {
            return;
        }
        try {
            String string;
            String m = this.metrics.get(ALL);
            if (m.equals(METRIC_RATIO)) {
                m = METRIC_INTERVAL;
            }
            if (m.equals(METRIC_ORDINAL)) {
                m = METRIC_NOMINAL;
            }
            this.alphaU2015 = new KrippendorffUAlpha2015(this.generateMetric(m));
            this.measures.setValueAt("<html><sub>U</sub><span style='font-size:20'>\u03b1</span><sub>" + (this.binary ? "" : m) + "</sub></html>", 0, 1);
            if (!this.alphaUCheck.isSelected()) {
                string = "disabled";
            } else {
                this.alphaUValue = this.alphaU2015.measure(c);
                string = this.format.format(this.alphaUValue) + (this.showCovering ? " (covering " + this.alphaU2015.getCovering() + "%)" : "");
            }
            this.measures.setValueAt(string, 0, 2);
        }
        catch (MeasureException ex) {
            this.measures.setValueAt("Error", 0, 2);
        }
        try {
            String string;
            this.alphaClu = new Alphaclu3(this.generateMetric(this.metrics.get(ALL)));
            this.measures.setValueAt("<html><sub>cu</sub><span style='font-size:20'>\u03b1</span><sub>" + this.metrics.get(ALL) + "</sub></html>", 3, 1);
            double cluValue = this.alphaClu.measure(c);
            if (!this.alphaCluCheck.isSelected()) {
                string = "disabled";
            } else if (this.binary) {
                string = "NA";
            } else {
                this.alphaCluValue = cluValue;
                string = this.format.format(this.alphaCluValue) + (this.showCovering && !Double.isNaN(cluValue) ? " (covering " + (int)Math.round(this.alphaClu.getCovering()) + "%)" : "");
            }
            this.measures.setValueAt(string, 3, 2);
            this.measures.setValueAt(this.binary ? "" : SHOW_MATRICES, 3, 5);
        }
        catch (MeasureException ex) {
            this.measures.setValueAt("Error", 3, 2);
        }
        try {
            this.alphaKlu = new AlphakluNew(this.generateMetric(this.metrics.get(ALL)));
            this.measures.setValueAt("<html><sub>(k)u</sub><span style='font-size:20'>\u03b1</span><sub>" + this.metrics.get(ALL) + "</sub></html>", 4, 1);
            String s = "NA";
            if (!this.alphaKluCheck.isSelected()) {
                s = "Disabled";
            } else if (!this.binary) {
                s = "<html>";
                double[] results = this.alphaKlu.allMeasures(c);
                for (int i = 0; i < this.alphaKlu.getCategories().size(); ++i) {
                    if (i != 0) {
                        s = s + "<br>";
                    }
                    s = s + "(" + this.alphaKlu.getCategories().get(i) + ")u-\u03b1=" + (Double.isNaN(results[i]) ? "NA" : this.format.format(results[i]) + (this.showCovering ? " (covering " + (int)Math.round(this.alphaKlu.getCovering(this.alphaKlu.getCategories().get(i))) + "%)" : ""));
                }
                s = s + "</html>";
            }
            this.measures.setValueAt(s, 4, 2);
            this.measures.setRowHeight(4, this.binary ? 50 : Math.max(50, this.measures.getFontMetrics(this.measures.getFont()).getHeight() * this.alphaKlu.getCategories().size()));
        }
        catch (MeasureException ex) {
            this.measures.setValueAt("Error", 4, 2);
            this.measures.setRowHeight(4, this.measures.getFontMetrics(this.measures.getFont()).getHeight());
        }
        try {
            String string;
            this.alphaFlu = new AlphafluNew2();
            this.measures.setValueAt("<html><sub>|u</sub><span style='font-size:20'>\u03b1</span><sub>binary</sub></html>", 2, 1);
            if (!this.alphaFluCheck.isSelected()) {
                string = "disabled";
            } else {
                this.alphaFluValue = this.alphaFlu.measure(c);
                string = this.format.format(this.alphaFluValue) + (this.showCovering ? " (covering 100%)" : "");
            }
            this.measures.setValueAt(string, 2, 2);
            this.measures.setValueAt(SHOW_MATRICES, 2, 5);
        }
        catch (MeasureException ex) {
            this.measures.setValueAt("Error", 2, 2);
        }
        try {
            String string;
            String m = this.metrics.get(ALL);
            if (!m.equals(METRIC_NOMETRIC)) {
                m = METRIC_NOMINAL;
            }
            this.alphalu = new AlphaluNew2(this.generateMetric(m));
            this.measures.setValueAt("<html><sub>u</sub><span style='font-size:20'>\u03b1</span><sub>" + (this.binary ? "binary" : m) + "</sub></html>", 1, 1);
            this.measures.setValueAt(SHOW_MATRICES, 1, 5);
            if (!this.alphauCheck.isSelected()) {
                string = "disabled";
            } else {
                this.alphaLuValue = this.alphalu.measure(c);
                string = this.format.format(this.alphaLuValue) + (this.showCovering ? " (covering 100%)" : "");
            }
            this.measures.setValueAt(string, 1, 2);
        }
        catch (MeasureException ex) {
            this.measures.setValueAt("Error", 1, 2);
        }
        this.computeBootstrapsThreaded();
    }

    private void computeBootstrapsThreaded() {
        this.currentThread = new Thread(){

            @Override
            public void run() {
                AlphaUI.this.computeBootstraps();
            }
        };
        this.currentThread.start();
    }

    private void clearBootstraps() {
        this.measures.setValueAt("", 3, 3);
        this.measures.setValueAt("", 3, 4);
        this.measures.setValueAt("", 2, 3);
        this.measures.setValueAt("", 2, 4);
        this.measures.setValueAt("", 1, 3);
        this.measures.setValueAt("", 1, 4);
        this.measures.setValueAt("", 0, 3);
        this.measures.setValueAt("", 0, 4);
    }

    private void computeBootstraps() {
        this.clearBootstraps();
        try {
            if (this.corpus.getCorpus().getUnitSet().getAnnotations().size() == 0) {
                return;
            }
            if (!Double.isNaN(this.alphaUValue) && this.alphaUCheck.isSelected()) {
                this.bootstrapU2015(this.alphaU2015, 0);
                Thread.sleep(20L);
            }
            if (!Double.isNaN(this.alphaLuValue) && this.alphauCheck.isSelected()) {
                this.bootstrap(this.alphalu, 1);
                Thread.sleep(20L);
            }
            if (!Double.isNaN(this.alphaFluValue) && this.alphaFluCheck.isSelected()) {
                this.bootstrap(this.alphaFlu, 2);
                Thread.sleep(20L);
            }
            if (!this.binary && !Double.isNaN(this.alphaCluValue) && this.alphaCluCheck.isSelected()) {
                this.bootstrap(this.alphaClu, 3);
                Thread.sleep(20L);
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger(AlphaUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void bootstrapU(Krippendorff2013Bis alpha, int row) {
        this.measures.setValueAt(COMPUTING, row, 3);
        this.measures.setValueAt(COMPUTING, row, 4);
        BootstrappingU b = new BootstrappingU(alpha, this.corpus.getCorpus());
        try {
            b.bootstrap();
            this.measures.setValueAt(this.format.format(b.getMinimumConfidenceInterval()) + " < \u03b1 < " + this.format.format(b.getMaximumConfidenceInterval()), row, 3);
            this.measures.setValueAt(this.format.format(b.getqPobability()), row, 4);
        }
        catch (MeasureException ex) {
            this.measures.setValueAt("bootstrap error", row, 3);
        }
    }

    private void bootstrapU2015(KrippendorffUAlpha2015 alpha, int row) {
        this.measures.setValueAt(COMPUTING, row, 3);
        this.measures.setValueAt(COMPUTING, row, 4);
        BootstrappingU2015 b = new BootstrappingU2015(alpha, this.corpus.getCorpus());
        try {
            b.bootstrap();
            this.measures.setValueAt(this.format.format(b.getMinimumConfidenceInterval()) + " < \u03b1 < " + this.format.format(b.getMaximumConfidenceInterval()), row, 3);
            this.measures.setValueAt(this.format.format(b.getqPobability()), row, 4);
        }
        catch (MeasureException ex) {
            System.out.println("error de bootstrap");
            ex.printStackTrace();
            this.measures.setValueAt("bootstrap error", row, 3);
        }
    }

    private void bootstrap(AlphaluBase alpha, int row) {
        this.measures.setValueAt(COMPUTING, row, 3);
        this.measures.setValueAt(COMPUTING, row, 4);
        double p = pValues[this.confidenceList.getSelectedIndex()];
        double alphaMin = alphaMinValues[this.alphaMinList.getSelectedIndex()];
        try {
            Bootstrapping11Avril2015 b = new Bootstrapping11Avril2015(alpha, this.corpus.getCorpus(), 100, p, alphaMin);
            b.bootstrap();
            this.measures.setValueAt(this.format.format(b.getMinimumConfidenceInterval()) + " < \u03b1 < " + this.format.format(b.getMaximumConfidenceInterval()), row, 3);
            this.measures.setValueAt(this.format.format(b.getqPobability()), row, 4);
        }
        catch (MeasureException ex) {
            ex.printStackTrace();
            this.measures.setValueAt("bootstrap error", row, 3);
        }
    }

    public static CorpusImpl getBookExample1SecondPrinting() {
        CorpusImpl c = new CorpusImpl(76, 1);
        UnitImpl u = new UnitImpl("coder 1", "1", 2, 17);
        c.getUnitSet().addAnnotation((IAnnotation)u);
        u = new UnitImpl("coder 1", "1", 22, 37);
        c.getUnitSet().addAnnotation((IAnnotation)u);
        u = new UnitImpl("coder 2", "1", 2, 17);
        c.getUnitSet().addAnnotation((IAnnotation)u);
        u = new UnitImpl("coder 1", "2", 58, 68);
        c.getUnitSet().addAnnotation((IAnnotation)u);
        u = new UnitImpl("coder 1", "4", 70, 75);
        c.getUnitSet().addAnnotation((IAnnotation)u);
        u = new UnitImpl("coder 2", "3", 32, 45);
        c.getUnitSet().addAnnotation((IAnnotation)u);
        u = new UnitImpl("coder 2", "1", 58, 63);
        c.getUnitSet().addAnnotation((IAnnotation)u);
        u = new UnitImpl("coder 2", "4", 70, 75);
        c.getUnitSet().addAnnotation((IAnnotation)u);
        return c;
    }

    public void onCorpusChanged(ICorpus corpus) {
        this.binary = corpus.getUnitSet().getAnnotationSetByCategory().keySet().size() <= 1;
        this.measureAll();
    }

    private void updateColumnName() {
        String s1 = "" + this.confidenceList.getSelectedItem() + " Confidence interval";
        this.measures.getColumnModel().getColumn(3).setHeaderValue(s1);
        String s2 = "<html>probability q of not<br>exceeding <span style='font-size:14'>\u03b1</span><sub>min</sub>=" + this.alphaMinList.getSelectedItem() + "</html>";
        this.measures.getColumnModel().getColumn(4).setHeaderValue(s2);
        this.measures.getTableHeader().resizeAndRepaint();
    }

    private void showMatrices(AlphaluBase measure, String label) {
        JFrame matricesFrame = new JFrame("Observed and Expected coincidences of " + label);
        Container cp = matricesFrame.getContentPane();
        cp.setLayout(new GridLayout(1, 3));
        matricesFrame.getContentPane().removeAll();
        JPanel panelExpected = this.getMatrixView(measure, measure.getExpectedMatrix());
        JPanel panelObserved = this.getMatrixView(measure, measure.getObservedMatrix());
        panelObserved.setBorder(new TitledBorder("Observed coincidences"));
        panelExpected.setBorder(new TitledBorder("Expected coincidences"));
        cp.add(panelObserved);
        cp.add(panelExpected);
        matricesFrame.pack();
        matricesFrame.setVisible(true);
    }

    private JPanel getMatrixView(AlphaluBase measure, MatrixNumeric<String> matrix) {
        JLabel cell;
        JPanel target = new JPanel();
        Font header = new Font("Arial", 1, 12);
        Font data = new Font("Arial", 0, 12);
        Font sum = new Font("Arial", 2, 10);
        target.setLayout(new GridLayout(matrix.getColumns().size() + 2, matrix.getLines().size() + 2, 10, 10));
        target.add(Box.createHorizontalStrut(10));
        for (String head : matrix.getColumns()) {
            cell = new JLabel(head);
            target.add(cell);
            cell.setFont(header);
        }
        target.add(Box.createHorizontalStrut(10));
        for (String row : matrix.getLines()) {
            cell = new JLabel(row);
            target.add(cell);
            cell.setFont(header);
            for (String col : matrix.getColumns()) {
                cell = new JLabel(this.matrixFormat.format((Double)matrix.getValue((Object)col, (Object)row)));
                target.add(cell);
                cell.setFont(data);
            }
            cell = new JLabel(this.matrixFormat.format(matrix.getTotalLine((Object)row)));
            target.add(cell);
            cell.setFont(sum);
        }
        target.add(Box.createHorizontalStrut(10));
        for (String col : measure.getCategories()) {
            cell = new JLabel(this.matrixFormat.format(matrix.getTotalLine((Object)col)));
            target.add(cell);
            cell.setFont(sum);
        }
        target.add(new JLabel(this.matrixFormat.format(matrix.getTotal())));
        return target;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JCheckBoxMenuItem i = (JCheckBoxMenuItem)e.getSource();
        preferences.putBoolean(i.getText(), i.isSelected());
    }
}

