/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.krippendorff;

import fr.unicaen.measure.krippendorff.Alpha2004Plugin;
import fr.unicaen.measure.krippendorff.Alpha2013Plugin;
import fr.unicaen.measure.krippendorff.AlphaCLU2013Plugin;
import fr.unicaen.measure.sufflingplugin.CorpusObservableImpl;
import fr.unicaen.measure.sufflingplugin.ICorpusObservable;
import fr.unicaen.measure.sufflingplugin.IMeasurePackPlugin;
import fr.unicaen.measure.sufflingplugin.IMeasurePlugin;
import fr.unicaen.measure.utils.CSVToAnnotationSetAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.Date;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class AlphaPack
implements IMeasurePackPlugin {
    private JPanel infos;
    public static final String[] measures = new String[]{"ALPHA2004", "ALPHAU2013", "ALPHACLU2013"};
    public static final String ALPHA_2004 = "ALPHA2004";
    public static final String ALPHAU_2013 = "ALPHAU2013";
    public static final String ALPHACLU_2013 = "ALPHACLU2013";

    public static void main(String[] args) {
        String measure;
        String csv;
        AlphaPack pack = new AlphaPack();
        if (args.length == 2) {
            csv = args[1];
            measure = args[0];
        } else {
            csv = AlphaPack.class.getResource("/single-valued.csv").getPath();
            measure = ALPHACLU_2013;
        }
        IMeasurePlugin plugin = pack.newMeasure(measure);
        JFrame test = new JFrame();
        CorpusObservableImpl corpus = new CorpusObservableImpl(14);
        try {
            corpus.loadAnnotations(new CSVToAnnotationSetAdapter(csv).convert());
        }
        catch (Exception ex) {
            System.err.println(ex);
            System.exit(1);
        }
        plugin.setCorpusObservable((ICorpusObservable)corpus);
        test.add(plugin.getResultDetailsView());
        test.setDefaultCloseOperation(3);
        test.pack();
        test.setVisible(true);
    }

    public AlphaPack() {
        JEditorPane content;
        try {
            content = new JEditorPane(this.getClass().getResource("/INFOS.html"));
            content.setContentType("text/html");
        }
        catch (IOException ex) {
            content = new JEditorPane();
            content.setText("No infos");
        }
        content.setEditable(false);
        this.infos = new JPanel();
        this.infos.setLayout(new BorderLayout());
        this.infos.add((Component)new JScrollPane(content), "Center");
    }

    public String getName() {
        return "Krippendorff's Alpha measures";
    }

    public String getVersion() {
        return "1.0";
    }

    public String getDescription() {
        return "Kit of Alpha measures : Alpha (2004), Alpha U and Alpha CLU implementation by St\u00e9phane Bouvry (GRYEC, University of Caen - France)";
    }

    public Date getDatePublish() {
        return new Date(2012, 12, 12);
    }

    public String[] listMeasure() {
        return measures;
    }

    public IMeasurePlugin newMeasure(String measureName) {
        if (measureName.equals(ALPHA_2004)) {
            return new Alpha2004Plugin();
        }
        if (measureName.equals(ALPHAU_2013)) {
            return new Alpha2013Plugin();
        }
        if (measureName.equals(ALPHACLU_2013)) {
            return new AlphaCLU2013Plugin();
        }
        throw new RuntimeException("Unknow measure call '" + measureName + "'");
    }

    public Component getInfoView() {
        return this.infos;
    }
}

