/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.krippendorff;

import fr.unicaen.measure.core.IMeasure;
import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.krippendorff.alpha2013.Krippendorff2013;
import fr.unicaen.measure.krippendorff.alphaClu2013.Alphaclu;
import fr.unicaen.measure.krippendorff.alphaClu2013.Alphaflu;
import fr.unicaen.measure.krippendorff.alphaClu2013.Alphalu;
import fr.unicaen.measure.krippendorff.alphaClu2013.AlphaluBase;
import fr.unicaen.measure.krippendorff.alphaClu2013.Bootstrapping;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013Interval;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013Interval01;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013Nominal;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013Ratio;
import fr.unicaen.measure.krippendorff.renderer.console.BootrstapRenderer;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.utils.CorpusUtil;
import fr.unicaen.measure.utils.KrippendorffFormatUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class AlphaCli {
    private static final String MEASURE_U = "u";
    private static final String MEASURE_UBIS = "uBis";
    private static final String MEASURE_CLU = "clu";
    private static final String MEASURE_FLU = "flu";
    private static final String MEASURE_LU = "lu";
    private static final String[] MEASURES = new String[]{"u", "clu"};
    private static final String FORMAT_KAPPA = "kappa";
    private static final String FORMAT_KAPPA_SEG = "kappa-seg";
    private static final String FORMAT_GLOZZ = "glozz";
    private static final String[] FORMATS = new String[]{"glozz", "kappa", "kappa-seg"};
    private static final String BOOTSTRAP = "bootstrap";
    private static final String FILES = "annotation-file";
    private static final String FORMAT = "annotation-format";
    private static final String HELP = "help";
    private static final String MEASURE = "measure";
    private static final String METRIC = "metric";
    private static final String VERBOSE = "verbose";

    public static void main(String[] args) {
        boolean verbose = false;
        BasicParser parser = new BasicParser();
        Options options = new Options();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)FILES);
        OptionBuilder.withDescription((String)"Given annotation file");
        OptionBuilder.withLongOpt((String)FILES);
        options.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)MEASURE);
        OptionBuilder.withDescription((String)"Specify used measure for computation using name : clu, lu, flu, u");
        OptionBuilder.withLongOpt((String)MEASURE);
        options.addOption(OptionBuilder.create((char)'m'));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)METRIC);
        OptionBuilder.withDescription((String)"Use specific metric : nominal(default), interval, interval-str, ratio");
        OptionBuilder.withLongOpt((String)METRIC);
        options.addOption(OptionBuilder.create((char)'M'));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)FORMAT);
        OptionBuilder.withDescription((String)"Specify annotation format : kappa-seg (yield 1 length annotations), kappa(yield annotations with various size), glozz");
        OptionBuilder.withLongOpt((String)FORMAT);
        options.addOption(OptionBuilder.create((char)'F'));
        options.addOption("h", HELP, false, "Display help");
        options.addOption("b", BOOTSTRAP, false, "Display boostrap");
        options.addOption("v", VERBOSE, false, "Verbose output");
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption(VERBOSE)) {
                verbose = true;
            }
            String measureCode = line.getOptionValue(MEASURE);
            String annotationFile = line.getOptionValue(FILES);
            try {
                IMeasure measure;
                ICorpus c;
                String format = FORMAT_GLOZZ;
                if (line.hasOption(FORMAT)) {
                    format = line.getOptionValue(FORMAT);
                }
                if (format.equals(FORMAT_GLOZZ)) {
                    c = CorpusUtil.loadFromRichterFile((File)new File(annotationFile));
                } else if (format.equals(FORMAT_KAPPA)) {
                    c = KrippendorffFormatUtils.loadFromFileFilledUnits((String)annotationFile, null);
                } else if (format.equals(FORMAT_KAPPA_SEG)) {
                    c = KrippendorffFormatUtils.loadFromFile((String)annotationFile, null, (boolean)false);
                } else {
                    throw new ParseException("Unknow annotation format '" + format + "'");
                }
                Metric2013 metric = new Metric2013Nominal();
                if (line.hasOption(METRIC)) {
                    String metricCode = line.getOptionValue(METRIC);
                    ArrayList<String> cat = new ArrayList<String>(c.getUnitSet().getAnnotationSetByCategory().keySet());
                    if (metricCode.equals("interval")) {
                        metric = new Metric2013Interval(cat);
                    } else if (metricCode.equals("interval-str")) {
                        metric = new Metric2013Interval01(cat);
                    } else if (metricCode.equals("ratio")) {
                        metric = new Metric2013Ratio(cat);
                    }
                }
                if (measureCode.equals(MEASURE_CLU)) {
                    measure = new Alphaclu(metric);
                } else if (measureCode.equals(MEASURE_FLU)) {
                    measure = new Alphaflu(metric);
                } else if (measureCode.equals(MEASURE_LU)) {
                    measure = new Alphalu(metric);
                } else if (measureCode.equals(MEASURE_U)) {
                    measure = new Krippendorff2013();
                } else {
                    throw new ParseException("Unknow measure '" + measureCode + "'");
                }
                double total = measure.measure(c);
                if (verbose) {
                    System.out.println(measure);
                    if (line.hasOption(BOOTSTRAP) && !measureCode.equals(MEASURE_U)) {
                        Bootstrapping boostrap = new Bootstrapping((AlphaluBase)measure, c);
                        System.out.println(BootrstapRenderer.render(boostrap));
                    }
                } else {
                    System.out.println(total);
                }
                return;
            }
            catch (FileNotFoundException ex) {
                throw new ParseException("Unknow file '" + annotationFile + "'");
            }
            catch (IOException ex) {
                Logger.getLogger(AlphaCli.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (MeasureException ex) {
                Logger.getLogger(AlphaCli.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        catch (ParseException ex) {
            System.err.println("Parcing error. Reason: " + ex.getMessage());
        }
        String header = "\nKrippendorff's Alpha calculator v 1.0 - University of Caen (France) - GREYC Laboratory. Specials tanks to the measure's author Klaus Krippendorff for this help and advice.\n";
        String footer = "\nPlease report issues at http://example.com/issues";
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("alpha", header, options, footer, true);
    }
}

