/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.krippendorff;

import com.jacksay.matrix.MatrixNumeric;
import fr.unicaen.measure.core.IMeasure;
import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.krippendorff.alphaClu2013.Alphaclu;
import fr.unicaen.measure.krippendorff.alphaClu2013.Bootstrapping;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013Interval;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013Interval01;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013Nominal;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.Metric2013Ratio;
import fr.unicaen.measure.krippendorff.alphaClu2013.metrics.MetricComboItem;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.sufflingplugin.MeasurePluginImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class AlphaCLU2013Plugin
extends MeasurePluginImpl {
    public static final String NAME = "Alpha C|U";
    public static final String METRIC_NOMINAL = "Nominal";
    public static final String METRIC_INTERVAL = "Interval";
    public static final String METRIC_INTERVAL_STANDARDIZED = "Interval standardized";
    public static final String METRIC_RATIO = "Ratio";
    public static final String DEFAULT_METRIC = "Nominal";
    public String selectedMetric = "Nominal";
    public static final String[] AVAILABLE_METRICS = new String[]{"Nominal", "Interval", "Interval standardized", "Ratio"};
    private Alphaclu measure;
    private Bootstrapping bootstrapping;
    private JTextField observed;
    private JTextField expected;
    private JTextField total;
    private JComboBox comboMetric;
    private JTabbedPane tabs = new JTabbedPane();
    private JPanel details;
    private JPanel observedMatrix;
    private JPanel expectedMatrix;
    private JPanel metric;
    private JPanel metricPreview;
    private JPanel bootstrap;
    public DecimalFormat agreementFormat = new DecimalFormat("0.00000");
    public DecimalFormat matrixFormat = new DecimalFormat("0.00");
    private MetricComboItem[] metricsLabel = new MetricComboItem[]{new MetricComboItem("Nominal"), new MetricComboItem("Interval"), new MetricComboItem("Interval standardized"), new MetricComboItem("Ratio")};

    public AlphaCLU2013Plugin() {
        super(NAME);
        this.measure = new Alphaclu();
        this.comboMetric = this.createComboMetric();
        this.tabs = new JTabbedPane();
        this.observedMatrix = new JPanel();
        this.expectedMatrix = new JPanel();
        this.details = new JPanel();
        this.metricPreview = new JPanel();
        this.bootstrap = new JPanel();
        this.bootstrap.setLayout(new GridLayout(1, 1));
        this.metric = this.getMetricsView();
        Font huge = new Font("Arial", 0, 24);
        this.total = new JTextField("TOTAL");
        this.total.setEditable(false);
        this.total.setFont(new Font("Arial", 1, 24));
        this.observed = new JTextField("Observed");
        this.observed.setEditable(false);
        this.observed.setFont(huge);
        this.expected = new JTextField("Expected");
        this.expected.setEditable(false);
        this.expected.setFont(huge);
        this.details.setLayout(new GridLayout(1, 1));
        JPanel leftSide = new JPanel();
        leftSide.setLayout(new BorderLayout());
        JPanel metricChooser = new JPanel();
        metricChooser.setLayout(new FlowLayout());
        metricChooser.add(new JLabel("Metric : "));
        metricChooser.add(this.comboMetric);
        leftSide.add((Component)metricChooser, "First");
        JPanel formula = new JPanel();
        leftSide.add((Component)formula, "Center");
        formula.setLayout(new FlowLayout());
        JLabel l1 = new JLabel("<html><sub>c|u</sub>&alpha; =</html>");
        l1.setFont(huge);
        formula.add(l1);
        JPanel op = new JPanel();
        op.setLayout(new GridLayout(2, 1));
        JLabel l = new JLabel("<html><sub>c|u</sub>D<sub>o</sub></html>");
        op.add(l);
        l.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, Color.BLACK));
        op.add(new JLabel("<html><sub>c|u</sub>D<sub>e</sub></html></html>"));
        formula.add(new JLabel("1-"));
        formula.add(op);
        formula.add(new JLabel("= 1 - "));
        op = new JPanel();
        op.setLayout(new GridLayout(2, 1));
        op.add(this.observed);
        this.observed.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, Color.BLACK));
        op.add(this.expected);
        formula.add(op);
        l = new JLabel(" = ");
        formula.add(l);
        l.setFont(huge);
        formula.add(this.total);
        JSplitPane pane = new JSplitPane(1);
        pane.add(leftSide);
        this.tabs.add("Bootstrap", this.bootstrap);
        this.tabs.add("Observed", this.observedMatrix);
        this.tabs.add("Expected", this.expectedMatrix);
        this.tabs.add("Metric", this.metric);
        pane.add(this.tabs);
        this.details.add(pane);
    }

    public Component getConfigurationView() {
        return null;
    }

    public Component getResultDetailsView() {
        return this.details;
    }

    public IMeasure getMeasure() {
        return this.measure;
    }

    public void onCorpusChanged(ICorpus corpus) {
        this.measure = new Alphaclu(this.getSelectedMetric());
        super.onCorpusChanged(corpus);
    }

    protected void onMeasureReCalculated() {
        System.out.println("Alpha2004Plugin.onMeasureReCalculated()");
        try {
            ICorpus corpus = this.getCorpusObservable().getCorpus();
            this.measure.measure(corpus);
            this.bootstrapping = new Bootstrapping(this.measure, corpus);
            this.bootstrapping.bootstrap();
            this.total.setText(this.agreementFormat.format(this.measure.getTotal()));
            this.observed.setText(this.agreementFormat.format(this.measure.getCluDo()));
            this.expected.setText(this.agreementFormat.format(this.measure.getCluDe()));
            this.drawObserved();
            this.drawExpected();
            this.drawMetrics();
            this.drawBootstrap();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.total.setText("error");
            this.observed.setText("");
            this.expected.setText("");
        }
    }

    private JPanel getMetricsView() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        return panel;
    }

    private JPanel getMatrixView(MatrixNumeric<String> matrix) {
        JPanel view = new JPanel();
        return this.getMatrixView(view, matrix);
    }

    private JPanel getMatrixView(JPanel target, MatrixNumeric<String> matrix) {
        JLabel cell;
        Font header = new Font("Arial", 1, 12);
        Font data = new Font("Arial", 0, 12);
        Font sum = new Font("Arial", 2, 10);
        target.setLayout(new GridLayout(matrix.getColumns().size() + 2, matrix.getLines().size() + 2, 10, 10));
        target.add(Box.createHorizontalStrut(10));
        for (String head : matrix.getColumns()) {
            cell = new JLabel(head);
            target.add(cell);
            cell.setFont(header);
        }
        target.add(Box.createHorizontalStrut(10));
        for (String row : matrix.getLines()) {
            cell = new JLabel(row);
            target.add(cell);
            cell.setFont(header);
            for (String col : matrix.getColumns()) {
                cell = new JLabel(this.matrixFormat.format(matrix.getValue((Object)col, (Object)row)));
                target.add(cell);
                cell.setFont(data);
            }
            cell = new JLabel(this.matrixFormat.format(matrix.getTotalLine((Object)row)));
            target.add(cell);
            cell.setFont(sum);
        }
        target.add(Box.createHorizontalStrut(10));
        for (String col : this.measure.getCategories()) {
            cell = new JLabel(this.matrixFormat.format(matrix.getTotalLine((Object)col)));
            target.add(cell);
            cell.setFont(sum);
        }
        target.add(new JLabel(this.matrixFormat.format(matrix.getTotal())));
        return target;
    }

    private void drawObserved() {
        this.observedMatrix.removeAll();
        if (this.getCorpusObservable().getCorpus() != null) {
            this.getMatrixView(this.observedMatrix, this.measure.getObservedCoincidencesMatrix());
        }
    }

    private void drawExpected() {
        this.expectedMatrix.removeAll();
        if (this.getCorpusObservable().getCorpus() != null) {
            this.getMatrixView(this.expectedMatrix, this.measure.getExpectedCoincidencesMatrix());
        }
    }

    private void drawMetrics() {
        this.metric.removeAll();
        Font header = new Font("Arial", 1, 12);
        Font data = new Font("Arial", 0, 10);
        if (this.getCorpusObservable().getCorpus() == null) {
            this.metric.add((Component)new JLabel("Waiting for corpus..."), "Center");
        } else {
            JLabel l;
            this.metric.setLayout(new GridLayout(this.measure.getCategories().size() + 1, this.measure.getCategories().size() + 1));
            this.metric.add(new JLabel(" "));
            for (String k : this.measure.getCategories()) {
                l = new JLabel(k);
                this.metric.add(l);
                l.setFont(header);
            }
            for (String c : this.measure.getCategories()) {
                l = new JLabel(c);
                this.metric.add(l);
                l.setFont(header);
                for (String k : this.measure.getCategories()) {
                    l = new JLabel(this.matrixFormat.format(this.measure.getMetric(c, k)));
                    this.metric.add(l);
                    l.setFont(data);
                }
            }
        }
    }

    private JComboBox createComboMetric() {
        JComboBox<String> combo = new JComboBox<String>();
        combo.setModel(new DefaultComboBoxModel<String>(AVAILABLE_METRICS));
        combo.setSelectedItem(this.selectedMetric);
        combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AlphaCLU2013Plugin.this.onChangeMetric();
            }
        });
        return combo;
    }

    private void onChangeMetric() {
        this.onCorpusChanged(this.getCorpusObservable().getCorpus());
    }

    private Metric2013 getSelectedMetric() {
        ArrayList<String> cat = new ArrayList<String>(this.getCorpusObservable().getCorpus().getUnitSet().getAnnotationSetByCategory().keySet());
        Collections.sort(cat);
        String selected = this.comboMetric.getSelectedItem().toString();
        if (METRIC_INTERVAL.equals(selected)) {
            return new Metric2013Interval(cat);
        }
        if (METRIC_INTERVAL_STANDARDIZED.equals(selected)) {
            return new Metric2013Interval01(cat);
        }
        if (METRIC_RATIO.equals(selected)) {
            return new Metric2013Ratio(cat);
        }
        return new Metric2013Nominal();
    }

    private void drawBootstrap() throws MeasureException {
        this.bootstrap.removeAll();
        this.bootstrapping.bootstrap();
        XYSeries alpha = new XYSeries((Comparable)((Object)"Alpha"));
        Map<Double, Double> bootstrapDatas = this.bootstrapping.getBootstrapDatas();
        for (Double alphaDt : bootstrapDatas.keySet()) {
            double a = alphaDt / 10000.0;
            alpha.add(a, (Number)(bootstrapDatas.get(alphaDt) / ((double)this.bootstrapping.getxIterations() / 100.0)));
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(alpha);
        JFreeChart chart = ChartFactory.createXYLineChart((String)"Confidence Interval", (String)"Alphas", (String)"Percent", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setAntiAlias(true);
        XYPlot plot = (XYPlot)chart.getPlot();
        XYLineAndShapeRenderer render = (XYLineAndShapeRenderer)plot.getRenderer();
        render.setBaseShapesFilled(true);
        render.setBaseShapesVisible(true);
        render.setUseFillPaint(true);
        render.setAutoPopulateSeriesFillPaint(true);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.bootstrap.add((Component)chartPanel);
    }
}

