/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.krippendorff;

import fr.unicaen.measure.core.IMeasure;
import fr.unicaen.measure.krippendorff.alpha2013.Krippendorff2013;
import fr.unicaen.measure.sufflingplugin.MeasurePluginImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Alpha2013Plugin
extends MeasurePluginImpl {
    public static final String NAME = "Alpha U";
    private Krippendorff2013 measure;
    private JPanel details = new JPanel();
    private JTextField observed;
    private JTextField expected;
    private JTextField total;
    public DecimalFormat agreementFormat = new DecimalFormat("0.00000");

    public Alpha2013Plugin() {
        super(NAME);
        this.measure = new Krippendorff2013();
        Font huge = new Font("Arial", 0, 24);
        this.total = new JTextField("TOTAL");
        this.total.setEditable(false);
        this.total.setFont(new Font("Arial", 1, 24));
        this.observed = new JTextField("Observed");
        this.observed.setEditable(false);
        this.observed.setFont(huge);
        this.expected = new JTextField("Expected");
        this.expected.setEditable(false);
        this.expected.setFont(huge);
        this.details.setLayout(new FlowLayout(1));
        JLabel l1 = new JLabel("<html><sub>u</sub>&alpha; = 1 - </html>");
        l1.setFont(huge);
        this.details.add(l1);
        JPanel op = new JPanel();
        op.setLayout(new GridLayout(2, 1));
        JLabel l = new JLabel("<html><sub>u</sub>D<sub>o</sub></html>");
        op.add(l);
        l.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, Color.BLACK));
        l = new JLabel("<html><sub>u</sub>D<sub>e</sub></html></html>");
        op.add(l);
        this.details.add(op);
        l = new JLabel("=");
        this.details.add(l);
        op = new JPanel();
        op.setLayout(new GridLayout(2, 1));
        op.add(this.observed);
        this.observed.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, Color.BLACK));
        op.add(this.expected);
        this.details.add(op);
        JLabel equal = new JLabel(" = ");
        equal.setFont(huge);
        this.details.add(equal);
        this.details.add(this.total);
    }

    public Component getConfigurationView() {
        return null;
    }

    public Component getResultDetailsView() {
        return this.details;
    }

    public IMeasure getMeasure() {
        return this.measure;
    }

    protected void onMeasureReCalculated() {
        System.out.println("Alpha2004Plugin.onMeasureReCalculated()");
        try {
            this.total.setText(this.agreementFormat.format(this.measure.measure(this.getCorpusObservable().getCorpus())));
            this.observed.setText(this.agreementFormat.format(this.measure.getObserved()));
            this.expected.setText(this.agreementFormat.format(this.measure.getExpected()));
        }
        catch (Exception ex) {
            this.total.setText("error");
            this.observed.setText("");
            this.expected.setText("");
        }
    }
}

