/*
 * Decompiled with CFR 0.152.
 */
package com.jacksay.sgarnish.views;

import com.jacksay.sgarnish.assets.JckIconProvider;
import com.jacksay.sgarnish.containers.JckApplicationFrame;
import com.jacksay.sgarnish.exceptions.UserFriendlyException;
import com.jacksay.sgarnish.i18n.JckResourceBundle;
import com.jacksay.sgarnish.parameters.JckUserParameters;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class JckViewAbout
extends JDialog {
    JPanel controlBar;
    JPanel container;
    JckApplicationFrame app;
    JTabbedPane tab;
    JCheckBox opener;

    public JckViewAbout(JckApplicationFrame owner) throws UserFriendlyException {
        super((Frame)owner, JckResourceBundle.get("about"));
        this.app = owner;
        this.tab = new JTabbedPane();
        this.initializeComponent();
    }

    private void initializeComponent() throws UserFriendlyException {
        this.setSize(new Dimension(620, 500));
        this.setMinimumSize(this.getSize());
        this.setModal(false);
        this.setLayout(new BorderLayout(10, 10));
        this.setLocationRelativeTo(this.app);
        this.setTitle(JckResourceBundle.get("app.name") + JckResourceBundle.get("app.version"));
        this.container = new JPanel(new GridLayout(2, 1));
        this.tab.add(JckResourceBundle.get("informations"), this.container);
        this.tab.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.container.setBackground(Color.white);
        this.container.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.container.setAlignmentX(0.5f);
        JLabel label = new JLabel("<html><table width=570><tr><td><h1>" + JckResourceBundle.get("app.name") + "</h1>" + "<p>" + JckResourceBundle.get("version") + ": " + JckResourceBundle.get("app.version") + "<br>" + JckResourceBundle.get("vendor") + ": " + JckResourceBundle.get("app.vendor") + "<br>" + JckResourceBundle.get("site") + ": " + JckResourceBundle.get("app.site") + "<br>" + JckResourceBundle.get("contact") + ": " + JckResourceBundle.get("app.contact") + "<br>" + "</p>" + "</td>" + "<td align=right>" + "<img src=\"" + this.getClass().getResource(JckResourceBundle.get("file.logo")) + "\" alt=\"LOGO\"/>" + "</td>" + "</tr><tr>" + "</table>" + "</html>");
        label.setFont(new Font("Arial", 0, 14));
        this.container.add(label);
        JTextPane description = new JTextPane();
        description.setContentType("text/html");
        description.setText("<html>" + JckResourceBundle.get("app.description") + "</html>");
        description.setBorder(BorderFactory.createTitledBorder("Description : "));
        description.setEditable(false);
        this.container.add(description);
        try {
            JEditorPane license = new JEditorPane(this.app.getClass().getResource(JckResourceBundle.get("file.license")));
            license.setEditable(false);
            this.tab.add(JckResourceBundle.get("license"), new JScrollPane(license));
        }
        catch (IOException ex) {
            throw new UserFriendlyException(ex.getLocalizedMessage(), ex);
        }
        StringBuilder contentCredits = new StringBuilder("<html>");
        try {
            String line = null;
            StringBuilder out = new StringBuilder();
            BufferedReader reader = new BufferedReader(new FileReader(this.app.getClass().getResource(JckResourceBundle.get("file.credits")).getFile()));
            while ((line = reader.readLine()) != null) {
                out.append(line);
            }
            contentCredits.append((CharSequence)out);
        }
        catch (Exception ex) {
            Logger.getLogger(JckViewAbout.class.getName()).log(Level.SEVERE, null, ex);
        }
        JEditorPane credits = new JEditorPane();
        credits.setContentType("text/html");
        credits.setText(contentCredits + "<h1>Toolkit</h1>\n" + "    <p>That software use several free tools : </p>\n" + "    <ul>\n" + "        <li><strong>Swing Garnish Library (by Jacksay)</strong> : A little framework which simplify developement of Swing desktop application. <a href=\"http://code.google.com/p/swing-garnish/\">http://code.google.com/p/swing-garnish/</a></li>\n" + "        <li><strong>Fatcow Icon Library (by Fatcow)</strong> : 3000 Free \"Farm-Fresh Web Icons\". <a href=\"http://www.fatcow.com/free-icons\">http://www.fatcow.com/free-icons</a></li>\n" + "    </ul></html>");
        credits.setFont(new Font("Arial", 0, 14));
        credits.setEditable(false);
        credits.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent he) {
                if (he.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    try {
                        if (Desktop.isDesktopSupported()) {
                            try {
                                Desktop.getDesktop().browse(he.getURL().toURI());
                            }
                            catch (IOException ex) {
                                Logger.getLogger(JckViewAbout.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                        System.out.println(he.getURL().toURI());
                    }
                    catch (URISyntaxException ex) {
                        Logger.getLogger(JckViewAbout.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
        this.tab.add(JckResourceBundle.get("credits"), new JScrollPane(credits));
        this.controlBar = new JPanel(new FlowLayout());
        this.controlBar.setAlignmentX(0.5f);
        JButton close = new JButton(JckResourceBundle.get("close"), JckIconProvider.getIcon("door_open"));
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JckViewAbout.this.dispose();
            }
        });
        this.opener = new JCheckBox(JckResourceBundle.get("message.opener"), JckUserParameters.getShowAboutOnOpen());
        this.opener.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JckUserParameters.setShowAboutOnOpen(JckViewAbout.this.opener.isSelected());
            }
        });
        this.controlBar.add(this.opener);
        this.controlBar.add(close);
        this.add((Component)this.tab, "Center");
        this.add((Component)this.controlBar, "Last");
    }
}

