/*
 * Decompiled with CFR 0.152.
 */
package com.jacksay.sgarnish.utils;

import com.jacksay.sgarnish.utils.JckFileUtilsException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JckFileUtils {
    public static void copy(File source, File destination) throws JckFileUtilsException {
        FileOutputStream out;
        FileInputStream in;
        try {
            in = new FileInputStream(source);
        }
        catch (FileNotFoundException ex) {
            throw new JckFileUtilsException("Source for copy '" + source.getAbsolutePath() + "' don't exist.", ex);
        }
        try {
            out = new FileOutputStream(destination, false);
        }
        catch (FileNotFoundException ex) {
            throw new JckFileUtilsException("Destination for copy '" + source.getAbsolutePath() + "' don't exist.", ex);
        }
        byte[] buf = new byte[1024];
        try {
            int len;
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (IOException ex) {
            throw new JckFileUtilsException("Write '" + source.getAbsolutePath() + "' to '" + destination.getAbsolutePath() + "' error.", ex);
        }
    }

    public static String getAppPath(Class clazz) {
        String packPath;
        int index;
        String path = "/" + clazz.getName().replace('.', '/') + ".class";
        String url = JckFileUtils.class.getResource(path).getPath();
        if (url.startsWith("file:")) {
            url = url.substring(5);
        }
        if ((index = url.lastIndexOf("!")) > -1) {
            url = url.substring(0, index);
        }
        index = url.lastIndexOf("/");
        url = url.substring(0, index);
        Package pack = clazz.getPackage();
        if (null != pack && url.endsWith(packPath = pack.getName().replace('.', '/'))) {
            url = url.substring(0, url.length() - packPath.length());
        }
        if (url.charAt(url.length() - 1) != '/') {
            url = url + '/';
        }
        return url;
    }
}

