/*
 * Decompiled with CFR 0.152.
 */
package com.jacksay.sgarnish.i18n;

import com.jacksay.sgarnish.parameters.JckUserParameters;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class JckResourceBundle {
    private List<ResourceBundle> files = new ArrayList<ResourceBundle>();
    private static JckResourceBundle instance;
    private String missingResourceFormat = "{0}`";

    private JckResourceBundle() {
        try {
            this.files.add(ResourceBundle.getBundle("jckapplication", JckUserParameters.getLocale()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static JckResourceBundle getInstance() {
        if (instance == null) {
            instance = new JckResourceBundle();
        }
        return instance;
    }

    public static void addResourceFile(String baseName) {
        System.out.println(baseName);
        JckResourceBundle.getInstance().files.add(ResourceBundle.getBundle(baseName, JckUserParameters.getLocale()));
    }

    public static void enabledMissingTag(boolean enabled) {
        JckResourceBundle.getInstance().missingResourceFormat = enabled ? "%[0]%" : "{0}";
    }

    public static String get(String name) {
        for (int i = JckResourceBundle.getInstance().files.size() - 1; i >= 0; --i) {
            try {
                return JckResourceBundle.getInstance().files.get(i).getString(name);
            }
            catch (MissingResourceException e) {
                continue;
            }
        }
        return MessageFormat.format(JckResourceBundle.getInstance().missingResourceFormat, name);
    }
}

