/*
 * Decompiled with CFR 0.152.
 */
package com.jacksay.sgarnish.components;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTextField;

public class JckTextInput
extends JTextField
implements FocusListener {
    public static final Font DEFAULT_FONT = new Font("Arial", 0, 12);
    public static final Color DEFAULT_COLOR = Color.BLACK;
    public Font fontPlaceHolder;
    public Color colorPlaceHolder;
    private String textPlaceHolder = "";
    private Icon icon;

    public JckTextInput(String text, String placeHolder) {
        this(text, placeHolder, null);
    }

    public JckTextInput(String text, String placeHolder, Icon icon) {
        super(text);
        this.textPlaceHolder = placeHolder;
        if (icon != null) {
            this.icon = icon;
            this.setBorder(BorderFactory.createCompoundBorder(this.getBorder(), BorderFactory.createEmptyBorder(0, 18, 0, 0)));
        }
        this.addFocusListener(this);
    }

    public void setIcon(Icon icon) {
        if (icon != this.icon) {
            this.icon = icon;
            this.repaint();
        }
    }

    public void setTextPlaceHolder(String textPlaceHolder) {
        if (textPlaceHolder != this.textPlaceHolder) {
            this.textPlaceHolder = textPlaceHolder;
            this.repaint();
        }
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.fontPlaceHolder = this.getFont().deriveFont(2, this.getFont().getSize() - 1);
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        this.colorPlaceHolder = new Color(fg.getRed(), fg.getGreen(), fg.getBlue(), 125);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int paddingX = 2;
        if (this.icon != null) {
            int y = (this.getHeight() - this.icon.getIconHeight()) / 2;
            this.icon.paintIcon(this, g, paddingX, y);
            paddingX += this.icon.getIconWidth();
        }
        if (this.getText().equals("") && !this.hasFocus()) {
            Graphics2D g2 = (Graphics2D)g;
            FontMetrics metric = g2.getFontMetrics(this.fontPlaceHolder);
            int x = paddingX;
            int y = metric.getHeight() + (this.getHeight() - metric.getHeight()) / 2 - 2;
            g2.setFont(this.fontPlaceHolder);
            g2.setColor(this.colorPlaceHolder);
            g2.drawString(this.textPlaceHolder, x, y);
        }
    }

    @Override
    public void focusGained(FocusEvent fe) {
        this.repaint(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public void focusLost(FocusEvent fe) {
        this.repaint(0, 0, this.getWidth(), this.getHeight());
    }
}

