/*
 * Decompiled with CFR 0.152.
 */
package com.jacksay.sgarnish.components;

import com.jacksay.sgarnish.assets.JckIconProvider;
import com.jacksay.sgarnish.components.JckTextInput;
import com.jacksay.sgarnish.events.IJckTabRendererListenner;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicButtonUI;

public class JckTabRenderer
extends JPanel
implements MouseListener,
FocusListener,
ChangeListener {
    private final JTabbedPane pane;
    private long lastPress = -1L;
    private JLabel label;
    private JckTextInput newLabel;
    private List<IJckTabRendererListenner> listenners = new ArrayList<IJckTabRendererListenner>();

    private JckTabRenderer(JTabbedPane pane, boolean editable, boolean closable) {
        super(new FlowLayout(0, 0, 0));
        this.pane = pane;
        this.setOpaque(false);
        pane.addChangeListener(this);
        this.label = new JLabel(){

            @Override
            public String getText() {
                return JckTabRenderer.this.getLabel();
            }
        };
        this.label.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 2));
        this.label.addMouseListener(this);
        this.add(this.label);
        this.newLabel = new JckTextInput(this.label.getText(), "Tip tab name...");
        this.newLabel.setVisible(false);
        this.newLabel.setMinimumSize(new Dimension(100, 16));
        this.newLabel.addFocusListener(this);
        this.newLabel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    JckTabRenderer.this.updateLabelFromInput();
                } else if (e.getKeyChar() == '\u001b') {
                    JckTabRenderer.this.cancelLabelFromInput();
                }
            }
        });
        this.add(this.newLabel);
        JButton buttonClose = new JButton(JckIconProvider.getIcon("cancel"));
        buttonClose.setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 0));
        buttonClose.setUI(new BasicButtonUI());
        buttonClose.setOpaque(false);
        buttonClose.setToolTipText("Close this tab.");
        buttonClose.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JckTabRenderer.this.removeTab();
            }
        });
        this.add(buttonClose);
    }

    public void removeTab() {
        int indexTab = this.pane.indexOfTabComponent(this);
        this.pane.remove(indexTab);
        this.fireRemove();
    }

    public static void createRendererForAll(JTabbedPane pane, boolean closable, boolean editable) {
        for (int i = 0; i < pane.getTabCount(); ++i) {
            JckTabRenderer.createRenderer(i, pane, closable, editable);
        }
    }

    public static void createRendererForAll(JTabbedPane pane, boolean closable) {
        JckTabRenderer.createRendererForAll(pane, closable, true);
    }

    public static void createRendererForAll(JTabbedPane pane) {
        JckTabRenderer.createRendererForAll(pane, true, true);
    }

    public static JckTabRenderer createRenderer(int index, JTabbedPane pane, boolean closable, boolean editable) {
        JckTabRenderer renderer = new JckTabRenderer(pane, closable, editable);
        pane.setTabComponentAt(index, renderer);
        return renderer;
    }

    public static JckTabRenderer createRenderer(int index, JTabbedPane pane, boolean closable) {
        return JckTabRenderer.createRenderer(index, pane, closable, true);
    }

    public static JckTabRenderer createRenderer(int index, JTabbedPane pane) {
        return JckTabRenderer.createRenderer(index, pane, true, true);
    }

    public static JckTabRenderer createRenderForLastAddedTab(JTabbedPane pane, boolean closable, boolean editable) {
        int lastIndex = pane.getTabCount() - 1;
        return JckTabRenderer.createRenderer(lastIndex, pane, closable, editable);
    }

    public static JckTabRenderer createRenderForLastAddedTab(JTabbedPane pane, boolean closable) {
        return JckTabRenderer.createRenderForLastAddedTab(pane, closable, true);
    }

    public static JckTabRenderer createRenderForLastAddedTab(JTabbedPane pane) {
        return JckTabRenderer.createRenderForLastAddedTab(pane, true, true);
    }

    public void addTabRendererListenner(IJckTabRendererListenner l) {
        this.listenners.add(l);
    }

    public void removeTabRendererListenner(IJckTabRendererListenner l) {
        this.listenners.remove(l);
    }

    public void removeTabRendererListenners() {
        for (IJckTabRendererListenner l : this.listenners) {
            this.removeTabRendererListenner(l);
        }
    }

    protected void fireLabelChange() {
        for (IJckTabRendererListenner l : this.listenners) {
            l.onTabRendererLabelChanged(this);
        }
    }

    protected void fireRemove() {
        for (IJckTabRendererListenner l : this.listenners) {
            l.onTabRendererRemoved(this);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        long now = new Date().getTime();
        if (now - this.lastPress < 500L) {
            this.label.setVisible(false);
            this.newLabel.setText(this.label.getText());
            this.newLabel.setVisible(true);
            this.newLabel.requestFocus();
            this.invalidate();
            this.validate();
        } else {
            this.dispatchEvent(e);
        }
        this.lastPress = now;
    }

    protected void dispatchEvent(MouseEvent e) {
        this.pane.dispatchEvent(SwingUtilities.convertMouseEvent(this.label, e, this.pane));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.dispatchEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dispatchEvent(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.dispatchEvent(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.dispatchEvent(e);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.newLabel) {
            this.updateLabelFromInput();
        } else if (e.getSource() == this) {
            System.out.println("test");
        }
    }

    public void setLabel(String text) {
        this.pane.setTitleAt(this.pane.indexOfTabComponent(this), text);
    }

    public String getLabel() {
        int i = this.pane.indexOfTabComponent(this);
        if (i != -1) {
            return this.pane.getTitleAt(i);
        }
        return null;
    }

    protected void updateLabelFromInput() {
        if (!this.newLabel.getText().equals(this.label.getText())) {
            this.setLabel(this.newLabel.getText());
            this.fireLabelChange();
        }
        this.label.setVisible(true);
        this.newLabel.setVisible(false);
        this.invalidate();
        this.validate();
    }

    protected void cancelLabelFromInput() {
        this.newLabel.setText(this.label.getText());
        this.label.setVisible(true);
        this.newLabel.setVisible(false);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.newLabel.isVisible()) {
            this.updateLabelFromInput();
        }
    }
}

