/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.gui.views;

import com.jacksay.sgarnish.assets.JckIconProvider;
import fr.unicaen.measure.model.IAnnotationSet;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.IUnit;
import fr.unicaen.measure.model.UnitImpl;
import fr.unicaen.measure.sufflingplugin.ICorpusListenner;
import fr.unicaen.measure.sufflingplugin.ICorpusObservable;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class STCorpusViewPreview
extends JPanel
implements ICorpusListenner,
MouseMotionListener,
MouseListener {
    protected ICorpusObservable corpus;
    private double widthScale;
    private double heightScale;
    private Map<String, List<DrawedUnit2D>> drawedUnit;
    private ArrayList<Rectangle2D> over;
    private ArrayList<Rectangle2D> selected;
    private static int categoryColorIndex = 0;
    private static Map<String, Color> colors = new HashMap<String, Color>();
    private boolean modelHasBeenEdited = false;
    private Map<Rectangle2D, String> annotatorRect;
    public Font fontAnnotatorLabel = new Font("Arial", 1, 12);
    public Color colorAnnotatorLabel = Color.GRAY;
    public List<String> annotators;
    private boolean editable = false;
    public List<String> categories;
    public Font fontUnitInfosLabel = new Font("Arial", 0, 10);
    public Font fontUnitCatLabel = new Font("Arial", 1, 14);
    public Color colorUnitInfosLabel = Color.BLACK;
    private static Color[] COLORS = new Color[]{Color.ORANGE, Color.RED, Color.DARK_GRAY, Color.BLUE, Color.MAGENTA};
    private static int nColor = 0;
    Color colorOver = new Color(0, 170, 68);
    BasicStroke lineStyleBase = new BasicStroke(1.0f);
    BasicStroke lineStyleOver = new BasicStroke(2.0f);
    DrawedUnit2D unitMove;
    private JPopupMenu unitMenu = new JPopupMenu("example");
    private Point mouseDragStart = null;
    public DrawedUnit2D active = null;
    public static final int DRAG_MOVE_ALL = 0;
    public static final int DRAG_MOVE_START = 1;
    public static final int DRAG_MOVE_END = 2;
    public static final int DRAG_DRAW = 3;
    public int dragMode = 0;

    public static Color generateColorYM() {
        Color c = COLORS[nColor++ % COLORS.length];
        System.out.println("ncolor=" + nColor);
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), 150);
    }

    public static Color generateColor() {
        Color c = Color.BLACK;
        int[] rgb = new int[3];
        ArrayList<Integer> availabled = new ArrayList<Integer>();
        availabled.add(42);
        availabled.add(84);
        availabled.add(136);
        availabled.add(170);
        availabled.add(212);
        for (int i = 0; i < 3; ++i) {
            int index = (int)(Math.random() * (double)availabled.size());
            rgb[i] = (Integer)availabled.get(index);
            availabled.remove(index);
        }
        return new Color(rgb[0], rgb[1], rgb[2], 150);
    }

    public static Color getCategoryColor(String category) {
        if (!colors.containsKey(category)) {
            colors.put(category, STCorpusViewPreview.generateColorYM());
        }
        return colors.get(category);
    }

    public STCorpusViewPreview(ICorpusObservable corpus) {
        this(corpus, true);
    }

    public STCorpusViewPreview(ICorpusObservable corpus, boolean editable) {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.over = new ArrayList();
        this.selected = new ArrayList();
        this.editable = editable;
        this.drawedUnit = new HashMap<String, List<DrawedUnit2D>>();
        this.corpus = corpus;
        this.widthScale = 4.0;
        this.heightScale = 25.0;
        corpus.addCorpusListener((ICorpusListenner)this);
        if (editable) {
            this.addMouseMotionListener(this);
        }
        this.addMouseListener(this);
    }

    public void onCorpusChanged(ICorpus corpus) {
        colors.clear();
        System.out.println("CORPUS CHANGE");
        this.widthScale = (double)this.getWidth() / (double)corpus.getTextSize();
        this.drawedUnit = new HashMap<String, List<DrawedUnit2D>>();
        if (corpus == null) {
            return;
        }
        if (this.drawedUnit == null) {
            this.drawedUnit = new HashMap<String, List<DrawedUnit2D>>();
        }
        if (this.annotatorRect == null) {
            this.annotatorRect = new HashMap<Rectangle2D, String>();
        }
        this.annotators = new ArrayList(corpus.getUnitSet().getAnnotationSetByAuthor().keySet());
        Collections.sort(this.annotators);
        this.categories = new ArrayList(corpus.getUnitSet().getAnnotationSetByCategory().keySet());
        int yAxis = 0;
        int lineNum = 0;
        int padding = 12;
        for (Map.Entry ann : corpus.getUnitSet().getAnnotationSetByAuthor().entrySet()) {
            List<Object> unitAnnotator;
            IAnnotationSet setByAnnotators = (IAnnotationSet)ann.getValue();
            String annotatorName = (String)ann.getKey();
            if (!this.drawedUnit.containsKey(annotatorName)) {
                unitAnnotator = new ArrayList();
                this.drawedUnit.put(annotatorName, unitAnnotator);
            } else {
                unitAnnotator = this.drawedUnit.get(annotatorName);
            }
            int baseY = lineNum * (padding + (int)(this.heightScale * 1.5));
            for (IUnit u : setByAnnotators.getAnnotations()) {
                DrawedUnit2D rect = null;
                for (DrawedUnit2D drawedUnit2D : unitAnnotator) {
                    if (drawedUnit2D.unit != u) continue;
                    rect = drawedUnit2D;
                }
                if (rect == null) {
                    rect = new DrawedUnit2D(0.0, 0.0, 0.0, 0.0, u);
                    unitAnnotator.add(rect);
                }
                rect.x = (double)u.getStartIndex() * this.widthScale;
            }
            ++yAxis;
            ++lineNum;
        }
        this.repaint();
    }

    public void changeScale(double x, double y) {
        this.widthScale = x;
        this.heightScale = y;
        this.repaint();
    }

    protected void drawAfter(Graphics2D g) {
    }

    @Override
    protected void paintComponent(Graphics gr) {
        super.paintComponent(gr);
        Graphics2D g = (Graphics2D)gr;
        if (this.corpus == null || this.corpus.getCorpus() == null) {
            return;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int yAxis = 0;
        int lineNum = 0;
        int padding = 12;
        g.setColor(Color.LIGHT_GRAY);
        Map annotationsByObservers = this.corpus.getCorpus().getUnitSet().getAnnotationSetByAuthor();
        ArrayList observers = new ArrayList(annotationsByObservers.keySet());
        Collections.sort(observers);
        for (String annotatorName : observers) {
            int baseY = lineNum * (padding + (int)(this.heightScale * 1.5));
            g.setColor(this.colorAnnotatorLabel);
            g.setFont(this.fontAnnotatorLabel);
            g.drawString(annotatorName, 0, padding + baseY);
            g.setColor(Color.lightGray);
            g.fillRect(0, padding + baseY, (int)((double)this.corpus.getCorpus().getTextSize() * this.widthScale), (int)(this.heightScale * 1.5));
            g.setColor(Color.GRAY);
            g.setStroke(new BasicStroke(1.0f));
            int yLine = baseY + padding + (int)(this.heightScale * 0.75);
            double i = 0.0;
            double j = 0.0;
            while (i < (double)this.getWidth()) {
                g.setColor(Color.white);
                int size = (int)(this.heightScale * 0.67);
                size = (int)((double)size * (j % 5.0 == 0.0 ? 1.0 : 0.5));
                g.drawLine((int)i, yLine - size, (int)i, yLine + size);
                i += this.widthScale;
                j += 1.0;
            }
            g.drawLine(0, yLine, this.getWidth(), yLine);
            g.setColor(Color.DARK_GRAY);
            for (DrawedUnit2D r : this.drawedUnit.get(annotatorName)) {
                r.draw(g, this.widthScale, this.heightScale, baseY + padding);
            }
            ++yAxis;
            ++lineNum;
        }
        this.drawAfter(g);
    }

    public DrawedUnit2D getDrawedUnitById(String id) {
        for (String s : this.drawedUnit.keySet()) {
            for (DrawedUnit2D u : this.drawedUnit.get(s)) {
                if (!u.unit.getId().equals(id)) continue;
                return u;
            }
        }
        return null;
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (this.mouseDragStart != null && this.unitMove != null) {
            this.unitMove.selected = true;
            int moveX = (int)((double)me.getX() - this.mouseDragStart.getX());
            if ((double)Math.abs(moveX) < this.widthScale) {
                return;
            }
            moveX = (int)((double)moveX / this.widthScale);
            System.out.println("D\u00e9placement: " + moveX);
            IUnit unitDt = this.unitMove.unit;
            int newStart = unitDt.getStartIndex();
            int newEnd = unitDt.getEndIndex();
            if (this.dragMode == 0) {
                newStart += moveX;
                newEnd += moveX;
            }
            if (this.dragMode == 1) {
                newStart += moveX;
            }
            if (this.dragMode == 2) {
                newEnd += moveX;
            }
            if (newStart < newEnd) {
                unitDt.setStartIndex(newStart);
                unitDt.setEndIndex(newEnd);
                this.modelHasBeenEdited = true;
            }
            this.mouseDragStart = new Point(me.getX(), me.getY());
            this.repaint();
        } else if (this.mouseDragStart != null && this.dragMode == 3) {
            int moveX = (int)((double)me.getX() - this.mouseDragStart.getX());
            if ((double)Math.abs(moveX) < this.widthScale) {
                return;
            }
            this.dragMode = (moveX = (int)((double)moveX / this.widthScale)) < 0 ? 1 : 2;
            System.out.println("Create : " + moveX);
            System.out.println((double)me.getY() / (12.0 + this.heightScale * 1.5));
            int annotatorIndex = (int)((double)me.getY() / (12.0 + this.heightScale * 1.5));
            String annotator = this.annotators.get(annotatorIndex);
            int start = (int)(this.mouseDragStart.getX() / this.widthScale);
            UnitImpl unit = new UnitImpl(annotator, this.categories.get(0), start, start + moveX);
            this.corpus.getCorpus().getUnitSet().getAnnotations().add(unit);
            DrawedUnit2D created = new DrawedUnit2D(0.0, 0.0, 0.0, 0.0, (IUnit)unit);
            this.drawedUnit.get(annotator).add(created);
            this.mouseDragStart = new Point(me.getX(), me.getY());
            this.unitMove = this.active = created;
            this.unitMove.over = true;
            this.modelHasBeenEdited = true;
            this.repaint();
        }
    }

    protected List<DrawedUnit2D> interactWith(MouseEvent me) {
        return this.interactWith(me.getX(), me.getY());
    }

    protected List<DrawedUnit2D> interactWith(int x, int y) {
        ArrayList<DrawedUnit2D> interact = new ArrayList<DrawedUnit2D>();
        for (List<DrawedUnit2D> byAnn : this.drawedUnit.values()) {
            for (DrawedUnit2D r : byAnn) {
                if (!r.contains(x, y)) continue;
                interact.add(r);
            }
        }
        return interact;
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        if (this.active != null) {
            if (this.active.contains(me.getX(), me.getY())) {
                this.unitInteraction(me, this.active);
                return;
            }
            this.active.over = false;
            this.active = null;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        for (List<DrawedUnit2D> byAnn : this.drawedUnit.values()) {
            for (DrawedUnit2D r : byAnn) {
                if (!r.contains(me.getX(), me.getY())) continue;
                this.active = r;
                this.active.over = true;
                this.unitInteraction(me, this.active);
                this.repaint();
                return;
            }
        }
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (me.getButton() == 1) {
            for (DrawedUnit2D d : this.interactWith(me.getX(), me.getY())) {
                System.out.println(d);
                d.setSelected(!d.isSelected());
            }
            this.repaint();
        }
    }

    private JPopupMenu buildUnitMenu(DrawedUnit2D unit2d) {
        JPopupMenu menu = new JPopupMenu();
        final DrawedUnit2D unit = unit2d;
        JMenuItem item = new JMenuItem(new AbstractAction("Supprimer", JckIconProvider.getIcon((String)"delete")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                System.out.println(unit.unit);
                STCorpusViewPreview.this.corpus.getCorpus().getUnitSet().getAnnotations().remove(unit.unit);
                ((List)STCorpusViewPreview.this.drawedUnit.get(unit.unit.getAuthor())).remove(unit);
                STCorpusViewPreview.this.corpus.fireCorpusChange();
                STCorpusViewPreview.this.repaint();
            }
        });
        menu.add(item);
        JMenu subMenu = new JMenu("Categories");
        menu.add(subMenu);
        subMenu.setIcon(JckIconProvider.getIcon((String)"three_tags"));
        for (String s : this.categories) {
            JRadioButtonMenuItem cat = new JRadioButtonMenuItem(s);
            subMenu.add(cat);
            cat.setBackground(STCorpusViewPreview.getCategoryColor(s));
            cat.setName(s);
            cat.setActionCommand(s);
            if (s.equals(unit.unit.getCategory())) {
                cat.setSelected(true);
            }
            cat.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    System.out.print("NAME = " + ae.getActionCommand());
                    unit.unit.setCategory(ae.getActionCommand());
                    STCorpusViewPreview.this.corpus.fireCorpusChange();
                    STCorpusViewPreview.this.repaint();
                }
            });
        }
        return menu;
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (me.isPopupTrigger()) {
            Iterator<DrawedUnit2D> i$ = this.interactWith(me).iterator();
            if (i$.hasNext()) {
                DrawedUnit2D du = i$.next();
                this.buildUnitMenu(du).show(this, me.getX(), me.getY());
                return;
            }
        } else if (this.active != null) {
            System.out.println("Moving");
            this.mouseDragStart = new Point(me.getX(), me.getY());
            this.unitMove = this.active;
            this.unitMove.over = true;
        } else {
            System.out.println("Create");
            this.dragMode = 3;
            this.mouseDragStart = new Point(me.getX(), me.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        System.out.println("Release");
        this.unitMove = null;
        this.active = null;
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.mouseDragStart = null;
        if (this.modelHasBeenEdited) {
            this.corpus.fireCorpusChange();
            this.modelHasBeenEdited = false;
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    private void unitInteraction(MouseEvent me, DrawedUnit2D active) {
        int mouseRelative = (int)((double)me.getX() - active.getX());
        double sensibility = 0.1;
        if ((double)mouseRelative < active.getWidth() * sensibility) {
            this.dragMode = 1;
            this.setCursor(Cursor.getPredefinedCursor(10));
        } else if ((double)mouseRelative > active.getWidth() * (1.0 - sensibility)) {
            this.dragMode = 2;
            this.setCursor(Cursor.getPredefinedCursor(11));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(13));
            this.dragMode = 0;
        }
    }

    public class DrawedUnit2D
    extends Rectangle2D.Double {
        private IUnit unit;
        private Color colorStandard;
        private boolean selected;
        private boolean over;

        public DrawedUnit2D(double x, double y, double w, double h, IUnit unit) {
            super(x, y, w, h);
            this.selected = false;
            this.over = false;
            this.unit = unit;
        }

        public void draw(Graphics2D g, double scaleWidth, double scaleHeight, int y) {
            BasicStroke lineStyle;
            Color line;
            Color fill;
            this.colorStandard = STCorpusViewPreview.getCategoryColor(this.unit.getCategory());
            this.setRect((double)this.unit.getStartIndex() * scaleWidth, (double)y + STCorpusViewPreview.this.heightScale * 0.25, (double)this.unit.getEndIndex() * scaleWidth - (double)this.unit.getStartIndex() * scaleWidth, STCorpusViewPreview.this.heightScale);
            if (this.over) {
                fill = this.colorStandard.brighter();
                line = this.selected ? this.colorStandard.darker().darker() : this.colorStandard.brighter();
                lineStyle = this.selected ? STCorpusViewPreview.this.lineStyleOver : STCorpusViewPreview.this.lineStyleBase;
            } else {
                fill = this.selected ? this.colorStandard.brighter() : this.colorStandard;
                line = this.selected ? this.colorStandard.darker().darker() : this.colorStandard.darker();
                lineStyle = this.selected ? STCorpusViewPreview.this.lineStyleOver : STCorpusViewPreview.this.lineStyleBase;
            }
            g.setColor(fill);
            g.fill(this);
            g.setColor(line);
            g.setStroke(lineStyle);
            g.draw(this);
            FontMetrics metrics = g.getFontMetrics(STCorpusViewPreview.this.fontUnitInfosLabel);
            FontMetrics metricsCat = g.getFontMetrics(STCorpusViewPreview.this.fontUnitCatLabel);
            int textHeight = metricsCat.getHeight();
            if (this.over || this.selected) {
                g.setColor(STCorpusViewPreview.this.colorUnitInfosLabel);
                g.setFont(STCorpusViewPreview.this.fontUnitInfosLabel);
                String x = "" + this.unit.getStartIndex();
                String ny = "" + this.unit.getEndIndex();
                int widthX = metrics.stringWidth(x);
                int widthY = metrics.stringWidth(ny);
                g.drawString(x, (int)this.getX() + 2, (int)this.getY() + textHeight);
                g.drawString(ny, (int)(this.getX() + this.getWidth() - (double)widthY) - 2, (int)this.getY() + textHeight);
            }
            g.setFont(STCorpusViewPreview.this.fontUnitCatLabel);
            g.setColor(Color.BLACK);
            String textCat = this.unit.getCategory();
            int widthCat = metricsCat.stringWidth(textCat);
            if (this.getWidth() >= (double)widthCat) {
                g.drawString(textCat, (int)(this.getX() + (this.getWidth() - (double)widthCat) / 2.0) + 1, (int)this.getY() + textHeight);
            }
        }

        public void setSelected(boolean b) {
            this.selected = b;
        }

        public boolean isSelected() {
            return this.selected;
        }
    }
}

