/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.gui.views;

import fr.unicaen.measure.gui.assets.AssetsProvider;
import fr.unicaen.measure.gui.views.STCorpusViewPreview;
import fr.unicaen.measure.sufflingplugin.ICorpusObservable;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class STCorpusViewController
extends JPanel
implements ChangeListener {
    private Box content;
    private STCorpusViewPreview corpusView;
    private ICorpusObservable corpusObservable;
    private JSlider scaleX;
    private JSlider scaleY;

    public STCorpusViewController(STCorpusViewPreview corpusView, ICorpusObservable corpusObservable) {
        this.setMaximumSize(new Dimension(-1, 24));
        this.corpusView = corpusView;
        this.corpusObservable = corpusObservable;
        this.content = Box.createHorizontalBox();
        this.scaleX = new JSlider(0);
        this.scaleY = new JSlider(0);
        this.scaleX.setPreferredSize(new Dimension(150, 16));
        this.scaleY.setPreferredSize(new Dimension(150, 16));
        this.scaleX.addChangeListener(this);
        this.scaleY.addChangeListener(this);
        this.add(this.content);
        this.initializeView();
    }

    private void initializeView() {
        this.content.add(Box.createGlue());
        JLabel l = new JLabel(AssetsProvider.getIcon("size_horizontal"), 0);
        this.content.add(l);
        l.setSize(16, 16);
        this.content.add(Box.createRigidArea(new Dimension(10, 1)));
        this.content.add(this.scaleX);
        this.content.add(new JLabel(AssetsProvider.getIcon("size_vertical"), 0));
        this.content.add(Box.createRigidArea(new Dimension(10, 1)));
        this.content.add(this.scaleY);
        this.content.add(Box.createGlue());
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        JSlider slider = ce.getSource() == this.scaleX ? this.scaleX : this.scaleY;
        this.corpusView.changeScale(0.1 + (double)this.scaleX.getValue() / 10.0, 4 + this.scaleY.getValue() / 2);
        System.out.println(slider.getValue());
    }
}

