/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.gui.plugins;

import com.jacksay.sgarnish.i18n.JckResourceBundle;
import fr.unicaen.measure.gui.MainUI;
import fr.unicaen.measure.gui.plugins.PluginInstallerException;
import fr.unicaen.measure.sufflingplugin.IMeasurePackPlugin;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class PluginInstaller {
    private File jar;
    private MainUI app;
    private static final Logger logger = LogManager.getLogManager().getLogger(PluginInstaller.class.getName());

    public PluginInstaller(File jar, MainUI app) {
        this.app = app;
        this.jar = jar;
    }

    public void install() throws PluginInstallerException {
        this.install(false);
    }

    public void install(boolean showParametersAfter) throws PluginInstallerException {
        IMeasurePackPlugin m;
        Manifest manifest;
        this.app.getStatus().info(MessageFormat.format("Installation of ''{0}''...", this.jar.toString()));
        try {
            JarFile asJar = new JarFile(this.jar);
            manifest = asJar.getManifest();
        }
        catch (IOException ex) {
            throw new PluginInstallerException(MessageFormat.format(JckResourceBundle.get((String)"exception.plugin_jar_io"), this.jar.getAbsolutePath()), ex);
        }
        String mainClass = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
        if (mainClass != null) {
            URLClassLoader cl;
            try {
                cl = new URLClassLoader(new URL[]{this.jar.getAbsoluteFile().toURL()}, this.getClass().getClassLoader());
            }
            catch (MalformedURLException ex) {
                throw new PluginInstallerException(MessageFormat.format(ex.getMessage(), this.jar.getAbsolutePath()), ex);
            }
            try {
                Class<?> pl = cl.loadClass(mainClass);
                m = (IMeasurePackPlugin)pl.newInstance();
            }
            catch (Exception ex) {
                throw new PluginInstallerException(MessageFormat.format(JckResourceBundle.get((String)"exception.plugin_invalid"), this.jar.getAbsolutePath()), ex);
            }
        }
        throw new PluginInstallerException(MessageFormat.format(JckResourceBundle.get((String)"exception.plugin_invalid"), this.jar.getAbsolutePath()), null);
        this.app.getStatus().info(MessageFormat.format(JckResourceBundle.get((String)"message.measure_loaded"), m.getName()));
        this.app.addMeasurePlugin(m, showParametersAfter);
    }
}

