/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.gui.actions;

import com.jacksay.sgarnish.assets.JckIconProvider;
import com.jacksay.sgarnish.components.JckFileChooserFactory;
import com.jacksay.sgarnish.i18n.JckResourceBundle;
import com.jacksay.sgarnish.utils.JckCustomFileFilter;
import fr.unicaen.measure.gui.MainUI;
import fr.unicaen.measure.gui.prefs.STPreferences;
import fr.unicaen.measure.model.IAnnotationSet;
import fr.unicaen.measure.model.IUnit;
import fr.unicaen.measure.utils.CSVToAnnotationSetAdapter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class ActionOpenAnnotationsDatas
extends AbstractAction {
    private MainUI app;

    public ActionOpenAnnotationsDatas(MainUI app) {
        super(JckResourceBundle.get((String)"action.openannotations"), JckIconProvider.getIcon((String)"folder"));
        this.app = app;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        File selectedPath;
        JFileChooser fc = JckFileChooserFactory.createJFileChooser((FileFilter)new JckCustomFileFilter("Annotations datas", new String[]{"csv", "txt"}), (File)new File(STPreferences.getPathAnnotations()));
        if (fc.showOpenDialog((Component)((Object)this.app)) == 1) {
            return;
        }
        File directory = selectedPath = fc.getSelectedFile();
        if (!selectedPath.isDirectory()) {
            directory = new File(selectedPath.getParent());
        }
        STPreferences.setPathAnnotations(directory);
        this.loadAnnotations(selectedPath);
    }

    public void loadAnnotations(File csv) {
        try {
            CSVToAnnotationSetAdapter adapter = new CSVToAnnotationSetAdapter(csv.getAbsolutePath());
            this.app.getAppModel().getCurrentEvaluationSimpleModel().loadAnnotationSet((IAnnotationSet<IUnit>)adapter.convert());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.app.getStatus().error(MessageFormat.format(JckResourceBundle.get((String)"message.error.FileNotFoundException"), csv.getAbsolutePath()));
        }
        catch (IOException e) {
            e.printStackTrace();
            this.app.getStatus().error(MessageFormat.format(JckResourceBundle.get((String)"message.error.IOException"), csv.getAbsolutePath()));
        }
    }
}

