/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.gui.actions;

import com.jacksay.sgarnish.assets.JckIconProvider;
import com.jacksay.sgarnish.components.JckFileChooserFactory;
import com.jacksay.sgarnish.i18n.JckResourceBundle;
import com.jacksay.sgarnish.utils.JckCustomFileFilter;
import com.jacksay.sgarnish.utils.JckFileUtils;
import com.jacksay.sgarnish.utils.JckFileUtilsException;
import fr.unicaen.measure.gui.MainUI;
import fr.unicaen.measure.gui.plugins.PluginInstaller;
import fr.unicaen.measure.gui.plugins.PluginInstallerException;
import fr.unicaen.measure.gui.prefs.STPreferences;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class ActionInstallMeasure
extends AbstractAction {
    private MainUI app;

    public ActionInstallMeasure(MainUI app) {
        super(JckResourceBundle.get((String)"action.install_measure"), JckIconProvider.getIcon((String)"brick"));
        this.app = app;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        File selectedPath;
        JFileChooser fc = JckFileChooserFactory.createJFileChooser((FileFilter)new JckCustomFileFilter(JckResourceBundle.get((String)"file.plugin.description"), "jar"), (File)new File(STPreferences.getPathPlugin()));
        int response = fc.showOpenDialog((Component)((Object)this.app));
        if (response == 1) {
            return;
        }
        File directory = selectedPath = fc.getSelectedFile();
        if (!selectedPath.isDirectory()) {
            directory = new File(selectedPath.getParent());
        }
        STPreferences.setPathPlugin(directory);
        try {
            new PluginInstaller(selectedPath, this.app).install(true);
            File copy = new File(this.app.getPluginDirectory().getAbsolutePath() + "/" + selectedPath.getName());
            try {
                JckFileUtils.copy((File)selectedPath, (File)copy);
            }
            catch (JckFileUtilsException ex) {
                this.app.getStatus().error("exception.copy_plugin");
            }
        }
        catch (PluginInstallerException ex) {
            this.app.getStatus().error(ex.getMessage());
        }
    }

    protected void loadJar(File jarPlugin) throws PluginInstallerException {
        new PluginInstaller(jarPlugin, this.app).install(true);
        File copy = new File(this.app.getPluginDirectory().getAbsolutePath() + "/" + jarPlugin.getName());
        try {
            JckFileUtils.copy((File)jarPlugin, (File)copy);
        }
        catch (JckFileUtilsException ex) {
            this.app.getStatus().error("exception.copy_plugin");
        }
    }
}

