/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.gui;

import com.jacksay.sgarnish.containers.JckApplicationFrame;
import com.jacksay.sgarnish.i18n.JckResourceBundle;
import com.jacksay.sgarnish.utils.JckCustomFileFilter;
import com.jacksay.sgarnish.utils.JckFileUtils;
import fr.unicaen.measure.gui.actions.ActionInstallMeasure;
import fr.unicaen.measure.gui.actions.ActionLoadFromText;
import fr.unicaen.measure.gui.actions.ActionOpenAnnotationsDatas;
import fr.unicaen.measure.gui.model.STApplicationModel;
import fr.unicaen.measure.gui.model.STEvaluationSimpleModel;
import fr.unicaen.measure.gui.plugins.PluginInstaller;
import fr.unicaen.measure.gui.plugins.PluginInstallerException;
import fr.unicaen.measure.gui.views.STCorpusView;
import fr.unicaen.measure.gui.views.STMeasureDetailsView;
import fr.unicaen.measure.gui.views.STMeasureView;
import fr.unicaen.measure.sufflingplugin.IMeasurePackPlugin;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileFilter;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.UIManager;

public class MainUI
extends JckApplicationFrame {
    public ActionOpenAnnotationsDatas openAnnotationsFile;
    Action actionInstallMeasure;
    JMenu menuMeasure;
    protected SortedMap<String, IMeasurePackPlugin> measures;
    public STEvaluationSimpleModel model;
    private File pluginDirectory;
    private STCorpusView viewCorpus;
    private STMeasureDetailsView viewDetails;
    private JSplitPane main;
    private JSplitPane topSide;
    private JPanel bottomSide;
    private STApplicationModel appModel = new STApplicationModel();

    public File getPluginDirectory() {
        return this.pluginDirectory;
    }

    public STApplicationModel getAppModel() {
        return this.appModel;
    }

    public SortedMap<String, IMeasurePackPlugin> getMeasures() {
        return this.measures;
    }

    public MainUI() throws HeadlessException {
        this.model = new STEvaluationSimpleModel();
        this.measures = new TreeMap<String, IMeasurePackPlugin>();
        this.main = new JSplitPane(0);
        this.main.setResizeWeight(0.5);
        this.bottomSide = new JPanel(new GridLayout(1, 1));
        this.viewDetails = new STMeasureDetailsView(this.appModel);
        this.bottomSide.add(this.viewDetails);
        this.topSide = new JSplitPane(1);
        this.topSide.setResizeWeight(0.5);
        this.main.add(this.topSide);
        this.main.add(this.bottomSide);
        this.viewCorpus = new STCorpusView(this.appModel, new ActionLoadFromText(this));
        this.topSide.add(this.viewCorpus);
        this.topSide.add(new STMeasureView(this.appModel));
        this.mainFrame.setLayout(new GridLayout(1, 1));
        this.mainFrame.add(this.main);
        this.main.setBackground(Color.WHITE);
        this.setBackground(Color.WHITE);
        this.checkPluginsPath();
        this.initializeToolbar();
    }

    public void addMeasurePlugin(IMeasurePackPlugin measurePlugin, boolean showParameters) {
        if (!this.measures.containsKey(measurePlugin.getName())) {
            this.measures.put(measurePlugin.getName(), measurePlugin);
            this.updateMeasures();
            this.viewParameters.content.setSelectedComponent(((IMeasurePackPlugin)this.measures.get(measurePlugin.getName())).getInfoView());
            this.appModel.addPlugin(measurePlugin);
            if (showParameters) {
                this.displayParameters();
            }
        }
    }

    public void hookAddMenu(JMenuBar menu) {
        this.menuMeasure = new JMenu(JckResourceBundle.get((String)"measures"));
        this.actionInstallMeasure = new ActionInstallMeasure(this);
        this.menuMeasure.add(this.actionInstallMeasure);
        menu.add(this.menuMeasure);
    }

    protected void updateMeasures() {
        for (IMeasurePackPlugin m : this.measures.values()) {
            this.viewParameters.content.add(m.getName(), m.getInfoView());
        }
    }

    public void initializeConfiguration() {
        JckResourceBundle.addResourceFile((String)"measureui");
        this.msgClosing = false;
    }

    protected void populateFile(JMenu menuFile) {
        this.openAnnotationsFile = new ActionOpenAnnotationsDatas(this);
        this.populateMenu(menuFile, this.openAnnotationsFile, 48);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            Logger.getLogger(MainUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        MainUI gui = new MainUI();
        gui.setVisible(true);
        gui.openAnnotationsFile.loadAnnotations(new File("/home/jacksay/SufflingProject/ParkinsonNoOverlap/corpus/all_0,500/all_0,50_6.txt"));
    }

    private void checkPluginsPath() {
        this.pluginDirectory = new File(JckFileUtils.getAppPath(MainUI.class) + "/plugins");
        if (!this.pluginDirectory.exists()) {
            if (!this.pluginDirectory.mkdir()) {
                // empty if block
            }
        } else {
            File[] installedPlugins;
            System.out.println("Check installed plugins...");
            for (File f : installedPlugins = this.pluginDirectory.listFiles((FileFilter)new JckCustomFileFilter("Jar", "jar"))) {
                try {
                    new PluginInstaller(f, this).install();
                }
                catch (PluginInstallerException ex) {
                    this.getStatus().error(ex.getMessage());
                }
            }
        }
    }

    private void initializeToolbar() {
    }
}

