/*
 * Decompiled with CFR 0.152.
 */
package com.jacksay.matrix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Matrix<E, F>
implements Iterable<F> {
    public static final boolean DIAGONAL = true;
    public static final boolean FREE = false;
    private static final boolean DEFAULT_DIAGONAL = true;
    private Map<E, Map<E, F>> datas = new TreeMap<E, Map<E, F>>();
    private boolean isDiagonal = true;
    private int numRow;
    private int numCol;

    public Matrix(Collection<E> rowsCols, F defaultValue) {
        this(rowsCols.toArray(), defaultValue);
    }

    public Matrix(E[] rowsCols) {
        this(rowsCols, null);
    }

    public Matrix(E[] rowsCols, F defaultValue) {
        this(rowsCols, true, defaultValue);
    }

    public Matrix(E[] rowsCols, boolean isDiagonal) {
        this(rowsCols, isDiagonal, null);
    }

    public Matrix(Collection<E> rowsCols, boolean isDiagonal, F defaultValue) {
        this(rowsCols.toArray(), isDiagonal, defaultValue);
    }

    public Matrix(E[] rowsCols, boolean isDiagonal, F defaultValue) {
        this(rowsCols, rowsCols, null, isDiagonal, defaultValue);
    }

    public Matrix(E[] rowsCols, F[][] values, boolean isDiagonal, F defaultValue) {
        this(rowsCols, rowsCols, values, isDiagonal, defaultValue);
    }

    public Matrix(E[] cols, E[] rows, F[][] values, boolean isDiagonal, F defaultValue) {
        this.isDiagonal = isDiagonal;
        this.numRow = rows.length;
        this.numCol = cols.length;
        for (int i = 0; i < rows.length; ++i) {
            TreeMap<E, F> line = new TreeMap<E, F>();
            for (int j = 0; j < cols.length; ++j) {
                F value = values == null ? defaultValue : values[i][j];
                line.put(cols[j], value);
            }
            this.datas.put(rows[i], line);
        }
    }

    public Set<E> getColumns() {
        return this.datas.keySet();
    }

    public Set<E> getLines() {
        return this.datas.values().iterator().next().keySet();
    }

    protected Map<E, F> getLine(E index) {
        return this.datas.get(index);
    }

    public void setValue(E x, E y, F value) {
        this.datas.get(x).put(y, value);
        if (this.isDiagonal) {
            this.datas.get(y).put(x, value);
        }
    }

    public F getValue(E x, E y) {
        return this.datas.get(x).get(y);
    }

    public List<F> getColumnValues(E col) {
        ArrayList<F> out = new ArrayList<F>();
        for (Map<E, F> map : this.datas.values()) {
            out.add(map.get(col));
        }
        return out;
    }

    public List<F> getLineValues(E line) {
        return new ArrayList<F>(this.datas.get(line).values());
    }

    public String toString() {
        String out = "";
        String head = "   \t";
        for (E col : this.datas.keySet()) {
            head = head + "| " + col + "\t";
            String line = col + "\t";
            for (E row : this.datas.get(col).keySet()) {
                line = line + "| " + this.getValue(col, row) + "\t";
            }
            out = out + line;
            out = out + "\n";
        }
        return head + "\n" + out;
    }

    @Override
    public Iterator<F> iterator() {
        return new MatrixIterator(this);
    }

    private class MatrixIterator
    implements Iterator<F> {
        private Iterator<Map<E, F>> colsIterator;
        private Iterator<F> rowsIterator;

        public MatrixIterator(Matrix<E, F> matrix2) {
            this.colsIterator = matrix2.datas.values().iterator();
            this.rowsIterator = this.colsIterator.next().values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.colsIterator.hasNext() || this.rowsIterator.hasNext();
        }

        @Override
        public F next() {
            if (!this.rowsIterator.hasNext()) {
                this.rowsIterator = this.colsIterator.next().values().iterator();
            }
            return this.rowsIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

