/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.utils;

import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.model.CorpusImpl;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.IUnit;
import fr.unicaen.measure.model.UnitImpl;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;

public class KrippendorffFormatUtils {
    public static final String MISSING_DATA_TMP_VALUE = "MISSING_DATA";

    public static ICorpus loadFromFile(String path) throws MeasureException {
        return KrippendorffFormatUtils.loadFromFile(path, "0", true);
    }

    public static ICorpus loadFromFile(String path, String missingValue, boolean fillMissing) throws MeasureException {
        String datas;
        CorpusImpl c = new CorpusImpl(0, 0);
        String previousObserver = "";
        int line = 0;
        int observers = 0;
        int caret = 0;
        UnitImpl unit = null;
        try {
            datas = FileUtils.readFileToString((File)new File(path));
        }
        catch (IOException ex) {
            throw new MeasureException("Can't open given file", ex);
        }
        StringTokenizer t = new StringTokenizer(datas);
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            String[] dt = token.split(",");
            if (dt.length < 2) {
                throw new MeasureException(MessageFormat.format("Error line {0} contains {1}, wainting for at least 2 data separate by commat for each line", line, token));
            }
            String observer = dt[0];
            String category = dt.length == 2 ? MISSING_DATA_TMP_VALUE : (dt[2].equals(missingValue) ? MISSING_DATA_TMP_VALUE : dt[2]);
            if (!previousObserver.equals(observer)) {
                caret = 0;
                ++observers;
            }
            if (category.equals(MISSING_DATA_TMP_VALUE) && fillMissing) {
                category = missingValue;
            }
            if (!category.equals(MISSING_DATA_TMP_VALUE)) {
                unit = new UnitImpl(observer, category, caret, caret + 1);
                c.addAnnotation(unit);
            }
            previousObserver = observer;
            ++caret;
            ++line;
        }
        c.setTextSize(line / observers);
        return c;
    }

    public static ICorpus loadFromFileFilledUnits(String path) throws MeasureException {
        return KrippendorffFormatUtils.loadFromFileFilledUnits(path, null);
    }

    public static ICorpus loadFromFileFilledUnits(String path, String missingValue) throws MeasureException {
        String datas;
        CorpusImpl c = new CorpusImpl(0, 0);
        String previousObserver = "";
        String previousCategory = "";
        int line = 0;
        int observers = 0;
        int caret = 1;
        int start = 0;
        IUnit unit = null;
        try {
            datas = FileUtils.readFileToString((File)new File(path));
        }
        catch (IOException ex) {
            throw new MeasureException("Can't open given file", ex);
        }
        StringTokenizer t = new StringTokenizer(datas);
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            String[] dt = token.split(",");
            if (dt.length < 2) {
                throw new MeasureException(MessageFormat.format("Error line {0} contains {1}, wainting for at least 3 data separate by commat for each line", line, token));
            }
            String category = dt.length == 2 ? MISSING_DATA_TMP_VALUE : (missingValue != null && dt[2].equals(missingValue) ? MISSING_DATA_TMP_VALUE : dt[2]);
            String observer = dt[0];
            if (!previousObserver.equals(observer) || !previousCategory.equals(category)) {
                start = caret;
                if (unit != null) {
                    unit.setEndIndex(caret);
                    c.addAnnotation(unit);
                }
                if (!observer.equals(previousObserver)) {
                    ++observers;
                    caret = 0;
                    start = 0;
                }
                if (category.equals(MISSING_DATA_TMP_VALUE)) {
                    unit = null;
                    start = caret;
                } else {
                    unit = new UnitImpl(observer, category, start, caret);
                }
            }
            previousCategory = category;
            previousObserver = observer;
            ++caret;
            ++line;
        }
        if (unit != null) {
            unit.setEndIndex(caret);
            c.addAnnotation(unit);
        }
        c.setTextSize(line / observers);
        return c;
    }
}

