/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.sufflingplugin;

import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.sufflingplugin.ICorpusListenner;
import fr.unicaen.measure.sufflingplugin.ICorpusObservable;
import fr.unicaen.measure.sufflingplugin.IMeasurePlugin;
import fr.unicaen.measure.sufflingplugin.IMeasurePluginListener;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextField;

public abstract class MeasurePluginImpl
implements IMeasurePlugin,
ICorpusListenner {
    private String name;
    private List<IMeasurePluginListener> listenners = new ArrayList<IMeasurePluginListener>();
    private JTextField result = new JTextField();
    private Box simpleView;
    private double lastResult;
    private ICorpusObservable corpusObservable;
    private static final Logger logger = Logger.getLogger(MeasurePluginImpl.class.getName());

    public MeasurePluginImpl(String name) {
        this.name = name;
        this.result.setText("no result");
    }

    @Override
    public Component getResultSimpleView() {
        if (this.simpleView == null) {
            this.simpleView = Box.createHorizontalBox();
            this.simpleView.add(new JLabel(this.getName() + " : "));
            this.simpleView.add(this.result);
        }
        return this.simpleView;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addMeasurePluginListener(IMeasurePluginListener listener) {
        this.listenners.add(listener);
    }

    @Override
    public void removeMeasurePluginListener(IMeasurePluginListener listener) {
        this.listenners.remove(listener);
    }

    protected void notifyChange() {
        for (IMeasurePluginListener l : this.listenners) {
            l.onResultChange(this);
        }
    }

    protected abstract void onMeasureReCalculated();

    @Override
    public void setCorpusObservable(ICorpusObservable corpusObservable) {
        this.corpusObservable = corpusObservable;
        corpusObservable.addCorpusListener(this);
        this.reCalculate();
    }

    @Override
    public ICorpusObservable getCorpusObservable() {
        return this.corpusObservable;
    }

    @Override
    public void onCorpusChanged(ICorpus corpus) {
        logger.fine("onCorpusChange()");
        this.reCalculate();
    }

    @Override
    public void reCalculate() {
        System.out.println("reCalculate !");
        if (this.getCorpusObservable().getCorpus() == null) {
            this.result.setText("Waiting for corpus");
        } else {
            try {
                System.out.println("Calculate measure...");
                this.lastResult = this.getMeasure().measure(this.getCorpusObservable().getCorpus());
                this.result.setText("" + this.lastResult);
            }
            catch (MeasureException ex) {
                System.out.println("Error : ");
                this.lastResult = Double.MIN_VALUE;
                this.result.setText("");
                System.out.println("ERROR !!! " + ex);
            }
        }
        if (this.getResultSimpleView() != null) {
            System.out.println("Update view SIMPLE");
        }
        if (this.getResultDetailsView() != null) {
            System.out.println("Update view DETAILS");
        }
        this.onMeasureReCalculated();
    }
}

