/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.sufflingplugin;

import fr.unicaen.measure.model.CorpusImpl;
import fr.unicaen.measure.model.IAnnotationSet;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.IUnit;
import fr.unicaen.measure.sufflingplugin.ICorpusListenner;
import fr.unicaen.measure.sufflingplugin.ICorpusObservable;
import java.util.ArrayList;
import java.util.List;

public class CorpusObservableImpl
implements ICorpusObservable {
    private List<ICorpusListenner> listenners = new ArrayList<ICorpusListenner>();
    private ICorpus corpus;

    public CorpusObservableImpl(int textSize) {
        this.corpus = new CorpusImpl(textSize, 0);
    }

    @Override
    public void addCorpusListener(ICorpusListenner listenner) {
        this.listenners.add(listenner);
    }

    @Override
    public void removeCorpusListener(ICorpusListenner listenner) {
        this.listenners.remove(listenner);
    }

    @Override
    public void fireCorpusChange() {
        for (ICorpusListenner l : this.listenners) {
            l.onCorpusChanged(this.getCorpus());
        }
    }

    public void loadAnnotations(IAnnotationSet<IUnit> annotations) {
        this.corpus.getUnitSet().addAnnotationsFrom(annotations);
        this.fireCorpusChange();
    }

    @Override
    public void loadCorpus(ICorpus corpus1) {
        this.corpus.getUnitSet().getAnnotations().clear();
        this.corpus.getUnitSet().addAnnotationsFrom(corpus1.getUnitSet());
        this.corpus.setCorpusType(corpus1.getCorpusType());
        this.corpus.setTextSize(corpus1.getTextSize());
        this.fireCorpusChange();
    }

    @Override
    public ICorpus getCorpus() {
        return this.corpus;
    }
}

