/*
 * Decompiled with CFR 0.152.
 */
package com.jacksay.sgarnish.views;

import com.jacksay.sgarnish.assets.JckIconProvider;
import com.jacksay.sgarnish.components.LanguageComboBoxRenderer;
import com.jacksay.sgarnish.containers.JckApplicationFrame;
import com.jacksay.sgarnish.i18n.JckResourceBundle;
import com.jacksay.sgarnish.parameters.JckUserParameters;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class JckViewParameters
extends JDialog {
    protected JPanel controlBar;
    protected JPanel container;
    protected JckApplicationFrame app;
    protected JComboBox languagesCombo;
    public JTabbedPane content;

    public JckViewParameters(JckApplicationFrame owner, String title) {
        super((Frame)owner, title);
        this.app = owner;
        this.initializeComponent();
    }

    public JckViewParameters(JckApplicationFrame owner) {
        this(owner, JckResourceBundle.get("parameters"));
    }

    private void initializeComponent() {
        this.setLayout(new BorderLayout());
        this.container = new JPanel(new BorderLayout());
        JPanel general = new JPanel();
        general.setLayout(new FlowLayout());
        Box languages = Box.createHorizontalBox();
        languages.add(new JLabel(JckResourceBundle.get("chose_language") + " : "));
        this.languagesCombo = new JComboBox(new DefaultComboBoxModel(new Locale[]{Locale.ENGLISH, Locale.FRENCH}){});
        this.languagesCombo.setSelectedItem(JckUserParameters.getLocale());
        this.languagesCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JckUserParameters.setLocale((Locale)JckViewParameters.this.languagesCombo.getSelectedItem());
                JckViewParameters.this.app.getStatus().warning(JckResourceBundle.get("message.reload_required"));
            }
        });
        this.languagesCombo.setRenderer(new LanguageComboBoxRenderer());
        languages.add(this.languagesCombo);
        general.add(languages);
        this.content = new JTabbedPane();
        this.content.add(JckResourceBundle.get("general"), general);
        this.app.hookAddParameters(this.content);
        this.content.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        this.add((Component)this.content, "Center");
        this.controlBar = new JPanel();
        JButton close = new JButton(JckResourceBundle.get("close"), JckIconProvider.getIcon("door_open"));
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JckViewParameters.this.dispose();
            }
        });
        this.controlBar.add(close);
        this.add((Component)this.controlBar, "Last");
        this.setModal(true);
        this.setLocationRelativeTo(this.getOwner());
        this.setSize(new Dimension(750, 500));
        this.setMaximumSize(this.getSize());
        this.setIconImage(JckIconProvider.getImage("cog"));
    }
}

