/*
 * Decompiled with CFR 0.152.
 */
package com.jacksay.sgarnish.views;

import com.jacksay.sgarnish.assets.JckIconProvider;
import com.jacksay.sgarnish.containers.JckApplicationFrame;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JckStatusApplication
extends JPanel {
    private JckApplicationFrame app;
    private Box box;
    private JLabel status = new JLabel(JckIconProvider.getIcon("information"));
    private Icon iconWarning;
    private Icon iconError;
    private Icon iconInfo;

    public JckStatusApplication(JckApplicationFrame app) {
        this.app = app;
        this.iconWarning = JckIconProvider.getIcon("caution_high_voltage");
        this.iconError = JckIconProvider.getIcon("exclamation");
        this.iconInfo = JckIconProvider.getIcon("information");
        this.initializeComponent();
    }

    public void addError(Exception ex) {
        System.err.println(ex.getCause());
        this.error(ex.getMessage());
    }

    private void initializeComponent() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setBackground(Color.WHITE);
        this.box = Box.createHorizontalBox();
        this.box.add(new Box.Filler(new Dimension(10, 10), new Dimension(500, 10), new Dimension(Integer.MAX_VALUE, 10)));
        this.box.add(this.status);
        this.box.add(Box.createHorizontalGlue());
        this.add(this.box);
        this.status.setFont(new Font("Arial", 0, 10));
        this.info(this.app.getTitle());
    }

    protected void changeStatus(String message, Icon icon) {
        this.status.setIcon(icon);
        this.status.setText(message);
    }

    public void info(String message) {
        this.changeStatus(message, this.iconInfo);
    }

    public void warning(String message) {
        this.changeStatus(message, this.iconWarning);
    }

    public void error(String message) {
        this.changeStatus(message, this.iconError);
    }
}

