/*
 * Decompiled with CFR 0.152.
 */
package com.jacksay.sgarnish.views;

import com.jacksay.sgarnish.views.JckViewAbout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class JckHtmlPanel
extends JPanel {
    private URL htmlPath;

    public JckHtmlPanel(URL htmlFilePath) {
        this.setLayout(new BorderLayout());
        this.htmlPath = htmlFilePath;
        this.initComponent();
    }

    private void initComponent() {
        JEditorPane credits;
        try {
            credits = new JEditorPane(this.htmlPath);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            credits = new JEditorPane();
            credits.setText("Bad path");
        }
        credits.setContentType("text/html");
        credits.setFont(new Font("Arial", 0, 14));
        credits.setEditable(false);
        credits.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent he) {
                if (he.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    try {
                        if (Desktop.isDesktopSupported()) {
                            try {
                                Desktop.getDesktop().browse(he.getURL().toURI());
                            }
                            catch (IOException ex) {
                                Logger.getLogger(JckViewAbout.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                        System.out.println(he.getURL().toURI());
                    }
                    catch (URISyntaxException ex) {
                        Logger.getLogger(JckViewAbout.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
        this.add((Component)new JScrollPane(credits), "Center");
    }
}

