/*
 * Decompiled with CFR 0.152.
 */
package com.jacksay.sgarnish.containers;

import com.jacksay.sgarnish.assets.JckIconProvider;
import com.jacksay.sgarnish.exceptions.UserFriendlyException;
import com.jacksay.sgarnish.i18n.JckResourceBundle;
import com.jacksay.sgarnish.parameters.JckUserParameters;
import com.jacksay.sgarnish.views.JckStatusApplication;
import com.jacksay.sgarnish.views.JckViewAbout;
import com.jacksay.sgarnish.views.JckViewParameters;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

public abstract class JckApplicationFrame
extends JFrame
implements Observer {
    public Dimension defaultSize = new Dimension(800, 600);
    public boolean msgClosing = true;
    public Action quitAction;
    public Action parametersAction;
    public Action aboutAction;
    protected SortedMap<String, JMenu> menus = new TreeMap<String, JMenu>();
    public JMenu menuFile;
    public JMenu menuEdit;
    public JMenu menuAbout;
    protected JMenuBar mainMenu;
    protected JckViewParameters viewParameters;
    protected JckViewAbout viewAbout;
    protected JPanel mainFrame;
    protected JckStatusApplication statusBar;
    private List<Locale> locales = new ArrayList<Locale>();
    protected boolean menuEditOn = false;

    public JckApplicationFrame() throws HeadlessException {
        this("");
    }

    public List<Locale> getLocales() {
        return this.locales;
    }

    public JckApplicationFrame(String title) throws HeadlessException {
        try {
            JckUserParameters.initialize(this.getClass());
            JckUserParameters.getInstance().addObserver(this);
            this.locales.add(Locale.ENGLISH);
            this.locales.add(Locale.FRANCE);
            this.initializeConfiguration();
            this.initializeResources();
            this.initializeActions();
            this.initializeComponment();
            this.initializeEvent();
            this.initializeMenu();
            this.setTitle(JckResourceBundle.get("app.name") + " - version " + JckResourceBundle.get("app.version"));
            this.onOpen();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initializeMenu() {
        this.setJMenuBar(this.getCustomMenuBar());
    }

    protected JMenu getMenu(String menuTag) {
        if (!this.menus.containsKey(menuTag)) {
            this.menus.put(menuTag, new JMenu(JckResourceBundle.get(menuTag)));
        }
        return (JMenu)this.menus.get(menuTag);
    }

    protected void populateMenu(JMenu menu, Action action, int key) {
        JMenuItem item = new JMenuItem(action);
        menu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(key, 2));
    }

    protected JMenuBar getCustomMenuBar() {
        this.mainMenu = new JMenuBar();
        this.menuFile = new JMenu(JckResourceBundle.get("file"));
        this.populateFile(this.menuFile);
        JMenuItem item = new JMenuItem(this.quitAction);
        this.menuFile.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.mainMenu.add(this.menuFile);
        if (this.menuEditOn) {
            this.menuEdit = new JMenu(JckResourceBundle.get("edit"));
            this.populateEdit(this.menuEdit);
            this.menuEdit.add(this.parametersAction);
            this.mainMenu.add(this.menuEdit);
        }
        this.hookAddMenu(this.mainMenu);
        this.menuAbout = new JMenu(JckResourceBundle.get("about"));
        item = new JMenuItem(this.aboutAction);
        item.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.menuAbout.add(item);
        this.mainMenu.add(this.menuAbout);
        return this.mainMenu;
    }

    public JckStatusApplication getStatus() {
        return this.statusBar;
    }

    private void initializeResources() {
    }

    protected void initializeComponment() {
        this.setIconImage(JckIconProvider.getImage("wrench"));
        this.setSize(this.defaultSize);
        this.setLayout(new BorderLayout());
        this.mainFrame = new JPanel();
        this.statusBar = new JckStatusApplication(this);
        this.add((Component)this.mainFrame, "Center");
        this.add((Component)this.statusBar, "Last");
        this.viewParameters = new JckViewParameters(this);
    }

    protected Component getMainFrame() {
        return this.mainFrame;
    }

    private void initializeEvent() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JckApplicationFrame.this.onClose(e);
            }
        });
    }

    private void initializeActions() {
        this.quitAction = new AbstractAction(JckResourceBundle.get("quit"), JckIconProvider.getIcon("cancel")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JckApplicationFrame.this.onClose(null);
            }
        };
        this.parametersAction = new AbstractAction(JckResourceBundle.get("parameters"), JckIconProvider.getIcon("cog")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JckApplicationFrame.this.displayParameters();
            }
        };
        this.aboutAction = new AbstractAction(JckResourceBundle.get("about"), JckIconProvider.getIcon("information")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    JckApplicationFrame.this.displayAbout();
                }
                catch (UserFriendlyException ex) {
                    JckApplicationFrame.this.getStatus().addError(ex);
                }
            }
        };
    }

    protected void displayParameters() {
        this.viewParameters.setLocationRelativeTo(this);
        this.viewParameters.setVisible(true);
    }

    protected void displayAbout() throws UserFriendlyException {
        if (this.viewAbout == null) {
            this.viewAbout = new JckViewAbout(this);
        }
        this.viewAbout.setVisible(true);
        this.viewAbout.setLocationRelativeTo(this);
    }

    protected void displayHelp() {
    }

    protected void onClose(WindowEvent e) {
        int response = 0;
        if (this.requireConfirmationOnClosing()) {
            response = JOptionPane.showConfirmDialog(this, JckResourceBundle.get("message.confirmclose"), JckResourceBundle.get("quit"), 0);
        }
        if (response == 0) {
            System.exit(0);
        }
    }

    protected void onOpen() throws UserFriendlyException {
        this.setVisible(true);
        this.setLocationRelativeTo(null);
        if (JckUserParameters.getShowAboutOnOpen()) {
            this.displayAbout();
        }
    }

    public boolean requireConfirmationOnClosing() {
        return this.msgClosing;
    }

    public abstract void initializeConfiguration();

    @Override
    public void update(Observable o, Object o1) {
        if (o == JckUserParameters.getInstance() && o1.equals("l18n")) {
            System.out.println("totaly reload");
            this.invalidate();
        }
    }

    protected void populateFile(JMenu menuFile) {
    }

    protected void populateEdit(JMenu menuFile) {
    }

    public void hookAddParameters(JTabbedPane pane) {
    }

    public void hookAddMenu(JMenuBar menu) {
    }
}

