/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz.strategy.dissimilarity;

import fr.unicaen.measure.glozz.strategy.dissimilarity.DissimilarityComputerImpl;
import fr.unicaen.measure.model.IUnit;

public class DissimilarityComputerPositionalSporadic
extends DissimilarityComputerImpl {
    public DissimilarityComputerPositionalSporadic(double emptyDelta) {
        super(emptyDelta);
    }

    public DissimilarityComputerPositionalSporadic() {
        this(1.0);
    }

    @Override
    protected double measureImpl(IUnit unitU, IUnit unitV) {
        double numerator = Math.abs(unitU.getStartIndex() - unitV.getStartIndex()) + Math.abs(unitU.getEndIndex() - unitV.getEndIndex());
        double denominator = unitU.getEndIndex() - unitU.getStartIndex() + (unitV.getEndIndex() - unitV.getStartIndex());
        if (denominator == 0.0) {
            denominator = 1.0;
        }
        return Math.pow(numerator / denominator, 2.0) * this.getEmptyDelta() * 3.01;
    }

    public String toString() {
        return "DissimilarityComputerPositionalSporadic";
    }
}

