/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz.strategy.dissimilarity;

import com.jacksay.matrix.MatrixNumeric;
import fr.unicaen.measure.glozz.strategy.dissimilarity.AbstractDissimilarityComputerCategorial;
import java.util.HashMap;
import java.util.Map;

public class DissimilarityComputerCategorialCorpusDriven
extends AbstractDissimilarityComputerCategorial {
    private MatrixNumeric<String> contingency;
    private Map<String, Double> cache = new HashMap<String, Double>();

    public void setContingency(MatrixNumeric<String> contingency) {
        this.contingency = contingency;
    }

    protected double getCellUnidirectionnalValue(String a, String b) {
        if (this.contingency == null) {
            throw new RuntimeException("La matrice de contingence est null !!!");
        }
        if (a.equals(b)) {
            return (Double)this.contingency.getValue((Object)a, (Object)b);
        }
        return (Double)this.contingency.getValue((Object)a, (Object)b) + (Double)this.contingency.getValue((Object)b, (Object)a);
    }

    protected double countEmergenceOf(String cat) {
        return this.contingency.getTotalColunm((Object)cat) + this.contingency.getTotalLine((Object)cat) - (Double)this.contingency.getValue((Object)cat, (Object)cat);
    }

    protected double countEmergenceOf(String catA, String catB) {
        if (catA.equals(catB)) {
            return this.countEmergenceOf(catB);
        }
        return this.countEmergenceOf(catA) + this.countEmergenceOf(catB) - this.getCellUnidirectionnalValue(catA, catB);
    }

    private double getScore(String catU, String catV) {
        double score;
        if (catU.equals(catV)) {
            return 0.0;
        }
        if (this.cache.containsKey(catV + catU)) {
            score = this.cache.get(catV + catU);
        } else if (this.cache.containsKey(catU + catV)) {
            score = this.cache.get(catU + catV);
        } else {
            double numerator = this.getCellUnidirectionnalValue(catU, catV);
            double denominator = this.countEmergenceOf(catU, catV);
            score = 1.0 - numerator / denominator;
            this.cache.put(catV + catU, score);
        }
        return score;
    }

    @Override
    protected double distCat(String cat1, String cat2) {
        return this.getScore(cat1, cat2);
    }
}

