/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz.strategy.dissimilarity;

import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.glozz.strategy.contingency.ComputeCategorialDistanceForBinominal;
import fr.unicaen.measure.glozz.strategy.dissimilarity.AbstractDissimilarityComputerCategorial;
import java.util.HashMap;
import java.util.Map;

public class DissimilarityComputerCategorialBinomialeCorrected
extends AbstractDissimilarityComputerCategorial {
    private ComputeCategorialDistanceForBinominal binomial;
    private double agreement;
    private Map<String, Double> trace = new HashMap<String, Double>();

    public void setBinomial(ComputeCategorialDistanceForBinominal binomial) {
        this.binomial = binomial;
    }

    public void setAgreement(double agreement) {
        System.out.println("Use agreement : " + agreement);
        this.agreement = agreement;
    }

    @Override
    protected double distCat(String cat1, String cat2) {
        String key = cat1 + "-" + cat2;
        if (!this.trace.containsKey(key)) {
            key = cat2 + "-" + cat1;
        }
        if (!this.trace.containsKey(key)) {
            double dis;
            if (cat1.equals(cat2)) {
                dis = 0.0;
            } else {
                try {
                    double bin = this.binomial.distanceCK(cat1, cat2);
                    dis = this.agreement * bin + (1.0 - this.agreement);
                }
                catch (MeasureException ex) {
                    ex.printStackTrace();
                    dis = 1.0;
                }
            }
            this.trace.put(key, dis);
        }
        return this.trace.get(key);
    }
}

