/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz.strategy.contingency;

import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.glozz.GlozzConstants;
import fr.unicaen.measure.glozz.model.CorpusSet;
import fr.unicaen.measure.glozz.model.EmptyUnit;
import fr.unicaen.measure.glozz.model.UnitaryAlignment;
import fr.unicaen.measure.glozz.model.UnitaryAlignmentSet;
import fr.unicaen.measure.glozz.strategy.alignment.AlignmentComputerSimple;
import fr.unicaen.measure.glozz.strategy.alignment.PossibleAlignmentComputerNibbler;
import fr.unicaen.measure.glozz.strategy.calculator.binomial.CustomDistributions;
import fr.unicaen.measure.glozz.strategy.calculator.binomial.LoiBinomiale;
import fr.unicaen.measure.glozz.strategy.dissimilarity.IDissimilarityComputer;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.IUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ComputeCategorialDistanceForBinominal
implements GlozzConstants {
    private Map<String, CustomDistributions> datas;
    private List<String> categoriesIndex;
    private int numberOfAnnotators;
    private boolean terminated = false;
    private Map<String, Double> cache = new HashMap<String, Double>();

    public ComputeCategorialDistanceForBinominal() {
        this(null);
    }

    public ComputeCategorialDistanceForBinominal(Set<String> categories) {
        if (categories != null) {
            this.categoriesIndex = new ArrayList<String>(categories);
        }
        this.datas = new HashMap<String, CustomDistributions>();
    }

    public void addCorpusSet(CorpusSet corpusSet, IDissimilarityComputer dissimilarityComputer) {
        for (ICorpus c : corpusSet) {
            this.addCorpus(c, dissimilarityComputer);
        }
    }

    public void addCorpus(ICorpus corpus, IDissimilarityComputer dissimilarityComputer) {
        Set cats = corpus.getUnitSet().getAnnotationSetByCategory().keySet();
        this.numberOfAnnotators = corpus.getUnitSet().getAnnotationSetByAuthor().keySet().size();
        if (this.categoriesIndex == null) {
            this.categoriesIndex = new ArrayList(cats);
        } else {
            for (String s : corpus.getUnitSet().getAnnotationSetByCategory().keySet()) {
                if (this.categoriesIndex.contains(s)) continue;
                this.categoriesIndex.add(s);
            }
        }
        AlignmentComputerSimple alignmentComputer = new AlignmentComputerSimple((double)this.numberOfAnnotators * 1.0);
        PossibleAlignmentComputerNibbler iPossibleAlignmentComputer = new PossibleAlignmentComputerNibbler();
        UnitaryAlignmentSet uas = alignmentComputer.getUnitaryAlignmentSet(corpus, dissimilarityComputer);
        UnitaryAlignmentSet alignment = iPossibleAlignmentComputer.calculate(uas);
        this.addAlignementSet(alignment);
    }

    public void addAlignementSet(UnitaryAlignmentSet alignements) {
        for (UnitaryAlignment ua : alignements) {
            this.addAlignement(ua);
        }
    }

    public void addAlignement(UnitaryAlignment alignement) {
        HashMap<String, Integer> count = new HashMap<String, Integer>();
        for (String c : this.categoriesIndex) {
            count.put(c, 0);
        }
        IUnit[] units = alignement.getUnits();
        for (int i = 0; i < units.length; ++i) {
            IUnit u = units[i];
            if (u == EmptyUnit.getInstance()) continue;
            Integer j = (Integer)count.get(u.getCategory());
            count.put(u.getCategory(), j + 1);
        }
        ArrayList counted = new ArrayList(count.keySet());
        for (int i = 0; i < counted.size(); ++i) {
            String catA = (String)counted.get(i);
            for (int j = 0; j < counted.size(); ++j) {
                String catB = (String)counted.get(j);
                this.addFeed(catA, catB, (Integer)count.get(catA), (Integer)count.get(catB));
            }
        }
    }

    public void addFeed(String c, String k, Integer lc, Integer lk) {
        int kIndex;
        int cIndex = this.categoriesIndex.indexOf(c);
        if (cIndex == (kIndex = this.categoriesIndex.indexOf(k))) {
            lc = lk;
            lk = 0;
        }
        if (lc + lk < 2) {
            return;
        }
        String key = cIndex + "-" + kIndex;
        if (!this.datas.containsKey(key) && !this.datas.containsKey(key = kIndex + "-" + cIndex)) {
            this.datas.put(key, new CustomDistributions(this.numberOfAnnotators));
        }
        this.datas.get(key).feedWith(Math.min(lc, lk), Math.max(lc, lk));
    }

    public double distanceCK(String c, String k) throws MeasureException {
        if (!this.terminated) {
            for (CustomDistributions d : this.datas.values()) {
                d.terminate();
            }
            this.terminated = true;
        }
        int cIndex = this.categoriesIndex.indexOf(c);
        int kIndex = this.categoriesIndex.indexOf(k);
        String key = cIndex + "-" + kIndex;
        if (!this.datas.containsKey(key) && !this.datas.containsKey(key = kIndex + "-" + cIndex)) {
            return kIndex == cIndex ? 1.0 : 0.0;
        }
        if (!this.cache.containsKey(key)) {
            System.out.println("Calculate for " + c + " <> " + k);
            try {
                double v = LoiBinomiale.chooseForObservedDistributions(this.datas.get(key), 0.01);
                this.cache.put(key, v);
                System.out.println(" = " + v);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new MeasureException(e.getMessage(), (Throwable)e);
            }
        }
        return this.cache.get(key);
    }
}

