/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz.strategy.contingency;

import com.jacksay.matrix.MatrixNumeric;
import fr.unicaen.measure.glozz.GlozzLogger;
import fr.unicaen.measure.glozz.model.CorpusSet;
import fr.unicaen.measure.glozz.model.EmptyUnit;
import fr.unicaen.measure.glozz.model.UnitaryAlignment;
import fr.unicaen.measure.glozz.model.UnitaryAlignmentSet;
import fr.unicaen.measure.glozz.strategy.alignment.AlignmentComputerSimple;
import fr.unicaen.measure.glozz.strategy.alignment.PossibleAlignmentComputerNibbler;
import fr.unicaen.measure.glozz.strategy.contingency.ICategorialContingencyMatrixComputer;
import fr.unicaen.measure.glozz.strategy.dissimilarity.IDissimilarityComputer;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.IUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CategorialContingencyMatrixComputerImpl
implements ICategorialContingencyMatrixComputer {
    private List<String> categories;
    private CorpusSet corpus;
    private MatrixNumeric<String> contingenceMatrix;

    public void calculateCategorialContingencyMatrix(CorpusSet corpusSet, IDissimilarityComputer dissimilarityComputer) {
        this.categories = new ArrayList<String>();
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        for (ICorpus c : corpusSet) {
            for (String s : c.getUnitSet().getAnnotationSetByCategory().keySet()) {
                if (this.categories.contains(s)) continue;
                this.categories.add(s);
                counter.put(s, 0);
            }
        }
        this.contingenceMatrix = new MatrixNumeric(this.categories, Double.valueOf(0.0));
        GlozzLogger.debug("{0} category(ies) found in corpus set : {1}", this.categories.size(), this.categories);
        AlignmentComputerSimple alignmentComputer = new AlignmentComputerSimple();
        PossibleAlignmentComputerNibbler iPossibleAlignmentComputer = new PossibleAlignmentComputerNibbler();
        for (ICorpus c : corpusSet) {
            UnitaryAlignmentSet uas = alignmentComputer.getUnitaryAlignmentSet(c, dissimilarityComputer);
            UnitaryAlignmentSet alignment = iPossibleAlignmentComputer.calculate(uas);
            GlozzLogger.prod("Given unitary alignement before nibbler : " + uas.size());
            GlozzLogger.prod("Given unitary after nibbler : " + alignment.size());
            int pairs = 0;
            for (UnitaryAlignment unitaryAlignment : alignment) {
                for (int i = 0; i < unitaryAlignment.givenSize() - 1; ++i) {
                    IUnit u = unitaryAlignment.getUnits()[i];
                    if (u == EmptyUnit.getInstance()) continue;
                    for (int j = i + 1; j < unitaryAlignment.givenSize(); ++j) {
                        IUnit v = unitaryAlignment.getUnits()[j];
                        if (v == EmptyUnit.getInstance()) continue;
                        String cu = u.getCategory();
                        String cv = v.getCategory();
                        double value = (Double)this.contingenceMatrix.getValue((Object)cu, (Object)cv) + 1.0;
                        this.contingenceMatrix.setValue((Object)cu, (Object)cv, (Object)value);
                        ++pairs;
                    }
                }
            }
            GlozzLogger.prod("Pairs with non-empty units: " + pairs);
        }
    }

    @Override
    public MatrixNumeric<String> getCategorialContingencyMatrix(CorpusSet corpusSet, IDissimilarityComputer dissimilarityComputer) {
        if (this.contingenceMatrix == null) {
            this.calculateCategorialContingencyMatrix(corpusSet, dissimilarityComputer);
        }
        return this.contingenceMatrix;
    }
}

