/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz.strategy.calculator.binomial;

import fr.unicaen.measure.glozz.strategy.calculator.binomial.CustomDistributions;
import fr.unicaen.measure.glozz.strategy.calculator.binomial.Distribution;
import fr.unicaen.measure.glozz.strategy.calculator.binomial.Distributions;

public class LoiBinomiale
extends Distributions {
    private double pAB;
    private double pNotAB;

    public LoiBinomiale(double pAB, int nAnnotators) {
        this.pAB = pAB;
        this.pNotAB = 1.0 - pAB;
        this.computeMatrixTillN(nAnnotators);
    }

    public static void show10() throws Exception {
        double step = 0.05;
        int total = (int)(0.5 / step);
        for (int i = 0; i <= total; ++i) {
            double pK = step * (double)i;
            LoiBinomiale loi = new LoiBinomiale(pK, 10);
            System.out.println("" + nf.format(2.0 * (0.5 - pK)).replace(',', '.') + "&" + nf.format(pK).replace(',', '.') + "&" + ((Distribution)loi.distributions.get(1)).toString());
        }
    }

    public static void test2() throws Exception {
        CustomDistributions custom = CustomDistributions.getTestInstance();
        System.out.println("Custom : " + custom.toString());
        System.out.println(LoiBinomiale.chooseForObservedDistributions(custom, 0.01));
    }

    public static void main(String[] args) throws Exception {
        LoiBinomiale.test2();
    }

    private void computeMatrixTillN(int n) {
        for (int nAnnotators = 2; nAnnotators <= n; ++nAnnotators) {
            this.add(new Distribution(this.computeForN(nAnnotators)));
        }
    }

    private double[] computeForN(int n) {
        int total = n / 2 + 1;
        double[] vals = new double[total];
        for (int i = 0; i < total; ++i) {
            vals[i] = this.computeForNRankI(n, i) * 100.0;
        }
        return vals;
    }

    private double computeForNRankI(int n, int k) {
        double p1 = this.pK(n, k);
        double p2 = this.pK(n, n - k);
        if (k == n / 2 && n % 2 == 0) {
            return p1;
        }
        return p1 + p2;
    }

    private double pK(int n, int k) {
        return (double)LoiBinomiale.cNP(n, k) * Math.pow(this.pAB, k) * Math.pow(this.pNotAB, n - k);
    }

    public static int cNP(int n, int p) {
        return LoiBinomiale.fact(n) / LoiBinomiale.fact(p) / LoiBinomiale.fact(n - p);
    }

    public static int fact(int n) {
        int fact = 1;
        for (int i = 2; i <= n; ++i) {
            fact *= i;
        }
        return fact;
    }

    public static double chooseForObservedDistributions(Distributions observed, double step) throws Exception {
        int total = (int)(1.0 / step);
        double[] results = new double[total + 1];
        double pkMin = 0.0;
        double valMin = 0.0;
        for (int i = 0; i <= total; ++i) {
            double pK = step * (double)i;
            LoiBinomiale loi = new LoiBinomiale(pK, 10);
            results[i] = Distributions.compareToRef(loi, observed);
            if (i == 0) {
                valMin = results[i];
                continue;
            }
            if (!(results[i] < valMin) || i > total / 2) continue;
            valMin = results[i];
            pkMin = pK;
        }
        double dist = (0.5 - pkMin) * 2.0;
        return dist;
    }
}

