/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz.strategy.calculator.binomial;

import fr.unicaen.measure.glozz.strategy.calculator.binomial.Distribution;
import java.text.NumberFormat;
import java.util.ArrayList;

public class Distributions {
    public static final int N_ANNOT = 10;
    protected ArrayList<Distribution> distributions = new ArrayList();
    public static final NumberFormat nf = NumberFormat.getInstance();

    public void add(Distribution d) {
        this.distributions.add(d);
    }

    public int size() {
        return this.distributions.size();
    }

    public static void printTab(double[] t) {
        for (double d : t) {
            System.out.print("" + d + "\t|\t");
        }
        System.out.println();
    }

    public static String tabToString(double[] t) {
        String s = "";
        for (double d : t) {
            s = s + nf.format(d).replace(',', '.') + " & ";
        }
        return s;
    }

    public String toString() {
        String s = "";
        s = s + "Distribution table\n";
        for (int i = 0; i < this.distributions.size(); ++i) {
            s = s + "" + (i + 2) + "\t|\t" + this.distributions.get(i) + "\n";
        }
        return s;
    }

    public static double compareToRef(Distributions ref, Distributions candidate) throws Exception {
        double d = 0.0;
        long totalOccurrences = 0L;
        for (int i = 0; i < candidate.size(); ++i) {
            long n = candidate.distributions.get(i).getNOccurrences() * (long)(i + 2);
            if (n == 0L) continue;
            totalOccurrences += n;
            d += Distribution.distance(ref.distributions.get(i), candidate.distributions.get(i)) * (double)n;
        }
        return d / (double)totalOccurrences;
    }

    static {
        nf.setMaximumFractionDigits(2);
    }
}

