/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz.strategy.calculator.binomial;

import fr.unicaen.measure.glozz.strategy.calculator.binomial.LoiBinomiale;

public class Distribution {
    private double[] values;
    private long nOccurrences;

    public Distribution(double[] values) {
        this(values, -1L);
    }

    public Distribution(double[] values, long nOccurrences) {
        this.values = values;
        this.nOccurrences = nOccurrences;
    }

    public void increment() {
        ++this.nOccurrences;
    }

    public void setValue(int rank, double v) {
        this.values[rank] = v;
    }

    public double getValue(int rank) {
        return this.values[rank];
    }

    public int size() {
        return this.values.length;
    }

    public long getNOccurrences() {
        return this.nOccurrences;
    }

    public String toString() {
        return LoiBinomiale.tabToString(this.values);
    }

    public void print() {
        LoiBinomiale.printTab(this.values);
    }

    public double distance(Distribution other) throws Exception {
        return Distribution.distance(this, other);
    }

    public static double distance(Distribution d1, Distribution d2) throws Exception {
        if (d1.values.length != d2.values.length) {
            throw new Exception("wrong comparison");
        }
        double d = 0.0;
        for (int i = 0; i < d1.values.length - 1; ++i) {
            d += Math.pow(d1.values[i] - d2.values[i], 2.0);
        }
        return d /= (double)(d1.values.length - 1);
    }
}

