/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz.strategy.calculator;

import fr.unicaen.measure.glozz.strategy.calculator.ArithmeticAverage;
import fr.unicaen.measure.glozz.strategy.calculator.IAverageCalculatorStrategy;

public class ReinforcingAverage
implements IAverageCalculatorStrategy {
    protected static final double DEFAULT_WEIGHT_LEST_CONSENSUAL_VALUE = 0.5;
    private double wMin = 0.5;
    private final double wMax = 1.0;
    private double[] valuesWeight;

    public ReinforcingAverage(double weightLessConsensualValue) {
        this.wMin = weightLessConsensualValue;
    }

    public ReinforcingAverage() {
        this(0.5);
    }

    @Override
    public double avg(double[] values) {
        return this.avg(values, 0.5);
    }

    @Override
    public double avg(double[] values, double d) {
        this.wMin = d;
        return this.avg1(values);
    }

    public double avg1(double[] values) {
        int i;
        this.valuesWeight = new double[values.length];
        double avgNormal = new ArithmeticAverage().avg(values);
        double maxWeight = 0.0;
        double sumWeight = 0.0;
        double sumValuesWeighted = 0.0;
        for (i = 0; i < values.length; ++i) {
            maxWeight = Math.max(maxWeight, Math.abs(values[i] - avgNormal));
        }
        if (maxWeight == 0.0) {
            return avgNormal;
        }
        for (i = 0; i < values.length; ++i) {
            double currentValue = values[i];
            double deltaValue = Math.abs(currentValue - avgNormal);
            double weight = (maxWeight - deltaValue) / maxWeight * 1.0 + deltaValue / maxWeight * this.wMin;
            double reinforcedValue = weight * currentValue;
            sumWeight += weight;
            sumValuesWeighted += reinforcedValue;
            this.valuesWeight[i] = weight;
        }
        double total = sumValuesWeighted / sumWeight;
        return total;
    }

    public double avgMin(double[] values) {
        int i;
        this.valuesWeight = new double[values.length];
        double avgNormal = new ArithmeticAverage().avg(values);
        double maxWeight = 0.0;
        double sumWeight = 0.0;
        double sumValuesWeighted = 0.0;
        for (i = 0; i < values.length; ++i) {
            maxWeight = Math.max(maxWeight, Math.abs(values[i] - avgNormal));
        }
        if (maxWeight == 0.0) {
            return avgNormal;
        }
        for (i = 0; i < values.length; ++i) {
            double currentValue = values[i];
            double deltaValue = Math.abs(currentValue - avgNormal);
            double weight = (maxWeight - deltaValue) / maxWeight * 1.0 + deltaValue / maxWeight * this.wMin;
            double reinforcedValue = weight * currentValue;
            sumWeight += weight;
            sumValuesWeighted += reinforcedValue;
            this.valuesWeight[i] = weight;
        }
        double total = sumValuesWeighted / sumWeight;
        return Math.min(total, avgNormal);
    }

    public double avgMax(double[] values) {
        int i;
        this.valuesWeight = new double[values.length];
        double avgNormal = new ArithmeticAverage().avg(values);
        double maxWeight = 0.0;
        double sumWeight = 0.0;
        double sumValuesWeighted = 0.0;
        for (i = 0; i < values.length; ++i) {
            maxWeight = Math.max(maxWeight, Math.abs(values[i] - avgNormal));
        }
        if (maxWeight == 0.0) {
            return avgNormal;
        }
        for (i = 0; i < values.length; ++i) {
            double currentValue = values[i];
            double deltaValue = Math.abs(currentValue - avgNormal);
            double weight = (maxWeight - deltaValue) / maxWeight * 1.0 + deltaValue / maxWeight * this.wMin;
            double reinforcedValue = weight * currentValue;
            sumWeight += weight;
            sumValuesWeighted += reinforcedValue;
            this.valuesWeight[i] = weight;
        }
        double total = sumValuesWeighted / sumWeight;
        return Math.max(total, avgNormal);
    }
}

