/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz.strategy.alignment;

import fr.unicaen.measure.glozz.GlozzLogger;
import fr.unicaen.measure.glozz.model.EmptyUnit;
import fr.unicaen.measure.glozz.model.UnitaryAlignment;
import fr.unicaen.measure.glozz.model.UnitaryAlignmentSet;
import fr.unicaen.measure.glozz.strategy.alignment.IPossibleAlignmentComputer;
import fr.unicaen.measure.model.IUnit;
import java.util.Iterator;

public class PossibleAlignmentComputerNibbler
implements IPossibleAlignmentComputer {
    private long total = 0L;

    @Override
    public UnitaryAlignmentSet calculate(UnitaryAlignmentSet unitaryAlignmentSet) {
        unitaryAlignmentSet.sortByWeight();
        this.nibble(unitaryAlignmentSet);
        GlozzLogger.debug("\n\n### PossibleAlignmentComputerNibbler give {0} alignment(s)", unitaryAlignmentSet.size());
        for (UnitaryAlignment alignment : unitaryAlignmentSet) {
            GlozzLogger.verbose(alignment);
        }
        return unitaryAlignmentSet;
    }

    private void nibble(UnitaryAlignmentSet unitaryAlignmentSet) {
        this.total = 0L;
        this.nibble(0, unitaryAlignmentSet);
    }

    private void nibble(int index, UnitaryAlignmentSet unitaries) {
        int current;
        this.total += (long)unitaries.size();
        if (index == unitaries.size()) {
            return;
        }
        UnitaryAlignment best = null;
        Iterator<UnitaryAlignment> iter = unitaries.iterator();
        for (current = -1; current < index; ++current) {
            best = iter.next();
        }
        if (best.isEmpty()) {
            unitaries.remove(best);
            this.nibble(current, unitaries);
            return;
        }
        GlozzLogger.debug("Remove alignment which have commons units with" + best);
        this.purgeAlignmentWithUnit(iter, best);
        this.nibble(++index, unitaries);
    }

    protected void purgeAlignmentWithUnit(Iterator<UnitaryAlignment> set, UnitaryAlignment exept) {
        block0: while (set.hasNext()) {
            UnitaryAlignment next = set.next();
            for (IUnit u : exept.getUnits()) {
                if (!next.contains(u) || u == EmptyUnit.getInstance()) continue;
                GlozzLogger.verbose("Purge " + next);
                set.remove();
                continue block0;
            }
        }
    }
}

